/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.infobrightoutput;

import java.io.IOException;
import java.io.OutputStream;
import java.sql.SQLException;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.infobrightoutput.InfobrightLoaderData;
import org.pentaho.di.trans.steps.infobrightoutput.InfobrightLoaderMeta;
import org.pentaho.di.trans.steps.infobrightoutput.KettleRecordPopulator;
import org.pentaho.di.trans.steps.infobrightoutput.Messages;
import org.pentaho.di.trans.steps.infobrightoutput.WindowsJNILibraryUtil;

public class InfobrightLoader
extends BaseStep
implements StepInterface {
    private final KettleRecordPopulator populator;
    private InfobrightLoaderMeta meta;
    private InfobrightLoaderData data;
    private boolean triedToClosePipe = false;

    public InfobrightLoader(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
        WindowsJNILibraryUtil.fixJavaLibraryPath();
        this.populator = new KettleRecordPopulator();
    }

    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        this.meta = (InfobrightLoaderMeta)smi;
        this.data = (InfobrightLoaderData)sdi;
        Object[] row = this.getRow();
        if (row == null) {
            this.setOutputDone();
            return false;
        }
        if (this.first) {
            this.first = false;
            this.data.outputRowMeta = this.getInputRowMeta().clone();
            this.meta.getFields(this.data.outputRowMeta, this.getStepname(), null, null, this);
            this.data.insertRowMeta = this.getInputRowMeta().clone();
        }
        try {
            Object[] outputRowData = this.writeToLoader(row, this.data.insertRowMeta);
            if (outputRowData != null) {
                this.putRow(this.data.outputRowMeta, row);
                this.incrementLinesOutput();
            }
            if (this.checkFeedback(this.getLinesRead()) && this.log.isBasic()) {
                this.logBasic("linenr " + this.getLinesRead());
            }
        }
        catch (Exception e) {
            this.logError("Because of an error, this step can't continue: " + e.getMessage());
            this.logError(Const.getStackTracker((Throwable)e));
            this.setErrors(1L);
            this.stopAll();
            this.setOutputDone();
            return false;
        }
        return true;
    }

    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        boolean res = false;
        this.meta = (InfobrightLoaderMeta)smi;
        this.data = (InfobrightLoaderData)sdi;
        if (super.init(smi, sdi)) {
            try {
                this.data.databaseSetup(this.meta, this);
                res = true;
            }
            catch (Exception ex) {
                this.logError("An error occurred intialising this step", ex);
                this.logError(Const.getStackTracker((Throwable)ex));
                this.stopAll();
                this.setErrors(1L);
                return false;
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        try {
            try {
                this.logBasic(Messages.getString("InfobrightLoader.Log.StartingToRun"));
                while (this.processRow(this.meta, this.data) && !this.isStopped()) {
                }
                this.closePipe();
            }
            catch (Exception e) {
                this.logError(Messages.getString("InfobrightLoader.Log.UnexpectedError") + " : " + e.toString());
                this.logError(Const.getStackTracker((Throwable)e));
                this.setErrors(1L);
                this.stopAll();
                Object var3_2 = null;
                this.safeClosePipe();
                this.dispose(this.meta, this.data);
                this.logSummary();
                this.markStop();
                return;
            }
            Object var3_1 = null;
            this.safeClosePipe();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.safeClosePipe();
            this.dispose(this.meta, this.data);
            this.logSummary();
            this.markStop();
            throw throwable;
        }
        this.dispose(this.meta, this.data);
        this.logSummary();
        this.markStop();
    }

    public void stopRunning(StepMetaInterface smi, StepDataInterface sdi) {
        if (this.data.loader != null) {
            this.logDebug("Trying to kill the loader statement...");
            try {
                this.data.loader.killQuery();
                this.logDebug("Loader statement killed.");
            }
            catch (SQLException sqle) {
                this.logError(Messages.getString("InfobrightLoader.Log.FailedToKillQuery") + " : " + sqle.toString());
                this.logError(Const.getStackTracker((Throwable)sqle));
            }
        }
    }

    private synchronized void closePipe() throws KettleException {
        try {
            block4: {
                try {
                    if (this.data == null) break block4;
                    this.data.dispose();
                }
                catch (Exception e) {
                    throw new KettleException((Throwable)e);
                }
            }
            Object var3_1 = null;
            this.triedToClosePipe = true;
        }
        catch (Throwable throwable) {
            Object var3_2 = null;
            this.triedToClosePipe = true;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void safeClosePipe() {
        if (!this.triedToClosePipe) {
            try {
                try {
                    this.closePipe();
                }
                catch (Exception e) {
                    this.logError(Messages.getString("InfobrightLoader.Log.UnexpectedError") + " : " + e.toString());
                    this.logError(Const.getStackTracker((Throwable)e));
                    Object var3_2 = null;
                    this.triedToClosePipe = true;
                }
                Object var3_1 = null;
                this.triedToClosePipe = true;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this.triedToClosePipe = true;
                throw throwable;
            }
        }
    }

    private Object[] writeToLoader(Object[] row, RowMetaInterface rowMeta) throws KettleException {
        Object[] outputRowData = row;
        try {
            this.populator.populate(this.data.record, row, rowMeta);
            this.data.record.writeTo((OutputStream)this.data.loader.getOutputStream());
            this.logRowlevel("loading: ...");
        }
        catch (IOException ex) {
            throw new KettleException((Throwable)ex);
        }
        return outputRowData;
    }
}

