/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui.olap;

import ca.sqlpower.architect.olap.MondrianModel;
import ca.sqlpower.architect.olap.OLAPRootObject;
import ca.sqlpower.architect.olap.OLAPSession;
import ca.sqlpower.architect.swingui.ArchitectSwingSession;
import ca.sqlpower.architect.swingui.PlayPenContentPane;
import ca.sqlpower.architect.swingui.olap.action.ExportSchemaAction;
import ca.sqlpower.architect.swingui.olap.action.ImportSchemaAction;
import ca.sqlpower.architect.swingui.olap.action.OLAPEditAction;
import ca.sqlpower.object.SPChildEvent;
import ca.sqlpower.object.SPListener;
import ca.sqlpower.swingui.SPSUtils;
import ca.sqlpower.util.TransactionEvent;
import com.jgoodies.forms.builder.ButtonStackBuilder;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.debug.FormDebugPanel;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.util.HashMap;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import org.apache.log4j.Logger;

public class OLAPSchemaManager {
    private static Logger logger = Logger.getLogger(OLAPSchemaManager.class);
    private JPanel panel;
    private JDialog d;
    private Window currentOwner;
    private ArchitectSwingSession session;
    private final Action editOLAPSchemaAction = new AbstractAction("Edit..."){

        @Override
        public void actionPerformed(ActionEvent e) {
            OLAPSession oSession = OLAPSchemaManager.this.getSelectedOSession();
            if (oSession != null) {
                new OLAPEditAction(OLAPSchemaManager.this.session, oSession).actionPerformed(e);
            }
        }
    };
    private final Action removeOLAPSchemaAction = new AbstractAction("Remove"){

        @Override
        public void actionPerformed(ActionEvent e) {
            OLAPSession oSession = OLAPSchemaManager.this.getSelectedOSession();
            if (oSession != null) {
                MondrianModel.Schema schema = oSession.getSchema();
                int option = JOptionPane.showConfirmDialog(OLAPSchemaManager.this.d, "Do you want to delete this OLAP Schema? " + schema.getName(), "Remove", 0);
                if (option != 0) {
                    return;
                }
                OLAPSchemaManager.this.session.getOLAPRootObject().removeOLAPSession(oSession);
                OLAPSchemaManager.this.editOLAPSchemaAction.setEnabled(false);
                OLAPSchemaManager.this.removeOLAPSchemaAction.setEnabled(false);
            }
        }
    };
    private final Action closeAction = new AbstractAction("Close"){

        @Override
        public void actionPerformed(ActionEvent e) {
            OLAPSchemaManager.this.d.dispose();
        }
    };
    private final Action exportSchemaAction = new AbstractAction("Export..."){

        @Override
        public void actionPerformed(ActionEvent e) {
            OLAPSession oSession = OLAPSchemaManager.this.getSelectedOSession();
            if (oSession != null) {
                ExportSchemaAction actualExportAction = new ExportSchemaAction(OLAPSchemaManager.this.session, oSession.getSchema());
                actualExportAction.actionPerformed(e);
            }
        }
    };
    private JTable osessionTable;
    private final List<OLAPSession> olapSessions;
    private final HashMap<OLAPSession, PlayPenContentPane> olapContentPanes;

    public OLAPSchemaManager(ArchitectSwingSession session) {
        this.session = session;
        this.olapSessions = session.getOLAPRootObject().getChildren();
        this.olapContentPanes = new HashMap();
        for (PlayPenContentPane olapCP : session.getWorkspace().getOlapContentPanes()) {
            if (this.olapSessions.contains(olapCP.getModelContainer())) {
                this.olapContentPanes.put((OLAPSession)olapCP.getModelContainer(), olapCP);
                continue;
            }
            throw new IllegalStateException("OLAPSessions listed under content panes do not match those under OLAP root");
        }
    }

    public void showDialog(Window owner) {
        if (this.d != null && this.d.isVisible() && this.currentOwner == owner) {
            this.d.setVisible(true);
            this.d.requestFocus();
            return;
        }
        if (this.d != null) {
            this.d.dispose();
        }
        if (this.panel == null) {
            this.panel = this.createPanel();
        }
        if (this.panel.getParent() != null) {
            this.panel.getParent().remove(this.panel);
        }
        if (owner instanceof Dialog) {
            this.d = new JDialog((Dialog)owner);
        } else if (owner instanceof Frame) {
            this.d = new JDialog((Frame)owner);
        } else {
            throw new IllegalArgumentException("Owner has to be a Frame or Dialog.  You provided a " + (owner == null ? null : owner.getClass().getName()));
        }
        this.currentOwner = owner;
        this.d.setTitle("OLAP Schema Manager");
        this.d.getContentPane().add(this.panel);
        this.d.pack();
        this.d.setLocationRelativeTo(owner);
        SPSUtils.makeJDialogCancellable((Window)this.d, (Action)this.closeAction);
        this.d.setVisible(true);
        this.d.requestFocus();
    }

    public void closeDialog() {
        if (this.d != null) {
            this.d.dispose();
        }
    }

    private JPanel createPanel() {
        FormLayout layout = new FormLayout("6dlu, fill:min(160dlu;default):grow, 6dlu, pref, 6dlu", " 6dlu,10dlu,6dlu,fill:min(180dlu;default):grow,10dlu");
        layout.setColumnGroups((int[][])new int[][]{{1, 3, 5}});
        CellConstraints cc = new CellConstraints();
        Object p = logger.isDebugEnabled() ? new FormDebugPanel(layout) : new JPanel((LayoutManager)layout);
        PanelBuilder pb = new PanelBuilder(layout, (JPanel)p);
        pb.setDefaultDialogBorder();
        pb.add((Component)new JLabel("Available OLAP Schemas"), cc.xy(2, 2));
        SchemaTableModel tm = new SchemaTableModel(this.session.getOLAPRootObject());
        this.osessionTable = new JTable(tm);
        this.osessionTable.setTableHeader(null);
        this.osessionTable.setShowGrid(false);
        this.osessionTable.setSelectionMode(0);
        this.osessionTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                boolean enableActions = OLAPSchemaManager.this.getSelectedOSession() != null;
                OLAPSchemaManager.this.removeOLAPSchemaAction.setEnabled(enableActions);
                OLAPSchemaManager.this.editOLAPSchemaAction.setEnabled(enableActions);
                OLAPSchemaManager.this.exportSchemaAction.setEnabled(enableActions);
                if (evt.getClickCount() == 2) {
                    OLAPSchemaManager.this.editOLAPSchemaAction.actionPerformed(null);
                }
            }
        });
        JScrollPane sp = new JScrollPane(this.osessionTable);
        pb.add((Component)sp, cc.xy(2, 4));
        ButtonStackBuilder bsb = new ButtonStackBuilder();
        JButton newOLAPSchemaButton = new JButton(new OLAPEditAction(this.session, null));
        newOLAPSchemaButton.setText("New...");
        bsb.addGridded((JComponent)newOLAPSchemaButton);
        bsb.addRelatedGap();
        JButton importOLAPSchemaButton = new JButton(new ImportSchemaAction(this.session));
        importOLAPSchemaButton.setText("Import...");
        bsb.addGridded((JComponent)importOLAPSchemaButton);
        bsb.addGridded((JComponent)new JButton(this.exportSchemaAction));
        bsb.addRelatedGap();
        bsb.addGridded((JComponent)new JButton(this.editOLAPSchemaAction));
        bsb.addRelatedGap();
        bsb.addGridded((JComponent)new JButton(this.removeOLAPSchemaAction));
        this.removeOLAPSchemaAction.setEnabled(false);
        this.editOLAPSchemaAction.setEnabled(false);
        this.exportSchemaAction.setEnabled(false);
        bsb.addUnrelatedGap();
        bsb.addGridded((JComponent)new JButton(this.closeAction));
        pb.add((Component)bsb.getPanel(), cc.xy(4, 4));
        return pb.getPanel();
    }

    public OLAPSession getSelectedOSession() {
        int selectedRow = this.osessionTable.getSelectedRow();
        if (selectedRow == -1) {
            return null;
        }
        return this.olapSessions.get(selectedRow);
    }

    public PlayPenContentPane getContentPane(OLAPSession session) {
        return this.olapContentPanes.get((Object)session);
    }

    private class SchemaTableModel
    extends AbstractTableModel
    implements SPListener {
        public SchemaTableModel(OLAPRootObject rootObj) {
            rootObj.addSPListener(this);
            for (OLAPSession osession : OLAPSchemaManager.this.olapSessions) {
                osession.getSchema().addSPListener(this);
            }
        }

        @Override
        public int getRowCount() {
            return OLAPSchemaManager.this.olapSessions == null ? 0 : OLAPSchemaManager.this.olapSessions.size();
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public String getColumnName(int columnIndex) {
            return "Schema";
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return MondrianModel.Schema.class;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            return OLAPSchemaManager.this.olapSessions == null ? null : ((OLAPSession)((Object)OLAPSchemaManager.this.olapSessions.get(rowIndex))).getSchema().getName();
        }

        public void childAdded(SPChildEvent e) {
            if (e.getChild() instanceof OLAPSession) {
                this.fireTableDataChanged();
                ((OLAPSession)e.getChild()).getSchema().addSPListener(this);
            }
        }

        public void childRemoved(SPChildEvent e) {
            if (e.getChild() instanceof OLAPSession) {
                this.fireTableDataChanged();
                ((OLAPSession)e.getChild()).getSchema().removeSPListener(this);
            }
        }

        public void propertyChanged(PropertyChangeEvent evt) {
            this.fireTableDataChanged();
        }

        public void transactionEnded(TransactionEvent e) {
        }

        public void transactionRollback(TransactionEvent e) {
        }

        public void transactionStarted(TransactionEvent e) {
        }
    }
}

