/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.tracklink.settings;

import com.almworks.tracklink.IssueLinkModel;
import com.almworks.tracklink.codelinks.CodeLinkType;
import com.almworks.tracklink.dialogs.DialogWrapperImpl;
import com.almworks.tracklink.settings.RefTypeEditForm;
import com.almworks.tracklink.settings.TrackerInstallHelper;
import com.almworks.tracklink.settings.wizards.PatternSettingsWizard;
import com.almworks.tracklink.util.ItemAdapter;
import com.almworks.tracklink.util.StringBundle;
import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.ui.FixedSizeButton;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.components.labels.LinkLabel;
import com.intellij.ui.components.labels.LinkListener;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ResourceBundle;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableModel;

public class ReferenceSettingsPanelForm {
    private JPanel myWholePanel;
    private JButton myRemoveButton;
    private JButton myEditButton;
    private JButton myAddButton;
    private JTable myTable;
    private JPanel myLinkPanel;
    private JCheckBox myStarterCheckBox;
    private JRadioButton myAutoDetectRadio;
    private JRadioButton mySpecifiedWorkspaceRadio;
    private JPanel myFileChooserPanel;
    private JRadioButton myIntegrateNone;
    private JRadioButton myIntegrateDeskzilla;
    private JRadioButton myIntegrateJIRAClient;
    private JLabel myIntegrateNoOptionHelper;
    private MouseListener myDoubleClickListener;
    private ListSelectionListener mySelectionListener;
    private AddTypeAction myAddTypeAction;
    private EditTypeAction myEditTypeAction;
    private RemoveTypeAction myRemoveTypeAction;
    private IssueLinkModel myModel;
    private ItemListener myStarterItemListener;
    private final PatternSettingsWizard[] myWizards;
    private ItemAdapter myWorkspaceItemAdapter;
    private JTextField myWorkspaceTextField;
    private DocumentAdapter myDocumentAdapter;
    private FixedSizeButton myBrowseButton;
    private JPanel myWorkspacePanel;

    public ReferenceSettingsPanelForm(IssueLinkModel model, PatternSettingsWizard[] wizards) {
        this.$$$setupUI$$$();
        this.myWorkspaceTextField = new JTextField(50);
        this.myModel = model;
        this.myWizards = wizards;
        this.myTable.setModel((TableModel)model.getListTableModel());
        this.myTable.setSelectionMode(0);
        this.myTable.setDefaultRenderer(String.class, new DefaultTableCellRenderer(){

            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                if (!isSelected) {
                    try {
                        if (column == 0) {
                            Pattern.compile((String)value, 2);
                        }
                        this.setForeground(UIManager.getColor("Table.foreground"));
                    }
                    catch (Exception e) {
                        this.setForeground(Color.RED);
                    }
                }
                return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            }
        });
        this.myAddTypeAction = new AddTypeAction();
        this.myAddButton.addActionListener(this.myAddTypeAction);
        this.myEditTypeAction = new EditTypeAction();
        this.myEditButton.addActionListener(this.myEditTypeAction);
        this.myRemoveTypeAction = new RemoveTypeAction();
        this.myRemoveButton.addActionListener(this.myRemoveTypeAction);
        this.mySelectionListener = new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                ReferenceSettingsPanelForm.this.updateButtons();
            }
        };
        this.myTable.getSelectionModel().addListSelectionListener(this.mySelectionListener);
        this.myDoubleClickListener = new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && SwingUtilities.isLeftMouseButton(e)) {
                    ReferenceSettingsPanelForm.this.myEditButton.doClick();
                }
            }
        };
        this.myTable.addMouseListener(this.myDoubleClickListener);
        this.myStarterCheckBox.setSelected(this.myModel.isAutoStartingAllowed());
        this.myStarterItemListener = new ItemAdapter(){

            protected void fireSelected(boolean isSelected) {
                ReferenceSettingsPanelForm.this.myModel.setAutoStartingAllowed(isSelected);
            }
        };
        this.myStarterCheckBox.addItemListener(this.myStarterItemListener);
        this.updateButtons();
        LinkLabel linkLabel = new LinkLabel(StringBundle.get("settings.weblink", new Object[0]), null, new LinkListener(){

            public void linkSelected(LinkLabel aSource, Object aLinkData) {
                BrowserUtil.launchBrowser((String)StringBundle.get("settings.weblink", new Object[0]));
            }
        });
        this.myLinkPanel.setLayout(new BorderLayout());
        this.myLinkPanel.add((Component)linkLabel, "West");
        this.initWorkspaceSettings();
        this.initIntegrateSettings();
    }

    private void initIntegrateSettings() {
        int integrateWith = this.myModel.getIntegrateWith();
        ButtonGroup group = new ButtonGroup();
        group.add(this.myIntegrateNone);
        group.add(this.myIntegrateDeskzilla);
        group.add(this.myIntegrateJIRAClient);
        boolean deskzillaInstalled = TrackerInstallHelper.isInstalled("deskzilla");
        boolean jiraclientInstalled = TrackerInstallHelper.isInstalled("jiraclient");
        if (integrateWith == 1) {
            this.myIntegrateDeskzilla.setSelected(true);
        } else if (integrateWith == 2) {
            this.myIntegrateJIRAClient.setSelected(true);
        } else {
            this.myIntegrateNone.setSelected(true);
        }
        this.myIntegrateDeskzilla.setVisible(this.myIntegrateDeskzilla.isSelected() || deskzillaInstalled);
        this.myIntegrateJIRAClient.setVisible(this.myIntegrateJIRAClient.isSelected() || jiraclientInstalled);
        boolean hasAny = this.myIntegrateDeskzilla.isVisible() || this.myIntegrateJIRAClient.isVisible();
        this.myIntegrateNoOptionHelper.setVisible(!hasAny);
        this.myStarterCheckBox.setVisible(hasAny);
        ActionListener listener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int value = ReferenceSettingsPanelForm.this.myIntegrateDeskzilla.isSelected() ? 1 : (ReferenceSettingsPanelForm.this.myIntegrateJIRAClient.isSelected() ? 2 : 0);
                ReferenceSettingsPanelForm.this.myModel.setIntegrateWith(value);
                boolean enabled = value != 0;
                ReferenceSettingsPanelForm.this.myStarterCheckBox.setEnabled(enabled);
                ReferenceSettingsPanelForm.this.myAutoDetectRadio.setEnabled(enabled);
                ReferenceSettingsPanelForm.this.mySpecifiedWorkspaceRadio.setEnabled(enabled);
                ReferenceSettingsPanelForm.this.updateWorkspaceDirectorySelectors(ReferenceSettingsPanelForm.this.myAutoDetectRadio.isSelected());
            }
        };
        this.myIntegrateDeskzilla.addActionListener(listener);
        this.myIntegrateJIRAClient.addActionListener(listener);
        this.myIntegrateNone.addActionListener(listener);
        listener.actionPerformed(null);
    }

    private void initWorkspaceSettings() {
        ButtonGroup buttongroup = new ButtonGroup();
        buttongroup.add(this.myAutoDetectRadio);
        buttongroup.add(this.mySpecifiedWorkspaceRadio);
        this.initFileChooserPanel();
        this.myWorkspaceItemAdapter = new ItemAdapter(){

            protected void fireSelected(boolean autoSelected) {
                ReferenceSettingsPanelForm.this.updateWorkspaceDirectorySelectors(autoSelected);
            }
        };
        this.myAutoDetectRadio.addItemListener(this.myWorkspaceItemAdapter);
        if (this.myModel.getAutodetectStatus()) {
            this.myAutoDetectRadio.setSelected(true);
        } else {
            this.mySpecifiedWorkspaceRadio.setSelected(true);
        }
        this.myDocumentAdapter = new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                ReferenceSettingsPanelForm.this.myModel.setDeskzillaWorkspace(ReferenceSettingsPanelForm.this.myWorkspaceTextField.getText());
            }
        };
        this.myWorkspaceTextField.getDocument().addDocumentListener((DocumentListener)this.myDocumentAdapter);
        this.myWorkspaceTextField.setText(this.myModel.getDeskzillaWorkspace());
        this.myAutoDetectRadio.setSelected(this.myModel.getAutodetectStatus());
    }

    private void updateWorkspaceDirectorySelectors(boolean autoSelected) {
        boolean integrate = !this.myIntegrateNone.isSelected();
        this.myWorkspaceTextField.setEnabled(!autoSelected && integrate);
        this.myBrowseButton.setEnabled(!autoSelected && integrate);
        this.myModel.setAutodetectStatus(autoSelected);
    }

    private void initFileChooserPanel() {
        this.myFileChooserPanel.setLayout(new BorderLayout(2, 0));
        this.myFileChooserPanel.add((Component)this.myWorkspaceTextField, "Center");
        this.myBrowseButton = new FixedSizeButton(this.myWorkspaceTextField.getPreferredSize().height);
        ComponentWithBrowseButton.MyDoClickAction.addTo((FixedSizeButton)this.myBrowseButton, (JComponent)this.myWorkspaceTextField);
        this.myFileChooserPanel.add((Component)this.myBrowseButton, "East");
        this.myBrowseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FileChooserDescriptor descriptor = FileChooserDescriptorFactory.getDirectoryChooserDescriptor((String)StringBundle.get("app.workspace", ReferenceSettingsPanelForm.this.myModel.getApplicationDisplayNameNotNull()));
                VirtualFile[] files = FileChooser.chooseFiles((Component)ReferenceSettingsPanelForm.this.myWorkspaceTextField, (FileChooserDescriptor)descriptor);
                if (files.length != 0) {
                    ReferenceSettingsPanelForm.this.myWorkspaceTextField.setText(FileUtil.toSystemDependentName((String)files[0].getPath()));
                    ReferenceSettingsPanelForm.this.myWorkspaceTextField.postActionEvent();
                }
            }
        });
    }

    private void updateButtons() {
        this.myEditButton.setEnabled(this.myEditTypeAction.isEnabled());
        this.myRemoveButton.setEnabled(this.myRemoveTypeAction.isEnabled());
    }

    public JComponent getComponent() {
        return this.myWholePanel;
    }

    public void detachListeners() {
        this.myTable.getSelectionModel().removeListSelectionListener(this.mySelectionListener);
        this.myTable.removeMouseListener(this.myDoubleClickListener);
        this.myAddButton.removeActionListener(this.myAddTypeAction);
        this.myEditButton.removeActionListener(this.myEditTypeAction);
        this.myRemoveButton.removeActionListener(this.myRemoveTypeAction);
        this.myStarterCheckBox.removeItemListener(this.myStarterItemListener);
        this.myAutoDetectRadio.removeItemListener(this.myWorkspaceItemAdapter);
        this.myWorkspaceTextField.getDocument().removeDocumentListener((DocumentListener)this.myDocumentAdapter);
    }

    public void refresh() {
        this.myStarterCheckBox.setSelected(this.myModel.isAutoStartingAllowed());
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JRadioButton jRadioButton;
        JRadioButton jRadioButton2;
        JPanel jPanel2;
        JCheckBox jCheckBox;
        JLabel jLabel;
        JRadioButton jRadioButton3;
        JRadioButton jRadioButton4;
        JRadioButton jRadioButton5;
        JButton jButton;
        JButton jButton2;
        JButton jButton3;
        JTable jTable;
        JPanel jPanel3;
        JPanel jPanel4;
        this.myWholePanel = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(0, 0, 0, 0), 4, -1, false, false));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(5, 5, 5, 5), 9, 9, false, false));
        jPanel4.add((Component)jPanel5, new GridConstraints(3, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("com/almworks/tracklink/util/StringBundle").getString("settings.version"));
        jPanel5.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 3, 0, 0, null, null, null));
        this.myLinkPanel = jPanel3 = new JPanel();
        jPanel5.add((Component)jPanel3, new GridConstraints(0, 1, 1, 1, 1, 3, 3, 0, null, null, null));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(0, 0, 0, 0), -1, 2, false, false));
        jPanel4.add((Component)jPanel6, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 7, null, null, null));
        jPanel6.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), ResourceBundle.getBundle("com/almworks/tracklink/util/StringBundle").getString("settings.border.text"), 0, 0, null, null));
        JScrollPane jScrollPane = new JScrollPane();
        jPanel6.add((Component)jScrollPane, new GridConstraints(0, 0, 4, 1, 0, 3, 7, 7, null, null, null));
        this.myTable = jTable = new JTable();
        jTable.setPreferredScrollableViewportSize(new Dimension(450, 150));
        jTable.setIntercellSpacing(new Dimension(1, 1));
        jScrollPane.setViewportView(jTable);
        this.myAddButton = jButton3 = new JButton();
        jButton3.setBorderPainted(true);
        this.$$$loadButtonText$$$(jButton3, ResourceBundle.getBundle("com/almworks/tracklink/util/StringBundle").getString("settings.action.add"));
        jButton3.setFocusCycleRoot(true);
        jPanel6.add((Component)jButton3, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myEditButton = jButton2 = new JButton();
        this.$$$loadButtonText$$$(jButton2, ResourceBundle.getBundle("com/almworks/tracklink/util/StringBundle").getString("settings.action.edit"));
        jPanel6.add((Component)jButton2, new GridConstraints(1, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myRemoveButton = jButton = new JButton();
        this.$$$loadButtonText$$$(jButton, ResourceBundle.getBundle("com/almworks/tracklink/util/StringBundle").getString("settings.action.remove"));
        jPanel6.add((Component)jButton, new GridConstraints(2, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel6.add((Component)spacer, new GridConstraints(3, 1, 1, 1, 0, 2, 1, 6, null, null, null));
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(5, 1, new Insets(0, 0, 0, 0), -1, 1, false, false));
        jPanel4.add((Component)jPanel7, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel7.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), ResourceBundle.getBundle("com/almworks/tracklink/util/StringBundle").getString("settings.integrate.border"), 0, 0, null, null));
        this.myIntegrateJIRAClient = jRadioButton5 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton5, ResourceBundle.getBundle("com/almworks/tracklink/util/StringBundle").getString("settings.integrate.jiraclient"));
        jPanel7.add((Component)jRadioButton5, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myIntegrateDeskzilla = jRadioButton4 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton4, ResourceBundle.getBundle("com/almworks/tracklink/util/StringBundle").getString("settings.integrate.deskzilla"));
        jPanel7.add((Component)jRadioButton4, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myIntegrateNone = jRadioButton3 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton3, ResourceBundle.getBundle("com/almworks/tracklink/util/StringBundle").getString("settings.integrate.none"));
        jPanel7.add((Component)jRadioButton3, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myIntegrateNoOptionHelper = jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("com/almworks/tracklink/util/StringBundle").getString("settings.integrate.noTrackerInstalled"));
        jPanel7.add((Component)jLabel, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myStarterCheckBox = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("com/almworks/tracklink/util/StringBundle").getString("settings.appstarter.text"));
        jPanel7.add((Component)jCheckBox, new GridConstraints(4, 0, 1, 1, 8, 1, 3, 0, null, null, null));
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel8, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myWorkspacePanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel8.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), ResourceBundle.getBundle("com/almworks/tracklink/util/StringBundle").getString("settings.workspace.border"), 0, 0, null, null));
        this.myAutoDetectRadio = jRadioButton2 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton2, ResourceBundle.getBundle("com/almworks/tracklink/util/StringBundle").getString("settings.workspace.autodetection"));
        jPanel2.add((Component)jRadioButton2, new GridConstraints(0, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        this.mySpecifiedWorkspaceRadio = jRadioButton = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton, ResourceBundle.getBundle("com/almworks/tracklink/util/StringBundle").getString("settings.workspace.manually"));
        jPanel2.add((Component)jRadioButton, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myFileChooserPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel, new GridConstraints(1, 1, 1, 1, 0, 3, 3, 3, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myWholePanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private class RemoveTypeAction
    extends AbstractAction {
        private RemoveTypeAction() {
        }

        public void actionPerformed(ActionEvent e) {
            int selectedRow;
            if (0 == Messages.showOkCancelDialog((Component)ReferenceSettingsPanelForm.this.myWholePanel, (String)StringBundle.get("codelink.remove.confirm", new Object[0]), (String)StringBundle.get("codelink.remove.title", new Object[0]), (Icon)Messages.getQuestionIcon()) && (selectedRow = ReferenceSettingsPanelForm.this.myTable.getSelectedRow()) != -1) {
                ReferenceSettingsPanelForm.this.myModel.remove(selectedRow);
            }
        }

        public boolean isEnabled() {
            return ReferenceSettingsPanelForm.this.myTable.getSelectedRow() != -1;
        }
    }

    private class EditTypeAction
    extends AbstractAction {
        private EditTypeAction() {
        }

        public void actionPerformed(ActionEvent e) {
            int selectedRow = ReferenceSettingsPanelForm.this.myTable.getSelectedRow();
            if (selectedRow == -1) {
                return;
            }
            CodeLinkType codeLinkType = ReferenceSettingsPanelForm.this.myModel.get(selectedRow);
            RefTypeEditForm refTypeEditForm = new RefTypeEditForm(codeLinkType, ReferenceSettingsPanelForm.this.myWizards);
            DialogWrapperImpl dialogWrapper = new DialogWrapperImpl(ReferenceSettingsPanelForm.this.myTable, refTypeEditForm, StringBundle.get("codelink.edit.title.edit", new Object[0]));
            dialogWrapper.show();
            refTypeEditForm.detachListeners();
            if (dialogWrapper.isOK()) {
                ReferenceSettingsPanelForm.this.myModel.replace(codeLinkType, new CodeLinkType(refTypeEditForm.getSearchPattern(), refTypeEditForm.getReplacePattern()));
            }
        }

        public boolean isEnabled() {
            return ReferenceSettingsPanelForm.this.myTable.getSelectedRow() != -1;
        }
    }

    private class AddTypeAction
    extends AbstractAction {
        private AddTypeAction() {
        }

        public void actionPerformed(ActionEvent e) {
            RefTypeEditForm refTypeEditForm = new RefTypeEditForm(new CodeLinkType(), ReferenceSettingsPanelForm.this.myWizards);
            DialogWrapperImpl dialogWrapper = new DialogWrapperImpl(ReferenceSettingsPanelForm.this.myTable, refTypeEditForm, StringBundle.get("codelink.edit.title.add", new Object[0]));
            dialogWrapper.show();
            refTypeEditForm.detachListeners();
            if (dialogWrapper.isOK()) {
                ReferenceSettingsPanelForm.this.myModel.add(new CodeLinkType(refTypeEditForm.getSearchPattern(), refTypeEditForm.getReplacePattern()));
            }
        }
    }
}

