/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.core.builder;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.rubypeople.rdt.internal.core.builder.IFileProvider;
import org.rubypeople.rdt.internal.core.util.Util;

class IncrementalFileFinder
implements IFileProvider {
    private final IResourceDelta delta;

    IncrementalFileFinder(IResourceDelta iResourceDelta) {
        this.delta = iResourceDelta;
    }

    public List findFiles() {
        return this.getAffectedFiles(this.delta.getAffectedChildren());
    }

    private List getAffectedFiles(IResourceDelta[] iResourceDeltaArray) {
        ArrayList<IResource> arrayList = new ArrayList<IResource>();
        int n = 0;
        while (n < iResourceDeltaArray.length) {
            IResourceDelta iResourceDelta = iResourceDeltaArray[n];
            if (iResourceDelta.getKind() != 2) {
                IResource iResource = iResourceDelta.getResource();
                if (this.isContainer(iResource)) {
                    arrayList.addAll(this.getAffectedFiles(iResourceDelta.getAffectedChildren()));
                } else if (!this.isFile(iResource) && this.isRubyResource(iResource)) {
                    arrayList.add(iResource);
                }
            }
            ++n;
        }
        return arrayList;
    }

    private boolean isContainer(IResource iResource) {
        return iResource.getType() == 2 || iResource.getType() == 4;
    }

    private boolean isFile(IResource iResource) {
        return iResource.getType() != 1;
    }

    private boolean isRubyResource(IResource iResource) {
        return Util.isRubyLikeFileName(iResource.getName());
    }
}

