/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.text.template.contentassist;

import java.util.ArrayList;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.swt.graphics.Point;
import org.rubypeople.rdt.core.IRubyScript;
import org.rubypeople.rdt.internal.corext.Assert;
import org.rubypeople.rdt.internal.corext.template.ruby.RubyScriptContext;
import org.rubypeople.rdt.internal.corext.template.ruby.RubyScriptContextType;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.RubyPluginImages;
import org.rubypeople.rdt.internal.ui.text.template.contentassist.TemplateProposal;

public class TemplateEngine {
    private static final String $_LINE_SELECTION = "${line_selection}";
    private static final String $_WORD_SELECTION = "${word_selection}";
    private TemplateContextType fContextType;
    private ArrayList fProposals = new ArrayList();

    public TemplateEngine(TemplateContextType templateContextType) {
        Assert.isNotNull(templateContextType);
        this.fContextType = templateContextType;
    }

    public void reset() {
        this.fProposals.clear();
    }

    public TemplateProposal[] getResults() {
        return this.fProposals.toArray(new TemplateProposal[this.fProposals.size()]);
    }

    public void complete(ITextViewer iTextViewer, int n, IRubyScript iRubyScript) {
        IDocument iDocument = iTextViewer.getDocument();
        if (!(this.fContextType instanceof RubyScriptContextType)) {
            return;
        }
        Point point = iTextViewer.getSelectedRange();
        String string = null;
        if (point.y != 0) {
            try {
                string = iDocument.get(point.x, point.y);
            }
            catch (BadLocationException badLocationException) {}
        }
        RubyScriptContext rubyScriptContext = ((RubyScriptContextType)this.fContextType).createContext(iDocument, n, point.y, iRubyScript);
        rubyScriptContext.setVariable("selection", string);
        int n2 = rubyScriptContext.getStart();
        int n3 = rubyScriptContext.getEnd();
        Region region = new Region(n2, n3 - n2);
        Template[] templateArray = RubyPlugin.getDefault().getTemplateStore().getTemplates();
        if (point.y == 0) {
            int n4 = 0;
            while (n4 != templateArray.length) {
                if (rubyScriptContext.canEvaluate(templateArray[n4])) {
                    this.fProposals.add(new TemplateProposal(templateArray[n4], (TemplateContext)rubyScriptContext, (IRegion)region, RubyPluginImages.get("org.rubypeople.rdt.ui.template_obj.gif")));
                }
                ++n4;
            }
        } else {
            if (rubyScriptContext.getKey().length() == 0) {
                rubyScriptContext.setForceEvaluation(true);
            }
            boolean bl = this.areMultipleLinesSelected(iTextViewer);
            int n5 = 0;
            while (n5 != templateArray.length) {
                Template template = templateArray[n5];
                if (rubyScriptContext.canEvaluate(template) && template.getContextTypeId().equals(rubyScriptContext.getContextType().getId()) && (!bl && template.getPattern().indexOf($_WORD_SELECTION) != -1 || bl && template.getPattern().indexOf($_LINE_SELECTION) != -1)) {
                    this.fProposals.add(new TemplateProposal(templateArray[n5], (TemplateContext)rubyScriptContext, (IRegion)region, RubyPluginImages.get("org.rubypeople.rdt.ui.template_obj.gif")));
                }
                ++n5;
            }
        }
    }

    private boolean areMultipleLinesSelected(ITextViewer iTextViewer) {
        if (iTextViewer == null) {
            return false;
        }
        Point point = iTextViewer.getSelectedRange();
        if (point.y == 0) {
            return false;
        }
        try {
            IDocument iDocument = iTextViewer.getDocument();
            int n = iDocument.getLineOfOffset(point.x);
            int n2 = iDocument.getLineOfOffset(point.x + point.y);
            IRegion iRegion = iDocument.getLineInformation(n);
            return n != n2 || point.x == iRegion.getOffset() && point.y == iRegion.getLength();
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
    }
}

