/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.TeamException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.tigris.subversion.subclipse.core.ISVNLocalFolder;
import org.tigris.subversion.subclipse.core.ISVNLocalResource;
import org.tigris.subversion.subclipse.core.SVNTeamProvider;
import org.tigris.subversion.subclipse.core.internal.InfiniteSubProgressMonitor;
import org.tigris.subversion.subclipse.core.resources.SVNWorkspaceRoot;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.actions.WorkspaceAction;

public class UnmanageAction
extends WorkspaceAction {
    private boolean deleteContent = false;

    public void execute(IAction action) throws InterruptedException, InvocationTargetException {
        if (this.confirmDeleteProjects()) {
            this.run(this.getOperation(), true, 1);
        }
    }

    private IRunnableWithProgress getOperation() {
        return new WorkspaceModifyOperation(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void execute(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    try {
                        Hashtable table = UnmanageAction.this.getProviderMapping(UnmanageAction.this.getSelectedResources());
                        Set keySet = table.keySet();
                        monitor.beginTask("", keySet.size() * 1000);
                        monitor.setTaskName(Policy.bind("Unmanage.unmanaging"));
                        Iterator iterator = keySet.iterator();
                        while (iterator.hasNext()) {
                            InfiniteSubProgressMonitor subMonitor = new InfiniteSubProgressMonitor(monitor, 1000);
                            subMonitor.beginTask(null, 100);
                            SVNTeamProvider provider = (SVNTeamProvider)iterator.next();
                            List list = (List)table.get(provider);
                            IResource[] providerResources = list.toArray(new IResource[list.size()]);
                            int i = 0;
                            while (i < providerResources.length) {
                                Object var12_13;
                                IResource resource = providerResources[i];
                                ISVNLocalFolder folder = SVNWorkspaceRoot.getSVNFolderFor((IContainer)((IContainer)resource));
                                try {
                                    if (UnmanageAction.this.deleteContent) {
                                        folder.unmanage(Policy.subMonitorFor((IProgressMonitor)subMonitor, 10));
                                    }
                                }
                                catch (Throwable throwable) {
                                    var12_13 = null;
                                    RepositoryProvider.unmap((IProject)((IProject)resource));
                                    throw throwable;
                                }
                                {
                                    var12_13 = null;
                                }
                                RepositoryProvider.unmap((IProject)((IProject)resource));
                                ++i;
                            }
                        }
                    }
                    catch (TeamException e) {
                        throw new InvocationTargetException(e);
                    }
                }
                catch (Throwable throwable) {
                    Object var14_16 = null;
                    monitor.done();
                    throw throwable;
                }
                {
                    Object var14_17 = null;
                }
                monitor.done();
            }
        };
    }

    boolean confirmDeleteProjects() {
        final int[] result = new int[1];
        IProject[] projects = this.getSelectedProjects();
        final DeleteProjectDialog dialog = new DeleteProjectDialog(this.shell, projects);
        this.shell.getDisplay().syncExec(new Runnable(){

            public void run() {
                result[0] = dialog.open();
            }
        });
        this.deleteContent = dialog.getDeleteContent();
        if (this.deleteContent && result[0] == 0) {
            String title = projects.length == 1 ? Policy.bind("Unmanage.title") : Policy.bind("Unmanage.titleN");
            return MessageDialog.openQuestion((Shell)this.shell, (String)title, (String)Policy.bind("Unmanage.deleteMeta"));
        }
        return result[0] == 0;
    }

    protected String getErrorTitle() {
        return Policy.bind("Unmanage.unmanagingError");
    }

    protected boolean isEnabledForSVNResource(ISVNLocalResource svnResource) {
        IResource resource = svnResource.getIResource();
        return resource != null && resource.getType() == 4;
    }

    static class DeleteProjectDialog
    extends MessageDialog {
        private boolean deleteContent = false;
        private Button radio1;
        private Button radio2;
        private SelectionListener selectionListener = new SelectionAdapter(this){
            final /* synthetic */ DeleteProjectDialog this$1;
            {
                this.this$1 = deleteProjectDialog;
            }

            public void widgetSelected(SelectionEvent e) {
                Button button = (Button)e.widget;
                if (button.getSelection()) {
                    DeleteProjectDialog.access$1(this.this$1, button == DeleteProjectDialog.access$0(this.this$1));
                }
            }
        };

        DeleteProjectDialog(Shell parentShell, IProject[] projects) {
            super(parentShell, DeleteProjectDialog.getTitle(projects), null, DeleteProjectDialog.getMessage(projects), 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 0);
        }

        static String getTitle(IProject[] projects) {
            if (projects.length == 1) {
                return Policy.bind("Unmanage.title");
            }
            return Policy.bind("Unmanage.titleN");
        }

        static String getMessage(IProject[] projects) {
            if (projects.length == 1) {
                IProject project = projects[0];
                return Policy.bind("Unmanage.message", project.getName());
            }
            return Policy.bind("Unmanage.messageN", new Integer(projects.length).toString());
        }

        protected Control createCustomArea(Composite parent) {
            Composite composite = new Composite(parent, 0);
            composite.setLayout((Layout)new GridLayout());
            this.radio1 = new Button(composite, 16);
            this.radio1.addSelectionListener(this.selectionListener);
            this.radio1.setText(Policy.bind("Unmanage.option2"));
            this.radio2 = new Button(composite, 16);
            this.radio2.addSelectionListener(this.selectionListener);
            this.radio2.setText(Policy.bind("Unmanage.option1"));
            this.radio1.setSelection(this.deleteContent);
            this.radio2.setSelection(!this.deleteContent);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.tigris.subversion.subclipse.ui.disconnect_action_context");
            return composite;
        }

        public boolean getDeleteContent() {
            return this.deleteContent;
        }

        static /* synthetic */ Button access$0(DeleteProjectDialog deleteProjectDialog) {
            return deleteProjectDialog.radio1;
        }

        static /* synthetic */ void access$1(DeleteProjectDialog deleteProjectDialog, boolean bl) {
            deleteProjectDialog.deleteContent = bl;
        }
    }
}

