/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.validation.internal;

import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Level;
import org.eclipse.jem.util.logger.LogEntry;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.wst.validation.internal.plugin.ValidationPlugin;

public class ResourceHandler {
    private static ResourceBundle _bundle = null;

    protected ResourceHandler() {
    }

    public static ResourceBundle getBundle() {
        block3: {
            if (_bundle == null) {
                try {
                    _bundle = ResourceBundle.getBundle(ValidationPlugin.getBundleName());
                }
                catch (MissingResourceException exc) {
                    _bundle = null;
                    Logger logger = ValidationPlugin.getPlugin().getMsgLogger();
                    if (!logger.isLoggingLevel(Level.FINE)) break block3;
                    LogEntry entry = ValidationPlugin.getLogEntry();
                    entry.setSourceID("org.eclipse.wst.validation.internal.operations.internal.ResourceHandler.getBundle()");
                    entry.setText("Cannot find bundle " + ValidationPlugin.getBundleName());
                    entry.setTargetException((Throwable)exc);
                    logger.write(Level.FINE, (Object)entry);
                }
            }
        }
        return _bundle;
    }

    public static String getExternalizedMessage(String key) {
        try {
            ResourceBundle bundle = ResourceHandler.getBundle();
            if (bundle == null) {
                Logger logger = ValidationPlugin.getPlugin().getMsgLogger();
                if (logger.isLoggingLevel(Level.FINE)) {
                    LogEntry entry = ValidationPlugin.getLogEntry();
                    entry.setSourceID("org.eclipse.wst.validation.internal.operations.internal.ResourceHandler.getExternalizedMessage(String)");
                    entry.setText("Resource bundle is null");
                    logger.write(Level.FINE, (Object)entry);
                }
                return key;
            }
            return bundle.getString(key);
        }
        catch (NullPointerException exc) {
            Logger logger = ValidationPlugin.getPlugin().getMsgLogger();
            if (logger.isLoggingLevel(Level.FINE)) {
                LogEntry entry = ValidationPlugin.getLogEntry();
                entry.setSourceID("org.eclipse.wst.validation.internal.operations.ui.ResourceHandler.getExternalizedMessage(String)");
                entry.setText("Cannot find message id " + key);
                entry.setTargetException((Throwable)exc);
                logger.write(Level.FINE, (Object)entry);
            }
            return key;
        }
    }

    public static String getExternalizedMessage(String key, String[] parms) {
        String res;
        block4: {
            res = "";
            try {
                res = MessageFormat.format(ResourceHandler.getExternalizedMessage(key), parms);
            }
            catch (MissingResourceException exc) {
                Logger logger = ValidationPlugin.getPlugin().getMsgLogger();
                if (logger.isLoggingLevel(Level.FINE)) {
                    LogEntry entry = ValidationPlugin.getLogEntry();
                    entry.setSourceID("org.eclipse.wst.validation.internal.operations.internal.ResourceHandler.getExternalizedMessage(String, String[])");
                    entry.setText("Cannot find message id " + key);
                    entry.setTargetException((Throwable)exc);
                    logger.write(Level.FINE, (Object)entry);
                }
            }
            catch (NullPointerException exc) {
                Logger logger = ValidationPlugin.getPlugin().getMsgLogger();
                if (!logger.isLoggingLevel(Level.FINE)) break block4;
                LogEntry entry = ValidationPlugin.getLogEntry();
                entry.setSourceID("org.eclipse.wst.validation.internal.operations.internal.ResourceHandler.getExternalizedMessage(String, String[])");
                entry.setText("Cannot format message id " + key + " with " + parms.length + " parameters.");
                entry.setTargetException((Throwable)exc);
                logger.write(Level.FINE, (Object)entry);
            }
        }
        return res;
    }
}

