/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.ui.internal;

import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerUtil;
import org.eclipse.wst.server.core.internal.ServerPlugin;

public class ServerPropertyTester
extends PropertyTester {
    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        if (expectedValue instanceof String) {
            return ServerPropertyTester.checkProperty(receiver, property, (String)expectedValue);
        }
        return ServerPropertyTester.checkProperty(receiver, property, null);
    }

    protected static boolean checkProperty(Object target, String property, String value) {
        if ("isRunnable".equals(property)) {
            IFileEditorInput fei;
            IFile file;
            if (target instanceof IProject) {
                return ServerUtil.getModule((IProject)((IProject)target)) != null;
            }
            boolean b = ServerPlugin.hasModuleArtifact((Object)target);
            if (b) {
                return true;
            }
            return target instanceof IFileEditorInput && (b = ServerPlugin.hasModuleArtifact((Object)(file = (fei = (IFileEditorInput)target).getFile())));
        }
        if ("serverType".equals(property)) {
            if (!(target instanceof IServer)) {
                return false;
            }
            IServer server = (IServer)target;
            String[] typeIds = ServerPlugin.tokenize((String)value, (String)",");
            return ServerPropertyTester.supportsServerType(server.getServerType().getId(), typeIds);
        }
        return false;
    }

    protected static boolean supportsServerType(String id, String[] typeIds) {
        if (id == null || id.length() == 0) {
            return false;
        }
        if (typeIds == null) {
            return false;
        }
        int size = typeIds.length;
        int i = 0;
        while (i < size) {
            if (typeIds[i].endsWith("*") ? id.length() >= typeIds[i].length() && id.startsWith(typeIds[i].substring(0, typeIds[i].length() - 1)) : id.equals(typeIds[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

