/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.common.properties.sections;

import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.URI;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.wst.common.uriresolver.internal.util.URIHelper;
import org.eclipse.wst.xsd.ui.internal.common.properties.sections.AbstractSection;
import org.eclipse.wst.xsd.ui.internal.common.util.Messages;
import org.eclipse.wst.xsd.ui.internal.editor.XSDEditorPlugin;
import org.eclipse.xsd.XSDInclude;
import org.eclipse.xsd.XSDRedefine;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.util.XSDParser;

public abstract class CommonDirectivesSection
extends AbstractSection {
    Text schemaLocationText;
    Button wizardButton;
    StyledText errorText;
    Color red;
    protected boolean isValidSchemaLocation = true;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doHandleEvent(Event event) {
        XSDSchema externalSchema;
        String namespace;
        String xsdModelFile;
        block14: {
            this.errorText.setText("");
            if (event.widget != this.schemaLocationText) return;
            String errorMessage = "";
            this.isValidSchemaLocation = true;
            xsdModelFile = this.schemaLocationText.getText();
            namespace = "";
            externalSchema = null;
            if (xsdModelFile.length() == 0) {
                this.handleSchemaLocationChange(xsdModelFile, "", null);
                return;
            }
            try {
                block13: {
                    try {
                        IFile currentIFile = ((IFileEditorInput)this.getActiveEditor().getEditorInput()).getFile();
                        URI newURI = URI.createURI((String)xsdModelFile);
                        String xsdFile = URIHelper.getRelativeURI((String)newURI.toString(), (String)currentIFile.getFullPath().toString());
                        String normalizedXSDFile = URIHelper.normalize((String)xsdFile, (String)currentIFile.getLocation().toString(), (String)"");
                        XSDParser parser = new XSDParser();
                        parser.parse(normalizedXSDFile);
                        externalSchema = parser.getSchema();
                        if (externalSchema != null) {
                            String extNamespace = externalSchema.getTargetNamespace();
                            if (extNamespace == null) {
                                extNamespace = "";
                            }
                            namespace = extNamespace;
                            if (externalSchema.getDiagnostics() != null && externalSchema.getDiagnostics().size() > 0) {
                                this.isValidSchemaLocation = false;
                                errorMessage = XSDEditorPlugin.getResourceString("_UI_INCORRECT_XML_SCHEMA", xsdModelFile);
                                break block13;
                            }
                            String currentNameSpace = this.xsdSchema.getTargetNamespace();
                            if (this.input instanceof XSDInclude || this.input instanceof XSDRedefine) {
                                if (extNamespace != null && currentNameSpace != null && !extNamespace.equals(currentNameSpace)) {
                                    errorMessage = XSDEditorPlugin.getResourceString("_UI_DIFFERENT_NAME_SPACE", xsdModelFile);
                                    this.isValidSchemaLocation = false;
                                }
                                break block13;
                            }
                            if (extNamespace != null && currentNameSpace != null && extNamespace.equals(currentNameSpace)) {
                                errorMessage = XSDEditorPlugin.getResourceString("_UI_SAME_NAME_SPACE", xsdModelFile);
                                this.isValidSchemaLocation = false;
                            }
                            break block13;
                        }
                        errorMessage = Messages._UI_ERROR_INVALID_FILE;
                        this.isValidSchemaLocation = false;
                    }
                    catch (Exception exception) {
                        errorMessage = Messages._UI_ERROR_INVALID_FILE;
                        this.isValidSchemaLocation = false;
                    }
                }
                Object var13_15 = null;
                if (this.isValidSchemaLocation) break block14;
            }
            catch (Throwable throwable) {
                Object var13_14 = null;
                if (!this.isValidSchemaLocation) {
                    this.errorText.setText(errorMessage);
                    int length = this.errorText.getText().length();
                    this.red = new Color(null, 255, 0, 0);
                    StyleRange style = new StyleRange(0, length, this.red, this.schemaLocationText.getBackground());
                    this.errorText.setStyleRange(style);
                    throw throwable;
                }
                this.handleSchemaLocationChange(xsdModelFile, namespace, externalSchema);
                throw throwable;
            }
            this.errorText.setText(errorMessage);
            int length = this.errorText.getText().length();
            this.red = new Color(null, 255, 0, 0);
            StyleRange style = new StyleRange(0, length, this.red, this.schemaLocationText.getBackground());
            this.errorText.setStyleRange(style);
            return;
        }
        this.handleSchemaLocationChange(xsdModelFile, namespace, externalSchema);
    }

    protected void handleSchemaLocationChange(String schemaFileString, String namespace, XSDSchema externalSchema) {
    }

    public void dispose() {
        super.dispose();
        if (this.red != null) {
            this.red.dispose();
            this.red = null;
        }
    }
}

