/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.rdb.internal.core.rte.fe;

import java.util.HashSet;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.Vector;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.wst.rdb.internal.core.containment.ContainmentServiceImpl;
import org.eclipse.wst.rdb.internal.core.rte.EngineeringOption;
import org.eclipse.wst.rdb.internal.core.rte.EngineeringOptionCategory;
import org.eclipse.wst.rdb.internal.models.sql.schema.SQLObject;

public class GenericDdlGenerationOptions {
    public static final byte GENERATE_FULLY_QUALIFIED_NAME = 0;
    public static final byte GENERATE_QUOTED_IDENTIFIER = 1;
    public static final byte GENERATE_DROP_STATEMENTS = 2;
    public static final byte GENERATE_CREATE_STATEMENTS = 3;
    public static final byte GENERATE_TABLES = 4;
    public static final byte GENERATE_INDICES = 5;
    public static final byte GENERATE_VIEWS = 6;
    public static final byte GENERATE_TRIGGERS = 7;
    public static final byte GENERATE_PK_CONSTRAINTS = 8;
    public static final byte GENERATE_FK_CONSTRAINTS = 9;

    public static EngineeringOption[] createDDLGenerationOptions(EngineeringOptionCategory[] categories) {
        ResourceBundle resource = ResourceBundle.getBundle("org.eclipse.wst.rdb.internal.core.rte.fe.GenericDdlGeneration");
        EngineeringOptionCategory general_options = null;
        EngineeringOptionCategory additional_element = null;
        int i = 0;
        while (i < categories.length) {
            if (categories[i].getId().equals("GENERATE_OPTIONS")) {
                general_options = categories[i];
            } else if (categories[i].getId().equals("GENERATE_ELEMENTS")) {
                additional_element = categories[i];
            }
            ++i;
        }
        Vector<EngineeringOption> optionVec = new Vector<EngineeringOption>();
        optionVec.add(new EngineeringOption("GENERATE_FULLY_QUALIFIED_NAME", resource.getString("GENERATE_FULLY_QUALIFIED_NAME"), resource.getString("GENERATE_FULLY_QUALIFIED_NAME_DES"), false, general_options));
        optionVec.add(new EngineeringOption("GENERATE_QUOTED_IDENTIFIER", resource.getString("GENERATE_QUOTED_IDENTIFIER"), resource.getString("GENERATE_QUOTED_IDENTIFIER_DES"), false, general_options));
        optionVec.add(new EngineeringOption("GENERATE_DROP_STATEMENTS", resource.getString("GENERATE_DROP_STATEMENTS"), resource.getString("GENERATE_DROP_STATEMENTS_DES"), false, general_options));
        optionVec.add(new EngineeringOption("GENERATE_CREATE_STATEMENTS", resource.getString("GENERATE_CREATE_STATEMENTS"), resource.getString("GENERATE_CREATE_STATEMENTS_DES"), true, general_options));
        optionVec.add(new EngineeringOption("GENERATE_TABLES", resource.getString("GENERATE_TABLES"), resource.getString("GENERATE_TABLES_DES"), true, additional_element));
        optionVec.add(new EngineeringOption("GENERATE_INDICES", resource.getString("GENERATE_INDEX"), resource.getString("GENERATE_INDEX_DES"), true, additional_element));
        optionVec.add(new EngineeringOption("GENERATE_VIEWS", resource.getString("GENERATE_VIEW"), resource.getString("GENERATE_VIEW_DES"), true, additional_element));
        optionVec.add(new EngineeringOption("GENERATE_TRIGGERS", resource.getString("GENERATE_TRIGGER"), resource.getString("GENERATE_TRIGGER_DES"), true, additional_element));
        optionVec.add(new EngineeringOption("GENERATE_PK_CONSTRAINTS", resource.getString("GENERATE_PK_CONSTRAINTS"), resource.getString("GENERATE_PK_CONSTRAINTS_DES"), true, additional_element));
        optionVec.add(new EngineeringOption("GENERATE_FK_CONSTRAINTS", resource.getString("GENERATE_FK_CONSTRAINTS"), resource.getString("GENERATE_FK_CONSTRAINTS_DES"), true, additional_element));
        Object[] options = new EngineeringOption[optionVec.size()];
        optionVec.copyInto(options);
        return options;
    }

    public static EngineeringOptionCategory[] createDDLGenerationOptionCategories() {
        ResourceBundle resource = ResourceBundle.getBundle("org.eclipse.wst.rdb.internal.core.rte.fe.GenericDdlGeneration");
        Vector<EngineeringOptionCategory> categoryVec = new Vector<EngineeringOptionCategory>();
        categoryVec.add(new EngineeringOptionCategory("GENERATE_OPTIONS", resource.getString("GENERATION_OPTIONS"), resource.getString("GENERATION_OPTIONS_DES")));
        categoryVec.add(new EngineeringOptionCategory("GENERATE_ELEMENTS", resource.getString("ADDITIONAL_ELEMENTS"), resource.getString("ADDITIONAL_ELEMENTS_DES")));
        Object[] categories = new EngineeringOptionCategory[categoryVec.size()];
        categoryVec.copyInto(categories);
        return categories;
    }

    public static Set getAllContainedDisplayableElementSet(SQLObject[] elements) {
        HashSet<SQLObject> s = new HashSet<SQLObject>();
        int i = 0;
        while (i < elements.length) {
            s.add(elements[i]);
            s.addAll(ContainmentServiceImpl.INSTANCE.getAllContainedDisplayableElements((EObject)elements[i]));
            ++i;
        }
        return s;
    }

    public static EngineeringOption getEngineeringOption(String id, EngineeringOptionCategory general_options, EngineeringOptionCategory additional_element) {
        ResourceBundle resource = ResourceBundle.getBundle("org.eclipse.wst.rdb.internal.core.rte.fe.GenericDdlGeneration");
        try {
            if (id.equalsIgnoreCase("GENERATE_FULLY_QUALIFIED_NAME")) {
                return new EngineeringOption(id, resource.getString("GENERATE_FULLY_QUALIFIED_NAME"), resource.getString("GENERATE_FULLY_QUALIFIED_NAME_DES"), false, general_options);
            }
            if (id.equalsIgnoreCase("GENERATE_QUOTED_IDENTIFIER")) {
                return new EngineeringOption(id, resource.getString("GENERATE_QUOTED_IDENTIFIER"), resource.getString("GENERATE_QUOTED_IDENTIFIER_DES"), false, general_options);
            }
            if (id.equalsIgnoreCase("GENERATE_DROP_STATEMENTS")) {
                return new EngineeringOption(id, resource.getString("GENERATE_DROP_STATEMENTS"), resource.getString("GENERATE_DROP_STATEMENTS_DES"), false, general_options);
            }
            if (id.equalsIgnoreCase("GENERATE_CREATE_STATEMENTS")) {
                return new EngineeringOption(id, resource.getString("GENERATE_CREATE_STATEMENTS"), resource.getString("GENERATE_CREATE_STATEMENTS_DES"), true, general_options);
            }
            if (id.equalsIgnoreCase("GENERATE_COMMENTS")) {
                return new EngineeringOption(id, resource.getString("GENERATE_COMMENTS"), resource.getString("GENERATE_COMMENTS_DES"), true, general_options);
            }
            if (id.equalsIgnoreCase("GENERATE_IN_TABLESPACE_CLAUSE")) {
                return new EngineeringOption(id, resource.getString("GENERATE_IN_TABLESPACE_CLAUSE"), resource.getString("GENERATE_IN_TABLESPACE_CLAUSE_DES"), true, general_options);
            }
            if (id.equalsIgnoreCase("USE_DOMAIN_IF_EXIST")) {
                return new EngineeringOption(id, resource.getString("GENERATE_USE_DOMAIN_IF_EXIST"), resource.getString("GENERATE_USE_DOMAIN_IF_EXIST_DES"), false, general_options);
            }
            if (id.equalsIgnoreCase("GENERATE_TABLES")) {
                return new EngineeringOption(id, resource.getString("GENERATE_TABLES"), resource.getString("GENERATE_TABLES_DES"), true, additional_element);
            }
            if (id.equalsIgnoreCase("GENERATE_TABLESPACES")) {
                return new EngineeringOption(id, resource.getString("GENERATE_TABLESPACES"), resource.getString("GENERATE_TABLESPACES_DES"), true, additional_element);
            }
            if (id.equalsIgnoreCase("GENERATE_INDICES")) {
                return new EngineeringOption(id, resource.getString("GENERATE_INDEX"), resource.getString("GENERATE_INDEX_DES"), true, additional_element);
            }
            if (id.equalsIgnoreCase("GENERATE_STOREDPROCEDURES")) {
                return new EngineeringOption(id, resource.getString("GENERATE_STOREDPROCEDURE"), resource.getString("GENERATE_STOREDPROCEDURE_DES"), true, additional_element);
            }
            if (id.equalsIgnoreCase("GENERATE_FUNCTIONS")) {
                return new EngineeringOption(id, resource.getString("GENERATE_FUNCTION"), resource.getString("GENERATE_FUNCTION_DES"), true, additional_element);
            }
            if (id.equalsIgnoreCase("GENERATE_VIEWS")) {
                return new EngineeringOption(id, resource.getString("GENERATE_VIEW"), resource.getString("GENERATE_VIEW_DES"), true, additional_element);
            }
            if (id.equalsIgnoreCase("GENERATE_TRIGGERS")) {
                return new EngineeringOption(id, resource.getString("GENERATE_TRIGGER"), resource.getString("GENERATE_TRIGGER_DES"), true, additional_element);
            }
            if (id.equalsIgnoreCase("GENERATE_SEQUENCES")) {
                return new EngineeringOption(id, resource.getString("GENERATE_SEQUENCE"), resource.getString("GENERATE_SEQUENCE_DES"), true, additional_element);
            }
            if (id.equalsIgnoreCase("GENERATE_USER_DEFINED_TYPE")) {
                return new EngineeringOption(id, resource.getString("GENERATE_USER_DEFINED_TYPE"), resource.getString("GENERATE_USER_DEFINED_TYPE_DES"), true, additional_element);
            }
            if (id.equalsIgnoreCase("GENERATE_PK_CONSTRAINTS")) {
                return new EngineeringOption(id, resource.getString("GENERATE_PK_CONSTRAINTS"), resource.getString("GENERATE_PK_CONSTRAINTS_DES"), true, additional_element);
            }
            if (id.equalsIgnoreCase("GENERATE_TABLESPACES")) {
                return new EngineeringOption(id, resource.getString("GENERATE_TABLESPACES"), resource.getString("GENERATE_TABLESPACES_DES"), true, additional_element);
            }
            if (id.equalsIgnoreCase("GENERATE_DATABASE")) {
                return new EngineeringOption(id, resource.getString("GENERATE_DATABASE"), resource.getString("GENERATE_DATABASE_DES"), true, additional_element);
            }
            if (id.equalsIgnoreCase("GENERATE_MQT")) {
                return new EngineeringOption(id, resource.getString("GENERATE_MQT"), resource.getString("GENERATE_MQT_DES"), true, additional_element);
            }
            if (id.equalsIgnoreCase("GENERATE_ALIAS")) {
                return new EngineeringOption(id, resource.getString("GENERATE_ALIAS"), resource.getString("GENERATE_ALIAS_DES"), true, additional_element);
            }
            if (id.equalsIgnoreCase("GENERATE_CK_CONSTRAINTS")) {
                return new EngineeringOption(id, resource.getString("GENERATE_CK_CONSTRAINTS"), resource.getString("GENERATE_CK_CONSTRAINTS_DES"), true, additional_element);
            }
            if (id.equalsIgnoreCase("GENERATE_FK_CONSTRAINTS")) {
                return new EngineeringOption(id, resource.getString("GENERATE_FK_CONSTRAINTS"), resource.getString("GENERATE_FK_CONSTRAINTS_DES"), true, additional_element);
            }
            if (id.equalsIgnoreCase("GENERATE_BUFFERPOOL")) {
                return new EngineeringOption(id, resource.getString("GENERATE_BUFFERPOOL"), resource.getString("GENERATE_BUFFERPOOL_DES"), true, additional_element);
            }
            if (id.equalsIgnoreCase("GENERATE_PARTITIONGROUP")) {
                return new EngineeringOption(id, resource.getString("GENERATE_PARTITIONGROUP"), resource.getString("GENERATE_PARTITIONGROUP_DES"), true, additional_element);
            }
            if (id.equalsIgnoreCase("GENERATE_SCHEMA")) {
                return new EngineeringOption(id, resource.getString("GENERATE_SCHEMA"), resource.getString("GENERATE_SCHEMA_DES"), true, additional_element);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }
}

