/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.java;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.CompletionRequestor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.text.JavaCodeReader;
import org.eclipse.jdt.internal.ui.text.java.ExperimentalResultCollector;
import org.eclipse.jdt.internal.ui.text.java.JavaMethodCompletionProposal;
import org.eclipse.jdt.internal.ui.text.java.JavaTextMessages;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jdt.ui.text.java.CompletionProposalCollector;
import org.eclipse.jdt.ui.text.java.ContentAssistInvocationContext;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposalComputer;
import org.eclipse.jdt.ui.text.java.JavaContentAssistInvocationContext;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationExtension;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;

public class JavaCompletionProposalComputer
implements IJavaCompletionProposalComputer {
    private String fErrorMessage;

    private boolean looksLikeMethod(JavaCodeReader reader) throws IOException {
        int curr = reader.read();
        while (curr != -1 && Character.isWhitespace((char)curr)) {
            curr = reader.read();
        }
        if (curr == -1) {
            return false;
        }
        return Character.isJavaIdentifierPart((char)curr) || Character.isJavaIdentifierStart((char)curr);
    }

    private int guessContextInformationPosition(ContentAssistInvocationContext context) {
        int contextPosition = context.getInvocationOffset();
        IDocument document = context.getDocument();
        try {
            JavaCodeReader reader = new JavaCodeReader();
            reader.configureBackwardReader(document, contextPosition, true, true);
            int nestingLevel = 0;
            int curr = reader.read();
            while (curr != -1) {
                if (')' == (char)curr) {
                    ++nestingLevel;
                } else if ('(' == (char)curr && --nestingLevel < 0) {
                    int start = reader.getOffset();
                    if (this.looksLikeMethod(reader)) {
                        return start + 1;
                    }
                }
                curr = reader.read();
            }
        }
        catch (IOException iOException) {}
        return contextPosition;
    }

    private List addContextInformations(JavaContentAssistInvocationContext context, int offset, IProgressMonitor monitor) {
        List proposals = this.internalComputeCompletionProposals(offset, context, monitor);
        ArrayList<ContextInformationWrapper> result = new ArrayList<ContextInformationWrapper>(proposals.size());
        for (ICompletionProposal proposal : proposals) {
            IContextInformation contextInformation = proposal.getContextInformation();
            if (contextInformation == null) continue;
            ContextInformationWrapper wrapper = new ContextInformationWrapper(contextInformation);
            wrapper.setContextInformationPosition(offset);
            result.add(wrapper);
        }
        return result;
    }

    public List computeContextInformation(ContentAssistInvocationContext context, IProgressMonitor monitor) {
        if (context instanceof JavaContentAssistInvocationContext) {
            JavaContentAssistInvocationContext javaContext = (JavaContentAssistInvocationContext)context;
            int contextInformationPosition = this.guessContextInformationPosition(javaContext);
            List result = this.addContextInformations(javaContext, contextInformationPosition, monitor);
            return result;
        }
        return Collections.EMPTY_LIST;
    }

    public List computeCompletionProposals(ContentAssistInvocationContext context, IProgressMonitor monitor) {
        if (context instanceof JavaContentAssistInvocationContext) {
            JavaContentAssistInvocationContext javaContext = (JavaContentAssistInvocationContext)context;
            return this.internalComputeCompletionProposals(context.getInvocationOffset(), javaContext, monitor);
        }
        return Collections.EMPTY_LIST;
    }

    private List internalComputeCompletionProposals(int offset, JavaContentAssistInvocationContext context, IProgressMonitor monitor) {
        String error;
        ArrayList proposals;
        ICompilationUnit unit = context.getCompilationUnit();
        if (unit == null) {
            return Collections.EMPTY_LIST;
        }
        ITextViewer viewer = context.getViewer();
        CompletionProposalCollector collector = this.createCollector(context);
        collector.setInvocationContext(context);
        try {
            Point selection = viewer.getSelectedRange();
            if (selection.y > 0) {
                collector.setReplacementLength(selection.y);
            }
            unit.codeComplete(offset, (CompletionRequestor)collector);
        }
        catch (JavaModelException x) {
            Shell shell = viewer.getTextWidget().getShell();
            if (x.isDoesNotExist() && !unit.getJavaProject().isOnClasspath((IJavaElement)unit)) {
                MessageDialog.openInformation((Shell)shell, (String)JavaTextMessages.CompletionProcessor_error_notOnBuildPath_title, (String)JavaTextMessages.CompletionProcessor_error_notOnBuildPath_message);
            }
            ErrorDialog.openError((Shell)shell, (String)JavaTextMessages.CompletionProcessor_error_accessing_title, (String)JavaTextMessages.CompletionProcessor_error_accessing_message, (IStatus)x.getStatus());
        }
        IJavaCompletionProposal[] javaProposals = collector.getJavaCompletionProposals();
        int contextInformationOffset = this.guessContextInformationPosition(context);
        if (contextInformationOffset != offset) {
            int i = 0;
            while (i < javaProposals.length) {
                if (javaProposals[i] instanceof JavaMethodCompletionProposal) {
                    JavaMethodCompletionProposal jmcp = (JavaMethodCompletionProposal)javaProposals[i];
                    jmcp.setContextInformationPosition(contextInformationOffset);
                }
                ++i;
            }
        }
        if ((proposals = new ArrayList(Arrays.asList(javaProposals))).size() == 0 && (error = collector.getErrorMessage()).length() > 0) {
            this.fErrorMessage = error;
        }
        return proposals;
    }

    protected CompletionProposalCollector createCollector(JavaContentAssistInvocationContext context) {
        if (PreferenceConstants.getPreferenceStore().getBoolean("content_assist_fill_method_arguments")) {
            return new ExperimentalResultCollector(context);
        }
        return new CompletionProposalCollector(context.getCompilationUnit());
    }

    public String getErrorMessage() {
        return this.fErrorMessage;
    }

    public void sessionStarted() {
    }

    public void sessionEnded() {
        this.fErrorMessage = null;
    }

    private static final class ContextInformationWrapper
    implements IContextInformation,
    IContextInformationExtension {
        private final IContextInformation fContextInformation;
        private int fPosition;

        public ContextInformationWrapper(IContextInformation contextInformation) {
            this.fContextInformation = contextInformation;
        }

        public String getContextDisplayString() {
            return this.fContextInformation.getContextDisplayString();
        }

        public Image getImage() {
            return this.fContextInformation.getImage();
        }

        public String getInformationDisplayString() {
            return this.fContextInformation.getInformationDisplayString();
        }

        public int getContextInformationPosition() {
            return this.fPosition;
        }

        public void setContextInformationPosition(int position) {
            this.fPosition = position;
        }

        public boolean equals(Object object) {
            if (object instanceof ContextInformationWrapper) {
                return this.fContextInformation.equals((Object)((ContextInformationWrapper)object).fContextInformation);
            }
            return this.fContextInformation.equals(object);
        }
    }
}

