/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.java;

import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.ChildListPropertyDescriptor;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.EnumConstantDeclaration;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ITrackedNodePosition;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.core.formatter.IndentManipulation;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility2;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.dom.NodeFinder;
import org.eclipse.jdt.internal.corext.util.Strings;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.preferences.JavaPreferencesSettings;
import org.eclipse.jdt.internal.ui.text.java.JavaTypeCompletionProposal;
import org.eclipse.jface.text.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension4;
import org.eclipse.text.edits.MalformedTreeException;

public class OverrideCompletionProposal
extends JavaTypeCompletionProposal
implements ICompletionProposalExtension4 {
    private IJavaProject fJavaProject;
    private String fMethodName;
    private String[] fParamTypes;

    public OverrideCompletionProposal(IJavaProject jproject, ICompilationUnit cu, String methodName, String[] paramTypes, int start, int length, String displayName, String completionProposal) {
        super(completionProposal, cu, start, length, null, displayName, 0);
        Assert.isNotNull((Object)jproject);
        Assert.isNotNull((Object)methodName);
        Assert.isNotNull((Object)paramTypes);
        Assert.isNotNull((Object)cu);
        this.fParamTypes = paramTypes;
        this.fMethodName = methodName;
        this.fJavaProject = jproject;
        StringBuffer buffer = new StringBuffer();
        buffer.append(completionProposal);
        buffer.append(" {};");
        this.setReplacementString(buffer.toString());
    }

    public CharSequence getPrefixCompletionText(IDocument document, int completionOffset) {
        return this.fMethodName;
    }

    protected boolean updateReplacementString(IDocument document, char trigger, int offset, ImportRewrite importRewrite) throws CoreException, BadLocationException {
        ASTRewrite rewrite;
        IMethodBinding[] bindings;
        Document buffer = new Document(document.get());
        int index = offset - 1;
        while (index >= 0 && Character.isJavaIdentifierPart(buffer.getChar(index))) {
            --index;
        }
        int length = offset - index - 1;
        buffer.replace(index + 1, length, " ");
        ASTParser parser = ASTParser.newParser((int)3);
        parser.setResolveBindings(true);
        parser.setStatementsRecovery(true);
        parser.setSource(buffer.get().toCharArray());
        parser.setUnitName(this.fCompilationUnit.getResource().getFullPath().toString());
        parser.setProject(this.fCompilationUnit.getJavaProject());
        CompilationUnit unit = (CompilationUnit)parser.createAST((IProgressMonitor)new NullProgressMonitor());
        ITypeBinding binding = null;
        ChildListPropertyDescriptor descriptor = null;
        ASTNode node = NodeFinder.perform((ASTNode)unit, index + 1, 0);
        if (node instanceof AnonymousClassDeclaration) {
            switch (node.getParent().getNodeType()) {
                case 14: {
                    binding = ((ClassInstanceCreation)node.getParent()).resolveTypeBinding();
                    break;
                }
                case 72: {
                    IMethodBinding methodBinding = ((EnumConstantDeclaration)node.getParent()).resolveConstructorBinding();
                    if (methodBinding == null) break;
                    binding = methodBinding.getDeclaringClass();
                }
            }
            descriptor = AnonymousClassDeclaration.BODY_DECLARATIONS_PROPERTY;
        } else if (node instanceof AbstractTypeDeclaration) {
            AbstractTypeDeclaration declaration = (AbstractTypeDeclaration)node;
            descriptor = declaration.getBodyDeclarationsProperty();
            binding = declaration.resolveBinding();
        }
        if (binding != null && (bindings = StubUtility2.getOverridableMethods((rewrite = ASTRewrite.create((AST)unit.getAST())).getAST(), binding, true)) != null && bindings.length > 0) {
            ArrayList<IMethodBinding> candidates = new ArrayList<IMethodBinding>(bindings.length);
            IMethodBinding method = null;
            index = 0;
            while (index < bindings.length) {
                if (bindings[index].getName().equals(this.fMethodName) && bindings[index].getParameterTypes().length == this.fParamTypes.length) {
                    candidates.add(bindings[index]);
                }
                ++index;
            }
            if (candidates.size() > 1) {
                method = Bindings.findMethodInHierarchy(binding, this.fMethodName, this.fParamTypes);
                if (method == null) {
                    ITypeBinding objectType = rewrite.getAST().resolveWellKnownType("java.lang.Object");
                    method = Bindings.findMethodInType(objectType, this.fMethodName, this.fParamTypes);
                }
            } else if (candidates.size() == 1) {
                method = (IMethodBinding)candidates.get(0);
            }
            if (method != null) {
                CodeGenerationSettings settings = JavaPreferencesSettings.getCodeGenerationSettings(this.fJavaProject);
                ListRewrite rewriter = rewrite.getListRewrite(node, descriptor);
                String key = method.getKey();
                MethodDeclaration stub = null;
                index = 0;
                while (index < bindings.length) {
                    if (key.equals(bindings[index].getKey())) {
                        stub = StubUtility2.createImplementationStub(this.fCompilationUnit, rewrite, importRewrite, bindings[index], binding.getName(), binding.isInterface(), settings);
                        if (stub == null) break;
                        rewriter.insertFirst((ASTNode)stub, null);
                        break;
                    }
                    ++index;
                }
                if (stub != null) {
                    Document contents = new Document(this.fCompilationUnit.getBuffer().getContents());
                    IRegion region = contents.getLineInformationOfOffset(this.getReplacementOffset());
                    ITrackedNodePosition position = rewrite.track(stub);
                    String indent = IndentManipulation.extractIndentString((String)contents.get(region.getOffset(), region.getLength()), (int)settings.tabWidth, (int)settings.indentWidth);
                    try {
                        rewrite.rewriteAST((IDocument)contents, this.fJavaProject.getOptions(true)).apply((IDocument)contents, 2);
                    }
                    catch (MalformedTreeException exception) {
                        JavaPlugin.log(exception);
                    }
                    catch (BadLocationException exception) {
                        JavaPlugin.log(exception);
                    }
                    this.setReplacementString(IndentManipulation.changeIndent((String)Strings.trimIndentation(contents.get(position.getStartPosition(), position.getLength()), settings.tabWidth, settings.indentWidth, false), (int)0, (int)settings.tabWidth, (int)settings.indentWidth, (String)indent, (String)TextUtilities.getDefaultLineDelimiter((IDocument)contents)));
                }
            }
        }
        return true;
    }

    public boolean isAutoInsertable() {
        return false;
    }
}

