/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.junit.util;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IRegion;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jdt.internal.junit.launcher.ITestKind;
import org.eclipse.jdt.internal.junit.launcher.TestKind;
import org.eclipse.jdt.internal.junit.launcher.TestKindRegistry;
import org.eclipse.jdt.internal.junit.ui.JUnitMessages;
import org.eclipse.jdt.internal.junit.ui.JUnitPlugin;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.PlatformUI;

public class TestSearchEngine {
    public static boolean isTestOrTestSuite(IType declaringType) throws JavaModelException {
        return !TestKindRegistry.getDefault().getKind(declaringType).isNull();
    }

    private List searchMethod(IProgressMonitor pm, IJavaSearchScope scope) throws CoreException {
        ArrayList typesFound = new ArrayList(200);
        this.searchMethod(typesFound, scope, pm);
        return typesFound;
    }

    private List searchMethod(List v, IJavaSearchScope scope, IProgressMonitor progressMonitor) throws CoreException {
        JUnitSearchResultCollector requestor = new JUnitSearchResultCollector(v);
        int matchRule = 24;
        SearchPattern suitePattern = SearchPattern.createPattern((String)"suite() Test", (int)1, (int)0, (int)matchRule);
        SearchParticipant[] participants = new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()};
        new SearchEngine().search(suitePattern, participants, scope, (SearchRequestor)requestor, progressMonitor);
        return v;
    }

    public static IType[] findTests(IRunnableContext context, final Object[] elements, final ITestKind testKind) throws InvocationTargetException, InterruptedException {
        final HashSet result = new HashSet();
        if (elements.length > 0) {
            IRunnableWithProgress runnable = new IRunnableWithProgress(){

                public void run(IProgressMonitor pm) throws InterruptedException {
                    testKind.createFinder().findTestsInContainer(elements, result, pm);
                }
            };
            context.run(true, true, runnable);
        }
        return result.toArray(new IType[result.size()]);
    }

    public static IType[] findTests(final Object[] elements) throws InvocationTargetException, InterruptedException {
        final HashSet result = new HashSet();
        if (elements.length > 0) {
            IRunnableWithProgress runnable = new IRunnableWithProgress(){

                public void run(IProgressMonitor pm) throws InterruptedException {
                    ArrayList kinds = TestKindRegistry.getDefault().getAllKinds();
                    int kindCount = kinds.size();
                    pm.beginTask("", kindCount);
                    int i = 0;
                    while (i < kindCount) {
                        TestKind kind = (TestKind)kinds.get(i);
                        kind.createFinder().findTestsInContainer(elements, result, (IProgressMonitor)new SubProgressMonitor(pm, 1));
                        if (!result.isEmpty()) break;
                        ++i;
                    }
                    pm.done();
                }
            };
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile(runnable);
        }
        return result.toArray(new IType[result.size()]);
    }

    public static void doFindJUnit3Tests(Object[] elements, Set result, IProgressMonitor pm) throws InterruptedException {
        int nElements = elements.length;
        pm.beginTask(JUnitMessages.TestSearchEngine_message_searching, nElements);
        try {
            int i = 0;
            while (i < nElements) {
                try {
                    TestSearchEngine.collectTypes(elements[i], (IProgressMonitor)new SubProgressMonitor(pm, 1), result);
                }
                catch (CoreException e) {
                    JUnitPlugin.log(e.getStatus());
                }
                if (pm.isCanceled()) {
                    throw new InterruptedException();
                }
                ++i;
            }
        }
        finally {
            pm.done();
        }
    }

    private static void collectTypes(Object element, IProgressMonitor pm, Set result) throws CoreException {
        pm.beginTask(JUnitMessages.TestSearchEngine_message_searching, 10);
        element = TestSearchEngine.computeScope(element);
        try {
            while (element instanceof ISourceReference && !(element instanceof ICompilationUnit)) {
                IType type;
                if (element instanceof IType && TestSearchEngine.isTestOrTestSuite(type = (IType)element)) {
                    result.add(type);
                    return;
                }
                element = ((IJavaElement)element).getParent();
            }
            if (element instanceof ICompilationUnit) {
                ICompilationUnit cu = (ICompilationUnit)element;
                IType[] types = cu.getAllTypes();
                int i = 0;
                while (i < types.length) {
                    IType type = types[i];
                    if (TestSearchEngine.isTestOrTestSuite(type)) {
                        result.add(type);
                    }
                    ++i;
                }
            } else if (element instanceof IJavaElement) {
                List testCases = TestSearchEngine.findTestCases((IJavaElement)element, (IProgressMonitor)new SubProgressMonitor(pm, 7));
                List suiteMethods = TestSearchEngine.searchSuiteMethods((IProgressMonitor)new SubProgressMonitor(pm, 3), (IJavaElement)element);
                while (!suiteMethods.isEmpty()) {
                    if (!testCases.contains(suiteMethods.get(0))) {
                        testCases.add(suiteMethods.get(0));
                    }
                    suiteMethods.remove(0);
                }
                result.addAll(testCases);
            }
        }
        finally {
            pm.done();
        }
    }

    private static List findTestCases(IJavaElement element, IProgressMonitor pm) throws JavaModelException {
        ArrayList<IType> found = new ArrayList<IType>();
        IJavaProject javaProject = element.getJavaProject();
        IType testCaseType = TestSearchEngine.testCaseType(javaProject);
        if (testCaseType == null) {
            return found;
        }
        IType[] subtypes = javaProject.newTypeHierarchy(testCaseType, TestSearchEngine.getRegion(element), pm).getAllSubtypes(testCaseType);
        if (subtypes == null) {
            throw new JavaModelException(new CoreException((IStatus)new Status(4, "org.eclipse.jdt.junit", 101, JUnitMessages.JUnitBaseLaunchConfiguration_error_notests, null)));
        }
        int i = 0;
        while (i < subtypes.length) {
            try {
                if (TestSearchEngine.hasValidModifiers(subtypes[i])) {
                    found.add(subtypes[i]);
                }
            }
            catch (JavaModelException e) {
                JUnitPlugin.log(e.getStatus());
            }
            ++i;
        }
        return found;
    }

    private static IType testCaseType(IJavaProject javaProject) {
        try {
            return javaProject.findType("junit.framework.TestCase");
        }
        catch (JavaModelException e) {
            JUnitPlugin.log(e.getStatus());
            return null;
        }
    }

    private static IRegion getRegion(IJavaElement element) throws JavaModelException {
        IRegion result = JavaCore.newRegion();
        if (element.getElementType() == 2) {
            IPackageFragmentRoot[] roots = ((IJavaProject)element).getPackageFragmentRoots();
            int i = 0;
            while (i < roots.length) {
                if (!roots[i].isArchive()) {
                    result.add((IJavaElement)roots[i]);
                }
                ++i;
            }
        } else {
            result.add(element);
        }
        return result;
    }

    public static Object computeScope(Object element) throws JavaModelException {
        if (element instanceof IFileEditorInput) {
            element = ((IFileEditorInput)element).getFile();
        }
        if (element instanceof IResource) {
            element = JavaCore.create((IResource)((IResource)element));
        }
        if (element instanceof IClassFile) {
            IClassFile cf = (IClassFile)element;
            element = cf.getType();
        }
        return element;
    }

    private static List searchSuiteMethods(IProgressMonitor pm, IJavaElement element) throws CoreException {
        IJavaSearchScope scope = SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{element}, (int)1);
        TestSearchEngine searchEngine = new TestSearchEngine();
        return searchEngine.searchMethod(pm, scope);
    }

    public static boolean hasValidModifiers(IType type) throws JavaModelException {
        if (Flags.isAbstract((int)type.getFlags())) {
            return false;
        }
        return Flags.isPublic((int)type.getFlags());
    }

    public static boolean isTestImplementor(IType type) throws JavaModelException {
        ITypeHierarchy typeHier = type.newSupertypeHierarchy(null);
        IType[] superInterfaces = typeHier.getAllInterfaces();
        int i = 0;
        while (i < superInterfaces.length) {
            if (superInterfaces[i].getFullyQualifiedName('.').equals("junit.framework.Test")) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean hasTestCaseType(IJavaProject javaProject) {
        return TestSearchEngine.testCaseType(javaProject) != null;
    }

    public static boolean hasTestAnnotation(IJavaProject project) {
        try {
            return project != null && project.findType("org.junit.Test") != null;
        }
        catch (JavaModelException javaModelException) {
            return false;
        }
    }

    private static class JUnitSearchResultCollector
    extends SearchRequestor {
        List fList;
        Set fFailed = new HashSet();
        Set fMatches = new HashSet();

        public JUnitSearchResultCollector(List list) {
            this.fList = list;
        }

        public void acceptSearchMatch(SearchMatch match) throws CoreException {
            Object enclosingElement = match.getElement();
            if (!(enclosingElement instanceof IMethod)) {
                return;
            }
            IMethod method = (IMethod)enclosingElement;
            IType declaringType = method.getDeclaringType();
            if (this.fMatches.contains(declaringType) || this.fFailed.contains(declaringType)) {
                return;
            }
            if (TestSearchEngine.isTestOrTestSuite(declaringType)) {
                this.fMatches.add(declaringType);
            } else {
                this.fFailed.add(declaringType);
            }
        }

        public void endReporting() {
            this.fList.addAll(this.fMatches);
        }
    }
}

