/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.peer.gtk;

import gnu.classpath.Pointer;
import gnu.java.awt.peer.gtk.GtkClipboard;
import gnu.java.awt.peer.gtk.GtkImage;
import java.awt.Image;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.StringBufferInputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;

public class GtkSelection
implements Transferable {
    private static Object requestLock = new Object();
    private final boolean clipboard;
    private boolean requestInProgress;
    private boolean mimeTypesDelivered;
    private DataFlavor[] dataFlavors;
    private boolean textDelivered;
    private String text;
    private boolean imageDelivered;
    private Pointer imagePointer;
    private Image image;
    private boolean urisDelivered;
    private List uris;
    private boolean bytesDelivered;
    private byte[] bytes;

    GtkSelection(GtkClipboard gtkClipboard) {
        this.clipboard = gtkClipboard == GtkClipboard.clipboard;
    }

    public DataFlavor[] getTransferDataFlavors() {
        DataFlavor[] dataFlavorArray;
        DataFlavor[] dataFlavorArray2;
        Object object = requestLock;
        synchronized (object) {
            block12: {
                try {
                    if (this.mimeTypesDelivered) {
                        dataFlavorArray2 = (DataFlavor[])this.dataFlavors.clone();
                        break block12;
                    }
                    while (this.requestInProgress) {
                        try {
                            requestLock.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    if (!this.mimeTypesDelivered) {
                        this.requestInProgress = true;
                        this.requestMimeTypes(this.clipboard);
                        while (!this.mimeTypesDelivered) {
                            try {
                                requestLock.wait();
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                        this.requestInProgress = false;
                    }
                    dataFlavorArray2 = this.dataFlavors;
                    if (!GtkClipboard.canCache) {
                        this.dataFlavors = null;
                        this.mimeTypesDelivered = false;
                    }
                    requestLock.notifyAll();
                }
                catch (Throwable throwable) {
                    Object var3_6 = null;
                    throw throwable;
                }
            }
            dataFlavorArray = null;
        }
        dataFlavorArray = dataFlavorArray2;
        return dataFlavorArray;
    }

    private void mimeTypesAvailable(String[] stringArray) {
        Object object = requestLock;
        synchronized (object) {
            ArrayList arrayList;
            try {
                if (stringArray == null) {
                    this.dataFlavors = new DataFlavor[0];
                } else {
                    arrayList = new ArrayList(stringArray.length + 1);
                    for (int i = 0; i < stringArray.length; ++i) {
                        try {
                            if (stringArray[i] == GtkClipboard.stringMimeType) {
                                arrayList.add(DataFlavor.stringFlavor);
                                arrayList.add(DataFlavor.plainTextFlavor);
                                continue;
                            }
                            if (stringArray[i] == GtkClipboard.imageMimeType) {
                                arrayList.add(DataFlavor.imageFlavor);
                                continue;
                            }
                            if (stringArray[i] == GtkClipboard.filesMimeType) {
                                arrayList.add(DataFlavor.javaFileListFlavor);
                                continue;
                            }
                            DataFlavor dataFlavor = new DataFlavor(stringArray[i]);
                            if (arrayList.contains(dataFlavor)) continue;
                            arrayList.add(dataFlavor);
                            continue;
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            classNotFoundException.printStackTrace();
                            continue;
                        }
                        catch (NullPointerException nullPointerException) {
                            nullPointerException.printStackTrace();
                        }
                    }
                    this.dataFlavors = new DataFlavor[arrayList.size()];
                    arrayList.toArray(this.dataFlavors);
                }
                this.mimeTypesDelivered = true;
                requestLock.notifyAll();
            }
            finally {
                arrayList = null;
            }
            return;
        }
    }

    public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        DataFlavor[] dataFlavorArray = this.getTransferDataFlavors();
        for (int i = 0; i < dataFlavorArray.length; ++i) {
            if (!dataFlavor.equals(dataFlavorArray[i])) continue;
            return true;
        }
        return false;
    }

    private String getText() {
        String string;
        String string2;
        Object object = requestLock;
        synchronized (object) {
            block12: {
                try {
                    if (this.textDelivered) {
                        string2 = this.text;
                        break block12;
                    }
                    while (this.requestInProgress) {
                        try {
                            requestLock.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    if (!this.textDelivered) {
                        this.requestInProgress = true;
                        this.requestText(this.clipboard);
                        while (!this.textDelivered) {
                            try {
                                requestLock.wait();
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                        this.requestInProgress = false;
                    }
                    string2 = this.text;
                    if (!GtkClipboard.canCache) {
                        this.text = null;
                        this.textDelivered = false;
                    }
                    requestLock.notifyAll();
                }
                catch (Throwable throwable) {
                    Object var3_6 = null;
                    throw throwable;
                }
            }
            string = null;
        }
        string = string2;
        return string;
    }

    private void textAvailable(String string) {
        Object object = requestLock;
        synchronized (object) {
            try {
                this.text = string;
                this.textDelivered = true;
                requestLock.notifyAll();
            }
            finally {
                Object var3_3 = null;
            }
            return;
        }
    }

    private Image getImage() {
        Image image;
        Image image2;
        Object object = requestLock;
        synchronized (object) {
            block13: {
                try {
                    if (this.imageDelivered) {
                        image2 = this.image;
                        break block13;
                    }
                    while (this.requestInProgress) {
                        try {
                            requestLock.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    if (!this.imageDelivered) {
                        this.requestInProgress = true;
                        this.requestImage(this.clipboard);
                        while (!this.imageDelivered) {
                            try {
                                requestLock.wait();
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                        this.requestInProgress = false;
                    }
                    if (this.imagePointer != null) {
                        this.image = new GtkImage(this.imagePointer);
                    }
                    this.imagePointer = null;
                    image2 = this.image;
                    if (!GtkClipboard.canCache) {
                        this.image = null;
                        this.imageDelivered = false;
                    }
                    requestLock.notifyAll();
                }
                catch (Throwable throwable) {
                    Object var3_6 = null;
                    throw throwable;
                }
            }
            image = null;
        }
        image = image2;
        return image;
    }

    private void imageAvailable(Pointer pointer) {
        Object object = requestLock;
        synchronized (object) {
            try {
                this.imagePointer = pointer;
                this.imageDelivered = true;
                requestLock.notifyAll();
            }
            finally {
                Object var3_3 = null;
            }
            return;
        }
    }

    private List getURIs() {
        List list2;
        List list3;
        Object object = requestLock;
        synchronized (object) {
            block12: {
                try {
                    if (this.urisDelivered) {
                        list3 = this.uris;
                        break block12;
                    }
                    while (this.requestInProgress) {
                        try {
                            requestLock.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    if (!this.urisDelivered) {
                        this.requestInProgress = true;
                        this.requestURIs(this.clipboard);
                        while (!this.urisDelivered) {
                            try {
                                requestLock.wait();
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                        this.requestInProgress = false;
                    }
                    list3 = this.uris;
                    if (!GtkClipboard.canCache) {
                        this.uris = null;
                        this.urisDelivered = false;
                    }
                    requestLock.notifyAll();
                }
                catch (Throwable throwable) {
                    Object var3_6 = null;
                    throw throwable;
                }
            }
            list2 = null;
        }
        list2 = list3;
        return list2;
    }

    private void urisAvailable(String[] stringArray) {
        Object object = requestLock;
        synchronized (object) {
            ArrayList arrayList;
            try {
                if (stringArray != null && stringArray.length != 0) {
                    arrayList = new ArrayList(stringArray.length);
                    for (int i = 0; i < stringArray.length; ++i) {
                        try {
                            URI uRI = new URI(stringArray[i]);
                            if (!uRI.getScheme().equals("file")) continue;
                            arrayList.add(new File(uRI));
                            continue;
                        }
                        catch (URISyntaxException uRISyntaxException) {
                            // empty catch block
                        }
                    }
                    this.uris = arrayList;
                }
                this.urisDelivered = true;
                requestLock.notifyAll();
            }
            finally {
                arrayList = null;
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] getBytes(String string) {
        Object object = requestLock;
        synchronized (object) {
            try {
                while (this.requestInProgress) {
                    try {
                        requestLock.wait();
                    }
                    catch (InterruptedException interruptedException) {
                    }
                }
                this.requestInProgress = true;
                this.requestBytes(this.clipboard, string);
                while (!this.bytesDelivered) {
                    try {
                        requestLock.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                byte[] byArray = this.bytes;
                this.bytes = null;
                this.bytesDelivered = false;
                this.requestInProgress = false;
                requestLock.notifyAll();
                return byArray;
            }
            finally {
                byte[] byArray = null;
            }
        }
    }

    private void bytesAvailable(byte[] byArray) {
        Object object = requestLock;
        synchronized (object) {
            try {
                this.bytes = byArray;
                this.bytesDelivered = true;
                requestLock.notifyAll();
            }
            finally {
                Object var3_3 = null;
            }
            return;
        }
    }

    public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException {
        Object object;
        if (dataFlavor.equals(DataFlavor.stringFlavor) && (object = this.getText()) != null) {
            return object;
        }
        if (dataFlavor.equals(DataFlavor.plainTextFlavor) && (object = this.getText()) != null) {
            return new StringBufferInputStream((String)object);
        }
        if (dataFlavor.equals(DataFlavor.imageFlavor) && (object = this.getImage()) != null) {
            return object;
        }
        if (dataFlavor.equals(DataFlavor.javaFileListFlavor) && (object = this.getURIs()) != null) {
            return object;
        }
        object = this.getBytes(dataFlavor.getMimeType());
        if (object == null) {
            throw new UnsupportedFlavorException(dataFlavor);
        }
        if (dataFlavor.isMimeTypeSerializedObject()) {
            try {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream((byte[])object);
                ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
                return objectInputStream.readObject();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            catch (ClassNotFoundException classNotFoundException) {
                classNotFoundException.printStackTrace();
            }
        }
        if (dataFlavor.isRepresentationClassInputStream()) {
            return new ByteArrayInputStream((byte[])object);
        }
        throw new UnsupportedFlavorException(dataFlavor);
    }

    private native void requestText(boolean var1);

    private native void requestImage(boolean var1);

    private native void requestURIs(boolean var1);

    private native void requestBytes(boolean var1, String var2);

    private native void requestMimeTypes(boolean var1);
}

