/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.nio.charset;

import gnu.java.nio.charset.Cp424;
import gnu.java.nio.charset.Cp437;
import gnu.java.nio.charset.Cp737;
import gnu.java.nio.charset.Cp775;
import gnu.java.nio.charset.Cp850;
import gnu.java.nio.charset.Cp852;
import gnu.java.nio.charset.Cp855;
import gnu.java.nio.charset.Cp857;
import gnu.java.nio.charset.Cp860;
import gnu.java.nio.charset.Cp861;
import gnu.java.nio.charset.Cp862;
import gnu.java.nio.charset.Cp863;
import gnu.java.nio.charset.Cp864;
import gnu.java.nio.charset.Cp865;
import gnu.java.nio.charset.Cp866;
import gnu.java.nio.charset.Cp869;
import gnu.java.nio.charset.Cp874;
import gnu.java.nio.charset.ISO_8859_1;
import gnu.java.nio.charset.ISO_8859_13;
import gnu.java.nio.charset.ISO_8859_15;
import gnu.java.nio.charset.ISO_8859_2;
import gnu.java.nio.charset.ISO_8859_3;
import gnu.java.nio.charset.ISO_8859_4;
import gnu.java.nio.charset.ISO_8859_5;
import gnu.java.nio.charset.ISO_8859_6;
import gnu.java.nio.charset.ISO_8859_7;
import gnu.java.nio.charset.ISO_8859_8;
import gnu.java.nio.charset.ISO_8859_9;
import gnu.java.nio.charset.KOI_8;
import gnu.java.nio.charset.MS874;
import gnu.java.nio.charset.MacCentralEurope;
import gnu.java.nio.charset.MacCroatian;
import gnu.java.nio.charset.MacCyrillic;
import gnu.java.nio.charset.MacDingbat;
import gnu.java.nio.charset.MacGreek;
import gnu.java.nio.charset.MacIceland;
import gnu.java.nio.charset.MacRoman;
import gnu.java.nio.charset.MacRomania;
import gnu.java.nio.charset.MacSymbol;
import gnu.java.nio.charset.MacThai;
import gnu.java.nio.charset.MacTurkish;
import gnu.java.nio.charset.US_ASCII;
import gnu.java.nio.charset.UTF_16;
import gnu.java.nio.charset.UTF_16BE;
import gnu.java.nio.charset.UTF_16LE;
import gnu.java.nio.charset.UTF_8;
import gnu.java.nio.charset.UnicodeLittle;
import gnu.java.nio.charset.Windows1250;
import gnu.java.nio.charset.Windows1251;
import gnu.java.nio.charset.Windows1252;
import gnu.java.nio.charset.Windows1253;
import gnu.java.nio.charset.Windows1254;
import gnu.java.nio.charset.Windows1255;
import gnu.java.nio.charset.Windows1256;
import gnu.java.nio.charset.Windows1257;
import gnu.java.nio.charset.Windows1258;
import java.nio.charset.Charset;
import java.nio.charset.spi.CharsetProvider;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;

public final class Provider
extends CharsetProvider {
    private static Provider singleton;
    private final HashMap canonicalNames = new HashMap();
    private final HashMap charsets = new HashMap();
    private boolean extendedLoaded = false;

    Provider() {
        this.addCharset(new US_ASCII());
        this.addCharset(new ISO_8859_1());
        this.addCharset(new UTF_8());
        this.addCharset(new UTF_16BE());
        this.addCharset(new UTF_16LE());
        this.addCharset(new UTF_16());
        this.addCharset(new UnicodeLittle());
        this.addCharset(new Windows1250());
        this.addCharset(new Windows1251());
        this.addCharset(new Windows1252());
        this.addCharset(new Windows1253());
        this.addCharset(new Windows1254());
        this.addCharset(new Windows1257());
        this.addCharset(new ISO_8859_2());
        this.addCharset(new ISO_8859_4());
        this.addCharset(new ISO_8859_5());
        this.addCharset(new ISO_8859_7());
        this.addCharset(new ISO_8859_9());
        this.addCharset(new ISO_8859_13());
        this.addCharset(new ISO_8859_15());
        this.addCharset(new KOI_8());
    }

    private synchronized void loadExtended() {
        if (this.extendedLoaded) {
            return;
        }
        this.addCharset(new ISO_8859_3());
        this.addCharset(new ISO_8859_6());
        this.addCharset(new ISO_8859_8());
        this.addCharset(new Cp424());
        this.addCharset(new Cp437());
        this.addCharset(new Cp737());
        this.addCharset(new Cp775());
        this.addCharset(new Cp850());
        this.addCharset(new Cp852());
        this.addCharset(new Cp855());
        this.addCharset(new Cp857());
        this.addCharset(new Cp860());
        this.addCharset(new Cp861());
        this.addCharset(new Cp862());
        this.addCharset(new Cp863());
        this.addCharset(new Cp864());
        this.addCharset(new Cp865());
        this.addCharset(new Cp866());
        this.addCharset(new Cp869());
        this.addCharset(new Cp874());
        this.addCharset(new MacCentralEurope());
        this.addCharset(new MacCroatian());
        this.addCharset(new MacCyrillic());
        this.addCharset(new MacDingbat());
        this.addCharset(new MacGreek());
        this.addCharset(new MacIceland());
        this.addCharset(new MacRoman());
        this.addCharset(new MacRomania());
        this.addCharset(new MacSymbol());
        this.addCharset(new MacThai());
        this.addCharset(new MacTurkish());
        this.addCharset(new MS874());
        this.addCharset(new Windows1255());
        this.addCharset(new Windows1256());
        this.addCharset(new Windows1258());
        this.extendedLoaded = true;
    }

    public Iterator charsets() {
        this.loadExtended();
        return Collections.unmodifiableCollection(this.charsets.values()).iterator();
    }

    public Charset charsetForName(String string) {
        Charset charset = (Charset)this.charsets.get(this.canonicalNames.get(string.toLowerCase()));
        if (charset == null) {
            this.loadExtended();
            charset = (Charset)this.charsets.get(this.canonicalNames.get(string.toLowerCase()));
        }
        return charset;
    }

    private void addCharset(Charset charset) {
        String string = charset.name().toLowerCase();
        this.charsets.put(string, charset);
        this.canonicalNames.put(string, string);
        Iterator iterator = charset.aliases().iterator();
        while (iterator.hasNext()) {
            this.canonicalNames.put(((String)iterator.next()).toLowerCase(), string);
        }
    }

    public static synchronized Provider provider() {
        if (singleton == null) {
            singleton = (Provider)AccessController.doPrivileged(new PrivilegedAction(null){
                private /* synthetic */ Provider this$0;
                {
                    this.this$0 = provider;
                }

                public Object run() {
                    return new Provider();
                }
            });
        }
        return singleton;
    }
}

