/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.nio.charset;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;

final class US_ASCII
extends Charset {
    US_ASCII() {
        super("US-ASCII", new String[]{"iso-ir-6", "ANSI_X3.4-1986", "ISO_646.irv:1991", "ASCII", "ISO646-US", "ASCII", "us", "IBM367", "cp367", "csASCII", "ANSI_X3.4-1968", "iso_646.irv:1983", "ascii7", "646", "windows-20127"});
    }

    public boolean contains(Charset charset) {
        return charset instanceof US_ASCII;
    }

    public CharsetDecoder newDecoder() {
        return new Decoder(this);
    }

    public CharsetEncoder newEncoder() {
        return new Encoder(this);
    }

    private static final class Encoder
    extends CharsetEncoder {
        Encoder(Charset charset) {
            super(charset, 1.0f, 1.0f);
        }

        public boolean canEncode(char c) {
            return c <= '\u007f';
        }

        public boolean canEncode(CharSequence charSequence) {
            for (int i = 0; i < charSequence.length(); ++i) {
                if (this.canEncode(charSequence.charAt(i))) continue;
                return false;
            }
            return true;
        }

        protected CoderResult encodeLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
            while (charBuffer.hasRemaining()) {
                char c = charBuffer.get();
                if (c > '\u007f') {
                    charBuffer.position(charBuffer.position() - 1);
                    return CoderResult.unmappableForLength(1);
                }
                if (!byteBuffer.hasRemaining()) {
                    charBuffer.position(charBuffer.position() - 1);
                    return CoderResult.OVERFLOW;
                }
                byteBuffer.put((byte)c);
            }
            return CoderResult.UNDERFLOW;
        }
    }

    private static final class Decoder
    extends CharsetDecoder {
        Decoder(Charset charset) {
            super(charset, 1.0f, 1.0f);
        }

        protected CoderResult decodeLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
            while (byteBuffer.hasRemaining()) {
                byte by = byteBuffer.get();
                if (by < 0) {
                    byteBuffer.position(byteBuffer.position() - 1);
                    return CoderResult.malformedForLength(1);
                }
                if (!charBuffer.hasRemaining()) {
                    byteBuffer.position(byteBuffer.position() - 1);
                    return CoderResult.OVERFLOW;
                }
                charBuffer.put((char)by);
            }
            return CoderResult.UNDERFLOW;
        }
    }
}

