/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.util.prefs;

import gnu.java.util.prefs.gconf.GConfNativePeer;
import java.security.Permission;
import java.util.Iterator;
import java.util.List;
import java.util.prefs.AbstractPreferences;
import java.util.prefs.BackingStoreException;

public class GConfBasedPreferences
extends AbstractPreferences {
    private static final Permission PERMISSION = new RuntimePermission("preferences");
    private static GConfNativePeer backend = new GConfNativePeer();
    private static final String DEFAULT_USER_ROOT = "/apps/classpath";
    private static final String DEFAULT_SYSTEM_ROOT = "/system";
    private String node;
    private final boolean isUser;

    private /* synthetic */ void finit$() {
        this.node = "";
    }

    public GConfBasedPreferences() {
        this(true);
    }

    public GConfBasedPreferences(boolean bl) {
        this(null, "", bl);
    }

    public GConfBasedPreferences(AbstractPreferences abstractPreferences, String string, boolean bl) {
        super(abstractPreferences, string);
        this.finit$();
        this.isUser = bl;
        String string2 = this.absolutePath();
        if (string2 != null && string2.endsWith("/")) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        this.node = this.getRealRoot(bl) + string2;
        boolean bl2 = backend.nodeExist(this.node);
        this.newNode = bl2 ^ true;
        backend.startWatchingNode(this.node);
    }

    protected AbstractPreferences childSpi(String string) {
        return new GConfBasedPreferences(this, string, this.isUser);
    }

    protected String[] childrenNamesSpi() throws BackingStoreException {
        List list2 = backend.getChildrenNodes(this.node);
        Object[] objectArray = new String[list2.size()];
        list2.toArray(objectArray);
        return objectArray;
    }

    public void flush() throws BackingStoreException {
        backend.suggestSync();
    }

    protected void flushSpi() throws BackingStoreException {
        this.flush();
    }

    protected String[] keysSpi() throws BackingStoreException {
        List list2 = backend.getKeys(this.node);
        Object[] objectArray = new String[list2.size()];
        list2.toArray(objectArray);
        return objectArray;
    }

    private void postorderRemove(String string) {
        try {
            Object object;
            Object object2;
            List list2 = backend.getChildrenNodes(string);
            if (list2.size() != 0) {
                object2 = null;
                object = list2.iterator();
                while (object.hasNext()) {
                    object2 = (String)object.next();
                    this.postorderRemove((String)object2);
                }
            }
            if ((object2 = backend.getKeys(string)).size() != 0) {
                object = null;
                Iterator iterator = object2.iterator();
                while (iterator.hasNext()) {
                    object = (String)iterator.next();
                    this.removeSpi((String)object);
                }
            }
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
    }

    protected void putSpi(String string, String string2) {
        backend.setString(this.getGConfKey(string), string2);
    }

    protected void removeNodeSpi() throws BackingStoreException {
        this.postorderRemove(this.node);
        this.flush();
    }

    protected void removeSpi(String string) {
        backend.unset(this.getGConfKey(string));
    }

    public void sync() throws BackingStoreException {
        this.flush();
    }

    protected void syncSpi() throws BackingStoreException {
        this.sync();
    }

    protected String getSpi(String string) {
        return backend.getKey(this.getGConfKey(string));
    }

    public boolean isUserNode() {
        return this.isUser;
    }

    private String getGConfKey(String string) {
        String string2 = "";
        string2 = this.node.endsWith("/") ? this.node + string : this.node + "/" + string;
        return string2;
    }

    private String getRealRoot(boolean bl) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(PERMISSION);
        }
        String string = null;
        string = bl ? System.getProperty("gnu.java.util.prefs.gconf.user_root", DEFAULT_USER_ROOT) : System.getProperty("gnu.java.util.prefs.gconf.system_root", DEFAULT_SYSTEM_ROOT);
        return string;
    }

    static {
        DEFAULT_USER_ROOT = DEFAULT_USER_ROOT;
        DEFAULT_SYSTEM_ROOT = DEFAULT_SYSTEM_ROOT;
    }
}

