/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

public final class Float
extends Number
implements Comparable {
    private static final long serialVersionUID = -2671257302660747028L;
    public static final float MAX_VALUE = 3.4028235E38f;
    public static final float MIN_VALUE = 1.4E-45f;
    public static final float NEGATIVE_INFINITY = -1.0f / 0.0f;
    public static final float POSITIVE_INFINITY = 1.0f / 0.0f;
    public static final float NaN = 0.0f / 0.0f;
    public static final Class TYPE = VMClassLoader.getPrimitiveClass('F');
    public static final int SIZE = 32;
    private final float value;

    public Float(float f) {
        this.value = f;
    }

    public Float(double d) {
        this.value = (float)d;
    }

    public Float(String string) {
        this.value = Float.parseFloat(string);
    }

    public static String toString(float f) {
        return VMDouble.toString(f, true);
    }

    public static String toHexString(float f) {
        int n;
        if (Float.isNaN(f)) {
            return "NaN";
        }
        if (Float.isInfinite(f)) {
            if (f < 0.0f) {
                return "-Infinity";
            }
            return "Infinity";
        }
        int n2 = Float.floatToIntBits(f);
        StringBuilder stringBuilder = new StringBuilder();
        if (n2 < 0) {
            stringBuilder.append('-');
        }
        stringBuilder.append("0x");
        int n3 = 23;
        int n4 = 8;
        int n5 = (1 << (n3 & 0x1F)) - 1;
        int n6 = n2 & n5;
        int n7 = (1 << (n4 & 0x1F)) - 1;
        int n8 = n2 >>> (n3 & 0x1F) & n7;
        stringBuilder.append(n8 == 0 ? (char)'0' : '1');
        stringBuilder.append('.');
        stringBuilder.append(Integer.toHexString(n6 <<= 1));
        if (n8 == 0 && n6 != 0) {
            n = 4 + (n2 < 0 ? 1 : 0);
            int n9 = n + (n3 + 3) / 4;
            while (stringBuilder.length() < n9) {
                stringBuilder.insert(n, '0');
            }
        }
        stringBuilder.append('p');
        if (n8 != 0 || n6 != 0) {
            n = n8 == 0 ? 1 : 0;
            n8 -= (1 << (n4 + -1 & 0x1F)) - 1;
            if (n != 0) {
                ++n8;
            }
        }
        stringBuilder.append(Integer.toString(n8));
        return stringBuilder.toString();
    }

    public static Float valueOf(String string) {
        return new Float(Float.parseFloat(string));
    }

    public static Float valueOf(float f) {
        return new Float(f);
    }

    public static float parseFloat(String string) {
        return (float)Double.parseDouble(string);
    }

    public static boolean isNaN(float f) {
        return f != f;
    }

    public static boolean isInfinite(float f) {
        return f == Float.POSITIVE_INFINITY || f == Float.NEGATIVE_INFINITY;
    }

    public boolean isNaN() {
        return Float.isNaN(this.value);
    }

    public boolean isInfinite() {
        return Float.isInfinite(this.value);
    }

    public String toString() {
        return Float.toString(this.value);
    }

    public byte byteValue() {
        return (byte)this.value;
    }

    public short shortValue() {
        return (short)this.value;
    }

    public int intValue() {
        return (int)this.value;
    }

    public long longValue() {
        return (long)this.value;
    }

    public float floatValue() {
        return this.value;
    }

    public double doubleValue() {
        return this.value;
    }

    public int hashCode() {
        return Float.floatToIntBits(this.value);
    }

    public boolean equals(Object object) {
        if (!(object instanceof Float)) {
            return false;
        }
        float f = ((Float)object).value;
        if (this.value == f) {
            return this.value != 0.0f || 1.0f / this.value == 1.0f / f;
        }
        return Float.isNaN(this.value) && Float.isNaN(f);
    }

    public static int floatToIntBits(float f) {
        return VMFloat.floatToIntBits(f);
    }

    public static int floatToRawIntBits(float f) {
        return VMFloat.floatToRawIntBits(f);
    }

    public static float intBitsToFloat(int n) {
        return VMFloat.intBitsToFloat(n);
    }

    public int compareTo(Float f) {
        return Float.compare(this.value, f.value);
    }

    public int compareTo(Object object) {
        return Float.compare(this.value, ((Float)object).value);
    }

    public static int compare(float f, float f2) {
        if (Float.isNaN(f)) {
            if (Float.isNaN(f2)) {
                return 0;
            }
            return 1;
        }
        if (Float.isNaN(f2)) {
            return -1;
        }
        if (f == 0.0f && f2 == 0.0f) {
            return (int)(1.0f / f - 1.0f / f2);
        }
        if (f == f2) {
            return 0;
        }
        if (f > f2) {
            return 1;
        }
        return -1;
    }
}

