/*
 * Decompiled with CFR 0.152.
 */
package javax.print;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

public class DocFlavor
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -4512080796965449721L;
    public static final String hostEncoding = Charset.defaultCharset().name();
    private transient String mediaSubtype;
    private transient String mediaType;
    private transient TreeMap params;
    private String myClassName;

    public DocFlavor(String string, String string2) {
        if (string == null || string2 == null) {
            throw new NullPointerException();
        }
        this.params = new TreeMap();
        this.parseMimeType(string);
        this.myClassName = string2;
    }

    private void parseMimeType(String string) {
        int n = 1;
        int n2 = 2;
        int n3 = 3;
        int n4 = 4;
        int n5 = 5;
        int n6 = 0;
        int n7 = 0;
        try {
            int n8;
            String string2 = null;
            StreamTokenizer streamTokenizer = new StreamTokenizer(new StringReader(string));
            streamTokenizer.resetSyntax();
            streamTokenizer.whitespaceChars(0, 32);
            streamTokenizer.whitespaceChars(127, 127);
            streamTokenizer.wordChars(65, 90);
            streamTokenizer.wordChars(97, 122);
            streamTokenizer.wordChars(48, 57);
            streamTokenizer.wordChars(160, 255);
            streamTokenizer.wordChars(33, 33);
            streamTokenizer.wordChars(35, 39);
            streamTokenizer.wordChars(42, 43);
            streamTokenizer.wordChars(45, 46);
            streamTokenizer.wordChars(94, 96);
            streamTokenizer.wordChars(123, 126);
            streamTokenizer.quoteChar(34);
            block11: while ((n8 = streamTokenizer.nextToken()) != -1) {
                switch (n8) {
                    case -3: {
                        String string3;
                        if (n6 == 0) {
                            this.mediaType = streamTokenizer.sval.toLowerCase();
                            n6 = n;
                            break;
                        }
                        if (n6 == n) {
                            this.mediaSubtype = streamTokenizer.sval.toLowerCase();
                            n6 = n2;
                            break;
                        }
                        if (n6 == n2 || n6 == n4) {
                            string2 = streamTokenizer.sval.toLowerCase();
                            n6 = n3;
                            break;
                        }
                        if (n6 == n3) {
                            string3 = streamTokenizer.sval;
                            if (string2.equals("charset")) {
                                string3 = string3.toLowerCase();
                            }
                            n6 = n4;
                            this.params.put(string2, string3);
                            break;
                        }
                        if (n6 != n5) continue block11;
                    }
                    case 47: {
                        if (n6 == n) continue block11;
                        throw new IllegalArgumentException();
                    }
                    case 61: {
                        if (n6 == n3) continue block11;
                        throw new IllegalArgumentException();
                    }
                    case 59: {
                        if (n6 == n2 || n6 == n4) continue block11;
                        throw new IllegalArgumentException();
                    }
                    case 40: {
                        n7 = n6;
                        n6 = n5;
                        break;
                    }
                    case 41: {
                        n6 = n7;
                        break;
                    }
                    case 34: {
                        String string3;
                        if (n6 == n3) {
                            string3 = streamTokenizer.sval;
                            if (string2.equals("charset")) {
                                string3 = string3.toLowerCase();
                            }
                            n6 = n4;
                            this.params.put(string2, string3);
                            break;
                        }
                        throw new IllegalArgumentException();
                    }
                    default: {
                        throw new IllegalArgumentException();
                    }
                }
            }
        }
        catch (IOException iOException) {
            throw new InternalError("IOException during parsing String " + string);
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof DocFlavor)) {
            return false;
        }
        DocFlavor docFlavor = (DocFlavor)object;
        return this.getMimeType().equals(docFlavor.getMimeType()) && this.getRepresentationClassName().equals(docFlavor.getRepresentationClassName());
    }

    public String getMediaSubtype() {
        return this.mediaSubtype;
    }

    public String getMediaType() {
        return this.mediaType;
    }

    public String getMimeType() {
        String string = this.getMediaType() + "/" + this.getMediaSubtype();
        Iterator iterator = this.params.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            string = string + new StringBuffer("; ").append(entry.getKey()).append("=\"").append(entry.getValue()).append("\"");
        }
        return string;
    }

    public String getParameter(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        return (String)this.params.get(string.toLowerCase());
    }

    public String getRepresentationClassName() {
        return this.myClassName;
    }

    public int hashCode() {
        return this.mediaType.hashCode() * this.mediaSubtype.hashCode() * this.myClassName.hashCode() ^ this.params.hashCode();
    }

    public String toString() {
        return this.getMimeType() + "; class=\"" + this.getRepresentationClassName() + "\"";
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.params = new TreeMap();
        this.myClassName = (String)objectInputStream.readObject();
        this.parseMimeType((String)objectInputStream.readObject());
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(this.myClassName);
        objectOutputStream.writeObject(this.getMimeType());
    }

    public static class URL
    extends DocFlavor {
        private static final long serialVersionUID = 2936725788144902062L;
        public static final URL AUTOSENSE = new URL("application/octet-stream");
        public static final URL GIF = new URL("image/gif");
        public static final URL JPEG = new URL("image/jpeg");
        public static final URL PCL = new URL("application/vnd.hp-PCL");
        public static final URL PDF = new URL("application/pdf");
        public static final URL PNG = new URL("image/png");
        public static final URL POSTSCRIPT = new URL("application/postscript");
        public static final URL TEXT_HTML_HOST = new URL("text/html; charset=" + hostEncoding);
        public static final URL TEXT_HTML_US_ASCII = new URL("text/html; charset=us-ascii");
        public static final URL TEXT_HTML_UTF_16 = new URL("text/html; charset=utf-16");
        public static final URL TEXT_HTML_UTF_16BE = new URL("text/html; charset=utf-16be");
        public static final URL TEXT_HTML_UTF_16LE = new URL("text/html; charset=utf-16le");
        public static final URL TEXT_HTML_UTF_8 = new URL("text/html; charset=utf-8");
        public static final URL TEXT_PLAIN_HOST = new URL("text/plain; charset=" + hostEncoding);
        public static final URL TEXT_PLAIN_US_ASCII = new URL("text/plain; charset=us-ascii");
        public static final URL TEXT_PLAIN_UTF_16 = new URL("text/plain; charset=utf-16");
        public static final URL TEXT_PLAIN_UTF_16BE = new URL("text/plain; charset=utf-16be");
        public static final URL TEXT_PLAIN_UTF_16LE = new URL("text/plain; charset=utf-16le");
        public static final URL TEXT_PLAIN_UTF_8 = new URL("text/plain; charset=utf-8");

        public URL(String string) {
            super(string, "java.net.URL");
        }
    }

    public static class STRING
    extends DocFlavor {
        private static final long serialVersionUID = 4414407504887034035L;
        public static final STRING TEXT_HTML = new STRING("text/html; charset=utf-16");
        public static final STRING TEXT_PLAIN = new STRING("text/plain; charset=utf-16");

        public STRING(String string) {
            super(string, "java.lang.String");
        }
    }

    public static class SERVICE_FORMATTED
    extends DocFlavor {
        private static final long serialVersionUID = 6181337766266637256L;
        public static final SERVICE_FORMATTED PAGEABLE = new SERVICE_FORMATTED("java.awt.print.Pageable");
        public static final SERVICE_FORMATTED PRINTABLE = new SERVICE_FORMATTED("java.awt.print.Printable");
        public static final SERVICE_FORMATTED RENDERABLE_IMAGE = new SERVICE_FORMATTED("java.awt.image.renderable.RenderableImage");

        public SERVICE_FORMATTED(String string) {
            super("application/x-java-jvm-local-objectref", string);
        }
    }

    public static class READER
    extends DocFlavor {
        private static final long serialVersionUID = 7100295812579351567L;
        public static final READER TEXT_HTML = new READER("text/html; charset=utf-16");
        public static final READER TEXT_PLAIN = new READER("text/plain; charset=utf-16");

        public READER(String string) {
            super(string, "java.io.Reader");
        }
    }

    public static class INPUT_STREAM
    extends DocFlavor {
        private static final long serialVersionUID = -7045842700749194127L;
        public static final INPUT_STREAM AUTOSENSE = new INPUT_STREAM("application/octet-stream");
        public static final INPUT_STREAM GIF = new INPUT_STREAM("image/gif");
        public static final INPUT_STREAM JPEG = new INPUT_STREAM("image/jpeg");
        public static final INPUT_STREAM PCL = new INPUT_STREAM("application/vnd.hp-PCL");
        public static final INPUT_STREAM PDF = new INPUT_STREAM("application/pdf");
        public static final INPUT_STREAM PNG = new INPUT_STREAM("image/png");
        public static final INPUT_STREAM POSTSCRIPT = new INPUT_STREAM("application/postscript");
        public static final INPUT_STREAM TEXT_HTML_HOST = new INPUT_STREAM("text/html; charset=" + hostEncoding);
        public static final INPUT_STREAM TEXT_HTML_US_ASCII = new INPUT_STREAM("text/html; charset=us-ascii");
        public static final INPUT_STREAM TEXT_HTML_UTF_16 = new INPUT_STREAM("text/html; charset=utf-16");
        public static final INPUT_STREAM TEXT_HTML_UTF_16BE = new INPUT_STREAM("text/html; charset=utf-16be");
        public static final INPUT_STREAM TEXT_HTML_UTF_16LE = new INPUT_STREAM("text/html; charset=utf-16le");
        public static final INPUT_STREAM TEXT_HTML_UTF_8 = new INPUT_STREAM("text/html; charset=utf-8");
        public static final INPUT_STREAM TEXT_PLAIN_HOST = new INPUT_STREAM("text/plain; charset=" + hostEncoding);
        public static final INPUT_STREAM TEXT_PLAIN_US_ASCII = new INPUT_STREAM("text/plain; charset=us-ascii");
        public static final INPUT_STREAM TEXT_PLAIN_UTF_16 = new INPUT_STREAM("text/plain; charset=utf-16");
        public static final INPUT_STREAM TEXT_PLAIN_UTF_16BE = new INPUT_STREAM("text/plain; charset=utf-16be");
        public static final INPUT_STREAM TEXT_PLAIN_UTF_16LE = new INPUT_STREAM("text/plain; charset=utf-16le");
        public static final INPUT_STREAM TEXT_PLAIN_UTF_8 = new INPUT_STREAM("text/plain; charset=utf-8");

        public INPUT_STREAM(String string) {
            super(string, "java.io.InputStream");
        }
    }

    public static class CHAR_ARRAY
    extends DocFlavor {
        private static final long serialVersionUID = -8720590903724405128L;
        public static final CHAR_ARRAY TEXT_HTML = new CHAR_ARRAY("text/html; charset=utf-16");
        public static final CHAR_ARRAY TEXT_PLAIN = new CHAR_ARRAY("text/plain; charset=utf-16");

        public CHAR_ARRAY(String string) {
            super(string, "[C");
        }
    }

    public static class BYTE_ARRAY
    extends DocFlavor {
        private static final long serialVersionUID = -9065578006593857475L;
        public static final BYTE_ARRAY AUTOSENSE = new BYTE_ARRAY("application/octet-stream");
        public static final BYTE_ARRAY GIF = new BYTE_ARRAY("image/gif");
        public static final BYTE_ARRAY JPEG = new BYTE_ARRAY("image/jpeg");
        public static final BYTE_ARRAY PCL = new BYTE_ARRAY("application/vnd.hp-PCL");
        public static final BYTE_ARRAY PDF = new BYTE_ARRAY("application/pdf");
        public static final BYTE_ARRAY PNG = new BYTE_ARRAY("image/png");
        public static final BYTE_ARRAY POSTSCRIPT = new BYTE_ARRAY("application/postscript");
        public static final BYTE_ARRAY TEXT_HTML_HOST = new BYTE_ARRAY("text/html; charset=" + hostEncoding);
        public static final BYTE_ARRAY TEXT_HTML_US_ASCII = new BYTE_ARRAY("text/html; charset=us-ascii");
        public static final BYTE_ARRAY TEXT_HTML_UTF_16 = new BYTE_ARRAY("text/html; charset=utf-16");
        public static final BYTE_ARRAY TEXT_HTML_UTF_16BE = new BYTE_ARRAY("text/html; charset=utf-16be");
        public static final BYTE_ARRAY TEXT_HTML_UTF_16LE = new BYTE_ARRAY("text/html; charset=utf-16le");
        public static final BYTE_ARRAY TEXT_HTML_UTF_8 = new BYTE_ARRAY("text/html; charset=utf-8");
        public static final BYTE_ARRAY TEXT_PLAIN_HOST = new BYTE_ARRAY("text/plain; charset=" + hostEncoding);
        public static final BYTE_ARRAY TEXT_PLAIN_US_ASCII = new BYTE_ARRAY("text/plain; charset=us-ascii");
        public static final BYTE_ARRAY TEXT_PLAIN_UTF_16 = new BYTE_ARRAY("text/plain; charset=utf-16");
        public static final BYTE_ARRAY TEXT_PLAIN_UTF_16BE = new BYTE_ARRAY("text/plain; charset=utf-16be");
        public static final BYTE_ARRAY TEXT_PLAIN_UTF_16LE = new BYTE_ARRAY("text/plain; charset=utf-16le");
        public static final BYTE_ARRAY TEXT_PLAIN_UTF_8 = new BYTE_ARRAY("text/plain; charset=utf-8");

        public BYTE_ARRAY(String string) {
            super(string, "[B");
        }
    }
}

