/*
 * Decompiled with CFR 0.152.
 */
package javax.security.auth.kerberos;

import java.security.Permission;
import java.security.PermissionCollection;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

public final class ServicePermission
extends Permission {
    private static final int INITIATE = 1;
    private static final int ACCEPT = 2;
    private int flags;

    public ServicePermission(String string, String string2) {
        super(string);
        this.parseActions(string2);
    }

    public boolean implies(Permission permission) {
        if (!(permission instanceof ServicePermission)) {
            return false;
        }
        ServicePermission servicePermission = (ServicePermission)permission;
        if ((this.flags & servicePermission.flags) != servicePermission.flags) {
            return false;
        }
        return this.getName().equals(servicePermission.getName());
    }

    public boolean equals(Object object) {
        if (!(object instanceof ServicePermission)) {
            return false;
        }
        ServicePermission servicePermission = (ServicePermission)object;
        return this.flags == servicePermission.flags && this.getName().equals(servicePermission.getName());
    }

    public int hashCode() {
        return this.getName().hashCode() + this.flags;
    }

    public String getActions() {
        if (this.flags == 3) {
            return "initiate,accept";
        }
        if (this.flags == 1) {
            return "initiate";
        }
        if (this.flags == 2) {
            return "accept";
        }
        return "";
    }

    public PermissionCollection newPermissionCollection() {
        return new PermissionCollection(this){
            private /* synthetic */ ServicePermission this$0;
            private Vector permissions;
            {
                this.this$0 = servicePermission;
                this.finit$();
            }

            private /* synthetic */ void finit$() {
                this.permissions = new Vector();
            }

            public void add(Permission permission) {
                if (this.isReadOnly()) {
                    throw new SecurityException("readonly");
                }
                if (!(permission instanceof ServicePermission)) {
                    throw new IllegalArgumentException("can only add DelegationPermissions");
                }
                this.permissions.add(permission);
            }

            public boolean implies(Permission permission) {
                if (!(permission instanceof ServicePermission)) {
                    return false;
                }
                Enumeration enumeration = this.elements();
                while (enumeration.hasMoreElements()) {
                    ServicePermission servicePermission = (ServicePermission)enumeration.nextElement();
                    if (!servicePermission.implies(permission)) continue;
                    return true;
                }
                return false;
            }

            public Enumeration elements() {
                return this.permissions.elements();
            }
        };
    }

    private void parseActions(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if ("accept".equals(string2)) {
                this.flags |= 2;
                continue;
            }
            if ("initiate".equals(string2)) {
                this.flags |= 1;
                continue;
            }
            throw new IllegalArgumentException("unrecognized token: " + string2);
        }
    }
}

