/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.ButtonModel;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.ComponentInputMapUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.RootPaneUI;

public class BasicRootPaneUI
extends RootPaneUI
implements PropertyChangeListener {
    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicRootPaneUI();
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        if (jComponent instanceof JRootPane) {
            JRootPane jRootPane = (JRootPane)jComponent;
            this.installDefaults(jRootPane);
            this.installComponents(jRootPane);
            this.installListeners(jRootPane);
            this.installKeyboardActions(jRootPane);
        }
    }

    protected void installDefaults(JRootPane jRootPane) {
    }

    protected void installComponents(JRootPane jRootPane) {
    }

    protected void installListeners(JRootPane jRootPane) {
        jRootPane.addPropertyChangeListener(this);
    }

    protected void installKeyboardActions(JRootPane jRootPane) {
        ActionMapUIResource actionMapUIResource = new ActionMapUIResource();
        actionMapUIResource.put("press", new DefaultPressAction(this, jRootPane));
        actionMapUIResource.put("release", new DefaultReleaseAction(this, jRootPane));
        SwingUtilities.replaceUIActionMap(jRootPane, actionMapUIResource);
        ComponentInputMapUIResource componentInputMapUIResource = new ComponentInputMapUIResource(jRootPane);
        SwingUtilities.replaceUIInputMap(jRootPane, 2, componentInputMapUIResource);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        JRootPane jRootPane = (JRootPane)propertyChangeEvent.getSource();
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals("defaultButton")) {
            Object object = propertyChangeEvent.getNewValue();
            InputMap inputMap = SwingUtilities.getUIInputMap(jRootPane, 2);
            if (object != null) {
                Object[] objectArray = (Object[])UIManager.get("RootPane.defaultButtonWindowKeyBindings");
                LookAndFeel.loadKeyBindings(inputMap, objectArray);
            } else {
                inputMap.clear();
            }
        }
    }

    public void uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
        if (jComponent instanceof JRootPane) {
            JRootPane jRootPane = (JRootPane)jComponent;
            this.uninstallDefaults(jRootPane);
            this.uninstallComponents(jRootPane);
            this.uninstallListeners(jRootPane);
            this.uninstallKeyboardActions(jRootPane);
        }
    }

    protected void uninstallDefaults(JRootPane jRootPane) {
    }

    protected void uninstallComponents(JRootPane jRootPane) {
    }

    protected void uninstallListeners(JRootPane jRootPane) {
        jRootPane.removePropertyChangeListener(this);
    }

    protected void uninstallKeyboardActions(JRootPane jRootPane) {
        SwingUtilities.replaceUIActionMap(jRootPane, null);
        SwingUtilities.replaceUIInputMap(jRootPane, 2, null);
    }

    private class DefaultReleaseAction
    extends AbstractAction {
        private /* synthetic */ BasicRootPaneUI this$0;
        private JRootPane rootPane;

        DefaultReleaseAction(BasicRootPaneUI basicRootPaneUI, JRootPane jRootPane) {
            this.this$0 = basicRootPaneUI;
            this.rootPane = jRootPane;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JButton jButton = this.rootPane.getDefaultButton();
            if (jButton != null) {
                ButtonModel buttonModel = jButton.getModel();
                buttonModel.setPressed(false);
                buttonModel.setArmed(false);
            }
        }
    }

    private class DefaultPressAction
    extends AbstractAction {
        private /* synthetic */ BasicRootPaneUI this$0;
        private JRootPane rootPane;

        DefaultPressAction(BasicRootPaneUI basicRootPaneUI, JRootPane jRootPane) {
            this.this$0 = basicRootPaneUI;
            this.rootPane = jRootPane;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JButton jButton = this.rootPane.getDefaultButton();
            if (jButton != null) {
                ButtonModel buttonModel = jButton.getModel();
                buttonModel.setArmed(true);
                buttonModel.setPressed(true);
            }
        }
    }
}

