/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.tools.getopt;

import gnu.classpath.tools.getopt.FileArgumentCallback;
import gnu.classpath.tools.getopt.Messages;
import gnu.classpath.tools.getopt.Option;
import gnu.classpath.tools.getopt.OptionException;
import gnu.classpath.tools.getopt.OptionGroup;
import java.io.PrintStream;
import java.text.BreakIterator;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;

public class Parser {
    public static final int MAX_LINE_LENGTH = 80;
    private String programName;
    private String headerText;
    private String footerText;
    private boolean longOnly;
    private ArrayList options;
    private ArrayList optionGroups;
    private OptionGroup defaultGroup;
    private int currentIndex;
    private String[] args;

    private /* synthetic */ void finit$() {
        this.options = new ArrayList();
        this.optionGroups = new ArrayList();
        this.defaultGroup = new OptionGroup();
    }

    public Parser(String string, String string2) {
        this(string, string2, false);
    }

    protected static void formatText(PrintStream printStream, String string) {
        Parser.formatText(printStream, string, Locale.getDefault());
    }

    protected static void formatText(PrintStream printStream, String string, Locale locale) {
        BreakIterator breakIterator = BreakIterator.getLineInstance(locale);
        String[] stringArray = string.split("\n");
        for (int i = 0; i < stringArray.length; ++i) {
            int n;
            string = stringArray[i];
            breakIterator.setText(string);
            int n2 = 0;
            int n3 = breakIterator.first();
            while ((n = breakIterator.next()) != -1) {
                String string2 = string.substring(n3, n);
                if ((n2 += string2.length()) >= 80) {
                    printStream.println();
                    n2 = string2.length();
                }
                printStream.print(string2);
                n3 = n;
            }
            printStream.println();
        }
    }

    public Parser(String string, String string2, boolean bl) {
        this.finit$();
        this.programName = string;
        this.longOnly = bl;
        OptionGroup optionGroup = new OptionGroup(Messages.getString("Parser.StdOptions"));
        optionGroup.add(new Option(this, string2, "help", Messages.getString("Parser.PrintHelp")){
            private /* synthetic */ Parser this$0;
            private /* synthetic */ String val$versionString;
            {
                this.this$0 = parser;
                super(string2, string3);
                this.finit$(string);
            }

            private /* synthetic */ void finit$(String string) {
                this.val$versionString = string;
            }

            public void parsed(String string) throws OptionException {
                this.this$0.printHelp(System.out);
                System.exit(0);
            }
        });
        optionGroup.add(new Option(this, string2, "version", Messages.getString("Parser.PrintVersion")){
            private /* synthetic */ Parser this$0;
            private /* synthetic */ String val$versionString;
            {
                this.this$0 = parser;
                super(string2, string3);
                this.finit$(string);
            }

            private /* synthetic */ void finit$(String string) {
                this.val$versionString = string;
            }

            public void parsed(String string) throws OptionException {
                System.out.println(this.val$versionString);
                System.exit(0);
            }
        });
        optionGroup.add(new Option(this, string2, 'J', Messages.getString("Parser.JArgument"), Messages.getString("Parser.JName")){
            private /* synthetic */ Parser this$0;
            private /* synthetic */ String val$versionString;
            {
                this.this$0 = parser;
                super(c, string2, string3);
                this.finit$(string);
            }

            private /* synthetic */ void finit$(String string) {
                this.val$versionString = string;
            }

            public void parsed(String string) throws OptionException {
            }
        });
        this.add(optionGroup);
        this.add(this.defaultGroup);
    }

    public void setHeader(String string) {
        this.headerText = string;
    }

    public void setFooter(String string) {
        this.footerText = string;
    }

    public synchronized void add(Option option) {
        this.options.add(option);
        this.defaultGroup.add(option);
    }

    public synchronized void add(OptionGroup optionGroup) {
        this.options.addAll(optionGroup.options);
        if (this.optionGroups.isEmpty()) {
            this.optionGroups.add(optionGroup);
        } else {
            this.optionGroups.add(this.optionGroups.size() - 1, optionGroup);
        }
    }

    public void printHelp() {
        this.printHelp(System.out);
    }

    void printHelp(PrintStream printStream) {
        if (this.headerText != null) {
            Parser.formatText(printStream, this.headerText);
            printStream.println();
        }
        Iterator iterator = this.optionGroups.iterator();
        while (iterator.hasNext()) {
            OptionGroup optionGroup = (OptionGroup)iterator.next();
            if (optionGroup.options.isEmpty()) continue;
            optionGroup.printHelp(printStream, this.longOnly);
            printStream.println();
        }
        if (this.footerText != null) {
            Parser.formatText(printStream, this.footerText);
        }
    }

    protected void validate() throws OptionException {
    }

    private String getArgument(String string) throws OptionException {
        ++this.currentIndex;
        if (this.currentIndex >= this.args.length) {
            String string2 = MessageFormat.format(Messages.getString("Parser.ArgReqd"), string);
            throw new OptionException(string);
        }
        return this.args[this.currentIndex];
    }

    private void handleLongOption(String string, int n) throws OptionException {
        Object object;
        String string2;
        String string3 = string2 = string.substring(n);
        int n2 = string2.indexOf(61);
        if (n2 != -1) {
            string3 = string2.substring(0, n2);
        }
        char c = '\u0000';
        if (string3.length() == 1) {
            c = string3.charAt(0);
        }
        Option option = null;
        for (int i = this.options.size() - 1; i >= 0; --i) {
            object = (Option)this.options.get(i);
            if (string3.equals(((Option)object).getLongName())) {
                option = object;
                break;
            }
            if (c == '\u0000' || ((Option)object).getShortName() != c) continue;
            option = object;
            break;
        }
        if (option == null) {
            String string4 = MessageFormat.format(Messages.getString("Parser.Unrecognized"), string);
            throw new OptionException(string4);
        }
        String string5 = null;
        if (option.getTakesArgument()) {
            string5 = n2 == -1 ? this.getArgument(string) : string2.substring(n2 + 1);
        } else if (n2 != -1) {
            object = MessageFormat.format(Messages.getString("Parser.NoArg"), string.substring(0, n2 + n));
            throw new OptionException((String)object);
        }
        option.parsed(string5);
    }

    private void handleShortOption(char c) throws OptionException {
        Option option = null;
        for (int i = this.options.size() - 1; i >= 0; --i) {
            Option option2 = (Option)this.options.get(i);
            if (c != option2.getShortName()) continue;
            option = option2;
            break;
        }
        if (option == null) {
            String string = MessageFormat.format(Messages.getString("Parser.UnrecDash"), "" + c);
            throw new OptionException(string);
        }
        String string = null;
        if (option.getTakesArgument()) {
            string = this.getArgument("-" + c);
        }
        option.parsed(string);
    }

    private void handleShortOptions(String string) throws OptionException {
        for (int i = 1; i < string.length(); ++i) {
            this.handleShortOption(string.charAt(i));
        }
    }

    public synchronized void parse(String[] stringArray, FileArgumentCallback fileArgumentCallback) {
        try {
            this.args = stringArray;
            this.currentIndex = 0;
            while (this.currentIndex < this.args.length) {
                if (this.args[this.currentIndex].length() == 0 || this.args[this.currentIndex].charAt(0) != '-' || "-".equals(this.args[this.currentIndex])) {
                    fileArgumentCallback.notifyFile(this.args[this.currentIndex]);
                } else {
                    if ("--".equals(this.args[this.currentIndex])) break;
                    if (this.args[this.currentIndex].charAt(1) == '-') {
                        this.handleLongOption(this.args[this.currentIndex], 2);
                    } else if (this.longOnly) {
                        this.handleLongOption(this.args[this.currentIndex], 1);
                    } else {
                        this.handleShortOptions(this.args[this.currentIndex]);
                    }
                }
                ++this.currentIndex;
            }
            ++this.currentIndex;
            while (this.currentIndex < this.args.length) {
                fileArgumentCallback.notifyFile(this.args[this.currentIndex]);
                ++this.currentIndex;
            }
            this.validate();
        }
        catch (OptionException optionException) {
            System.err.println(this.programName + ": " + optionException.getMessage());
            String string = this.longOnly ? Messages.getString("Parser.TryHelpShort") : Messages.getString("Parser.TryHelpLong");
            String string2 = MessageFormat.format(string, this.programName);
            System.err.println(this.programName + ": " + string2);
            System.exit(1);
        }
    }

    public String[] parse(String[] stringArray) {
        ArrayList arrayList = new ArrayList();
        this.parse(stringArray, new FileArgumentCallback(this, arrayList){
            private /* synthetic */ Parser this$0;
            private /* synthetic */ ArrayList val$fileResult;
            {
                this.this$0 = parser;
                this.finit$(arrayList);
            }

            private /* synthetic */ void finit$(ArrayList arrayList) {
                this.val$fileResult = arrayList;
            }

            public void notifyFile(String string) {
                this.val$fileResult.add(string);
            }
        });
        return arrayList.toArray(new String[0]);
    }
}

