#!/bin/sh
echo 'name: HTTP
version: 4000.1.1
id: HTTP-4000.1.1-f00d3e264f070361749d43df3eaa202d

license: BSD3
copyright: Copyright (c) 2002, Warrick Gray
           Copyright (c) 2002-2005, Ian Lynagh
           Copyright (c) 2003-2006, Bjorn Bringert
           Copyright (c) 2004, Andre Furtado
           Copyright (c) 2004, Ganesh Sittampalam
           Copyright (c) 2004-2005, Dominic Steinitz
           Copyright 2007 Robin Bate Boerop
           Copyright 2008- Sigbjorn Finne
maintainer: Ganesh Sittampalam <ganesh@earth.li>
stability:
homepage: http://projects.haskell.org/http/
package-url:
description: The HTTP package supports client-side web programming in Haskell. It lets you set up
             HTTP connections, transmitting requests and processing the responses coming back, all
             from within the comforts of Haskell. It'\''s dependent on the network package to operate,
             but other than that, the implementation is all written in Haskell.
             .
             A basic API for issuing single HTTP requests + receiving responses is provided. On top
             of that, a session-level abstraction is also on offer  (the @BrowserAction@ monad);
             it taking care of handling the management of persistent connections, proxies,
             state (cookies) and authentication credentials required to handle multi-step
             interactions with a web server.
             .
             The representation of the bytes flowing across is extensible via the use of a type class,
             letting you pick the representation of requests and responses that best fits your use.
             Some pre-packaged, common instances are provided for you (@ByteString@, @String@.)
             .
             Here'\''s an example use:
             .
             >
             >    do
             >      rsp <- Network.HTTP.simpleHTTP (getRequest "http://www.haskell.org/")
             >              -- fetch document and return it (as a '\''String'\''.)
             >      fmap (take 100) (getResponseBody rsp)
             >
             >    do
             >      rsp <- Network.Browser.browse $ do
             >               setAllowRedirects True -- handle HTTP redirects
             >               request $ getRequest "http://google.com/"
             >      fmap (take 100) (getResponseBody rsp)
             >
             .
             Git repository available at <git://github.com/haskell/HTTP.git>
category: Network
author: Warrick Gray <warrick.gray@hotmail.com>
pkgpath: net/hs-HTTP
exposed: True
exposed-modules: Network.BufferType Network.Stream
                 Network.StreamDebugger Network.StreamSocket Network.TCP
                 Network.HTTP Network.HTTP.Headers Network.HTTP.Base
                 Network.HTTP.Stream Network.HTTP.Auth Network.HTTP.Cookie
                 Network.HTTP.Proxy Network.HTTP.HandleStream Network.Browser
hidden-modules: Network.HTTP.Base64 Network.HTTP.MD5
                Network.HTTP.MD5Aux Network.HTTP.Utils
import-dirs: /usr/local/lib/ghc/HTTP-4000.1.1
library-dirs: /usr/local/lib/ghc/HTTP-4000.1.1
hs-libraries: HSHTTP-4000.1.1
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: array-0.3.0.2-3444ee049e55c8df31a0796287f56a5e
         base-4.3.1.0-e1ba2d2213b66179f3e0c901a27d3a96
         bytestring-0.9.1.10-2da7b519f76934c0e733bf92c23382ec
         mtl-2.0.1.0-91f62d81c946aa60137dcc008e554a3a
         network-2.3.0.2-f235f94823d48cc39f2c61444de28400
         old-time-1.0.0.6-dfdb9c34ec39bc9a2a57345b38e135d4
         parsec-3.1.1-e9e6a217dbe32c1d9695e23a4f5f794b
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-HTTP-4000.1.1/html/HTTP.haddock
haddock-html: /usr/local/share/doc/hs-HTTP-4000.1.1/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-conf' "$@"
