#!/bin/sh
echo 'name: enumerator
version: 0.4.9.1
id: enumerator-0.4.9.1-cfc05aa39bc2f53ac33fa6d7439d2d01

license: MIT
copyright: Copyright (c) John Millikin 2010
maintainer: jmillikin@gmail.com
stability: experimental
homepage: http://john-millikin.com/software/enumerator/
package-url:
description: Typical buffer&#x2013;based incremental I/O is based around a single loop,
             which reads data from some source (such as a socket or file), transforms
             it, and generates one or more outputs (such as a line count, HTTP
             responses, or modified file). Although efficient and safe, these loops are
             all single&#x2013;purpose; it is difficult or impossible to compose
             buffer&#x2013;based processing loops.
             .
             Haskell&#x2019;s concept of &#x201C;lazy I/O&#x201D; allows pure code to
             operate on data from an external source. However, lazy I/O has several
             shortcomings. Most notably, resources such as memory and file handles can
             be retained for arbitrarily long periods of time, causing unpredictable
             performance and error conditions.
             .
             Enumerators are an efficient, predictable, and safe alternative to lazy
             I/O. Discovered by Oleg Kiselyov, they allow large datasets to be processed
             in near&#x2013;constant space by pure code. Although somewhat more complex
             to write, using enumerators instead of lazy I/O produces more correct
             programs.
             .
             This library contains an enumerator implementation for Haskell, designed to
             be both simple and efficient. Three core types are defined, along with
             numerous helper functions:
             .
             * /Iteratee/: Data sinks, analogous to left folds. Iteratees consume
             a sequence of /input/ values, and generate a single /output/ value.
             Many iteratees are designed to perform side effects (such as printing to
             @stdout@), so they can also be used as monad transformers.
             .
             * /Enumerator/: Data sources, which generate input sequences. Typical
             enumerators read from a file handle, socket, random number generator, or
             other external stream. To operate, enumerators are passed an iteratee, and
             provide that iteratee with input until either the iteratee has completed its
             computation, or EOF.
             .
             * /Enumeratee/: Data transformers, which operate as both enumerators and
             iteratees. Enumeratees read from an /outer/ enumerator, and provide the
             transformed data to an /inner/ iteratee.
category: Data, Enumerator
author: John Millikin <jmillikin@gmail.com>
pkgpath: devel/hs-enumerator
exposed: True
exposed-modules: Data.Enumerator Data.Enumerator.Binary
                 Data.Enumerator.Text Data.Enumerator.List Data.Enumerator.IO
hidden-modules: Data.Enumerator.Util
import-dirs: /usr/local/lib/ghc/enumerator-0.4.9.1
library-dirs: /usr/local/lib/ghc/enumerator-0.4.9.1
hs-libraries: HSenumerator-0.4.9.1
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: base-4.3.1.0-e1ba2d2213b66179f3e0c901a27d3a96
         bytestring-0.9.1.10-2da7b519f76934c0e733bf92c23382ec
         text-0.11.0.6-8c4af07195c37bf4d73ffb41fc92ea29
         transformers-0.2.2.0-7341f4d82874561a0431f4b264319cf8
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-enumerator-0.4.9.1/html/enumerator.haddock
haddock-html: /usr/local/share/doc/hs-enumerator-0.4.9.1/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-conf' "$@"
