#!/bin/sh
echo 'name: vector
version: 0.7.0.1
id: vector-0.7.0.1-3a18a3c369c7e19a25c6ed8559ed6128

license: BSD3
copyright: (c) Roman Leshchinskiy 2008-2010
maintainer: Roman Leshchinskiy <rl@cse.unsw.edu.au>
stability:
homepage: http://code.haskell.org/vector
package-url:
description: .
             An efficient implementation of Int-indexed arrays (both mutable
             and immutable), with a powerful loop fusion optimization framework .
             .
             It is structured as follows:
             .
             [@Data.Vector@] Boxed vectors of arbitrary types.
             .
             [@Data.Vector.Unboxed@] Unboxed vectors with an adaptive
             representation based on data type families.
             .
             [@Data.Vector.Storable@] Unboxed vectors of '\''Storable'\'' types.
             .
             [@Data.Vector.Primitive@] Unboxed vectors of primitive types as
             defined by the @primitive@ package. @Data.Vector.Unboxed@ is more
             flexible at no performance cost.
             .
             [@Data.Vector.Generic@] Generic interface to the vector types.
             .
             There is also a (draft) tutorial on common uses of vector.
             .
             * <http://haskell.org/haskellwiki/Numeric_Haskell:_A_Vector_Tutorial>
             .
             Please use the project trac to submit bug reports and feature
             requests.
             .
             * <http://trac.haskell.org/vector>
             .
             Changes in version 0.7.0.1
             .
             * Dependency on package ghc removed
             .
             Changes in version 0.7
             .
             * New functions for freezing, copying and thawing vectors: @freeze@,
             @thaw@, @unsafeThaw@ and @clone@
             .
             * @newWith@ and @newUnsafeWith@ on mutable vectors replaced by
             @replicate@
             .
             * New function: @concat@
             .
             * New function for safe indexing: @(!?)@
             .
             * @Monoid@ instances for all vector types
             .
             * Significant recycling and fusion improvements
             .
             * Bug fixes
             .
             * Support for GHC 7.0
category: Data, Data Structures
author: Roman Leshchinskiy <rl@cse.unsw.edu.au>
pkgpath: devel/hs-vector
exposed: True
exposed-modules: Data.Vector.Internal.Check Data.Vector.Fusion.Util
                 Data.Vector.Fusion.Stream.Size Data.Vector.Fusion.Stream.Monadic
                 Data.Vector.Fusion.Stream Data.Vector.Generic.Mutable
                 Data.Vector.Generic.Base Data.Vector.Generic.New
                 Data.Vector.Generic Data.Vector.Primitive.Mutable
                 Data.Vector.Primitive Data.Vector.Storable.Internal
                 Data.Vector.Storable.Mutable Data.Vector.Storable
                 Data.Vector.Unboxed.Base Data.Vector.Unboxed.Mutable
                 Data.Vector.Unboxed Data.Vector.Mutable Data.Vector
hidden-modules:
import-dirs: /usr/local/lib/ghc/vector-0.7.0.1
library-dirs: /usr/local/lib/ghc/vector-0.7.0.1
hs-libraries: HSvector-0.7.0.1
extra-libraries:
extra-ghci-libraries:
include-dirs: /usr/local/lib/ghc/vector-0.7.0.1/include
includes:
depends: base-4.3.1.0-e1ba2d2213b66179f3e0c901a27d3a96
         primitive-0.3.1-8254baf92d822508a6aa7805b8b44531
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-vector-0.7.0.1/html/vector.haddock
haddock-html: /usr/local/share/doc/hs-vector-0.7.0.1/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-conf' "$@"
