/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archetype.metadata.io.xpp3;

import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.util.Iterator;
import org.apache.maven.archetype.metadata.AbstractArchetypeDescriptor;
import org.apache.maven.archetype.metadata.ArchetypeDescriptor;
import org.apache.maven.archetype.metadata.FileSet;
import org.apache.maven.archetype.metadata.ModuleDescriptor;
import org.apache.maven.archetype.metadata.RequiredProperty;
import org.codehaus.plexus.util.xml.pull.MXSerializer;
import org.codehaus.plexus.util.xml.pull.XmlSerializer;

public class ArchetypeDescriptorXpp3Writer {
    private String NAMESPACE;

    public void write(Writer writer, ArchetypeDescriptor archetypeDescriptor) throws IOException {
        MXSerializer serializer = new MXSerializer();
        serializer.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-indentation", (Object)"  ");
        serializer.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-line-separator", (Object)"\n");
        serializer.setOutput(writer);
        serializer.startDocument(archetypeDescriptor.getModelEncoding(), null);
        this.writeArchetypeDescriptor(archetypeDescriptor, "archetype-descriptor", (XmlSerializer)serializer);
        serializer.endDocument();
    }

    private void writeAbstractArchetypeDescriptor(AbstractArchetypeDescriptor abstractArchetypeDescriptor, String tagName, XmlSerializer serializer) throws IOException {
        if (abstractArchetypeDescriptor != null) {
            Serializable o;
            Iterator iter;
            serializer.startTag(this.NAMESPACE, tagName);
            if (abstractArchetypeDescriptor.getFileSets() != null && abstractArchetypeDescriptor.getFileSets().size() > 0) {
                serializer.startTag(this.NAMESPACE, "fileSets");
                iter = abstractArchetypeDescriptor.getFileSets().iterator();
                while (iter.hasNext()) {
                    o = (FileSet)iter.next();
                    this.writeFileSet((FileSet)o, "fileSet", serializer);
                }
                serializer.endTag(this.NAMESPACE, "fileSets");
            }
            if (abstractArchetypeDescriptor.getModules() != null && abstractArchetypeDescriptor.getModules().size() > 0) {
                serializer.startTag(this.NAMESPACE, "modules");
                iter = abstractArchetypeDescriptor.getModules().iterator();
                while (iter.hasNext()) {
                    o = (ModuleDescriptor)iter.next();
                    this.writeModuleDescriptor((ModuleDescriptor)o, "module", serializer);
                }
                serializer.endTag(this.NAMESPACE, "modules");
            }
            serializer.endTag(this.NAMESPACE, tagName);
        }
    }

    private void writeArchetypeDescriptor(ArchetypeDescriptor archetypeDescriptor, String tagName, XmlSerializer serializer) throws IOException {
        if (archetypeDescriptor != null) {
            Serializable o;
            Iterator iter;
            serializer.startTag(this.NAMESPACE, tagName);
            if (archetypeDescriptor.getName() != null) {
                serializer.attribute(this.NAMESPACE, "name", archetypeDescriptor.getName());
            }
            if (archetypeDescriptor.isPartial()) {
                serializer.attribute(this.NAMESPACE, "partial", String.valueOf(archetypeDescriptor.isPartial()));
            }
            if (archetypeDescriptor.getRequiredProperties() != null && archetypeDescriptor.getRequiredProperties().size() > 0) {
                serializer.startTag(this.NAMESPACE, "requiredProperties");
                iter = archetypeDescriptor.getRequiredProperties().iterator();
                while (iter.hasNext()) {
                    o = (RequiredProperty)iter.next();
                    this.writeRequiredProperty((RequiredProperty)o, "requiredProperty", serializer);
                }
                serializer.endTag(this.NAMESPACE, "requiredProperties");
            }
            if (archetypeDescriptor.getFileSets() != null && archetypeDescriptor.getFileSets().size() > 0) {
                serializer.startTag(this.NAMESPACE, "fileSets");
                iter = archetypeDescriptor.getFileSets().iterator();
                while (iter.hasNext()) {
                    o = (FileSet)iter.next();
                    this.writeFileSet((FileSet)o, "fileSet", serializer);
                }
                serializer.endTag(this.NAMESPACE, "fileSets");
            }
            if (archetypeDescriptor.getModules() != null && archetypeDescriptor.getModules().size() > 0) {
                serializer.startTag(this.NAMESPACE, "modules");
                iter = archetypeDescriptor.getModules().iterator();
                while (iter.hasNext()) {
                    o = (ModuleDescriptor)iter.next();
                    this.writeModuleDescriptor((ModuleDescriptor)o, "module", serializer);
                }
                serializer.endTag(this.NAMESPACE, "modules");
            }
            serializer.endTag(this.NAMESPACE, tagName);
        }
    }

    private void writeFileSet(FileSet fileSet, String tagName, XmlSerializer serializer) throws IOException {
        if (fileSet != null) {
            Iterator iter;
            serializer.startTag(this.NAMESPACE, tagName);
            if (fileSet.isFiltered()) {
                serializer.attribute(this.NAMESPACE, "filtered", String.valueOf(fileSet.isFiltered()));
            }
            if (fileSet.isPackaged()) {
                serializer.attribute(this.NAMESPACE, "packaged", String.valueOf(fileSet.isPackaged()));
            }
            if (fileSet.getEncoding() != null) {
                serializer.attribute(this.NAMESPACE, "encoding", fileSet.getEncoding());
            }
            if (fileSet.getDirectory() != null) {
                serializer.startTag(this.NAMESPACE, "directory").text(fileSet.getDirectory()).endTag(this.NAMESPACE, "directory");
            }
            if (fileSet.getIncludes() != null && fileSet.getIncludes().size() > 0) {
                serializer.startTag(this.NAMESPACE, "includes");
                iter = fileSet.getIncludes().iterator();
                while (iter.hasNext()) {
                    String include = (String)iter.next();
                    serializer.startTag(this.NAMESPACE, "include").text(include).endTag(this.NAMESPACE, "include");
                }
                serializer.endTag(this.NAMESPACE, "includes");
            }
            if (fileSet.getExcludes() != null && fileSet.getExcludes().size() > 0) {
                serializer.startTag(this.NAMESPACE, "excludes");
                iter = fileSet.getExcludes().iterator();
                while (iter.hasNext()) {
                    String exclude = (String)iter.next();
                    serializer.startTag(this.NAMESPACE, "exclude").text(exclude).endTag(this.NAMESPACE, "exclude");
                }
                serializer.endTag(this.NAMESPACE, "excludes");
            }
            serializer.endTag(this.NAMESPACE, tagName);
        }
    }

    private void writeModuleDescriptor(ModuleDescriptor moduleDescriptor, String tagName, XmlSerializer serializer) throws IOException {
        if (moduleDescriptor != null) {
            Serializable o;
            Iterator iter;
            serializer.startTag(this.NAMESPACE, tagName);
            if (moduleDescriptor.getId() != null) {
                serializer.attribute(this.NAMESPACE, "id", moduleDescriptor.getId());
            }
            if (moduleDescriptor.getDir() != null) {
                serializer.attribute(this.NAMESPACE, "dir", moduleDescriptor.getDir());
            }
            if (moduleDescriptor.getName() != null) {
                serializer.attribute(this.NAMESPACE, "name", moduleDescriptor.getName());
            }
            if (moduleDescriptor.getFileSets() != null && moduleDescriptor.getFileSets().size() > 0) {
                serializer.startTag(this.NAMESPACE, "fileSets");
                iter = moduleDescriptor.getFileSets().iterator();
                while (iter.hasNext()) {
                    o = (FileSet)iter.next();
                    this.writeFileSet((FileSet)o, "fileSet", serializer);
                }
                serializer.endTag(this.NAMESPACE, "fileSets");
            }
            if (moduleDescriptor.getModules() != null && moduleDescriptor.getModules().size() > 0) {
                serializer.startTag(this.NAMESPACE, "modules");
                iter = moduleDescriptor.getModules().iterator();
                while (iter.hasNext()) {
                    o = (ModuleDescriptor)iter.next();
                    this.writeModuleDescriptor((ModuleDescriptor)o, "module", serializer);
                }
                serializer.endTag(this.NAMESPACE, "modules");
            }
            serializer.endTag(this.NAMESPACE, tagName);
        }
    }

    private void writeRequiredProperty(RequiredProperty requiredProperty, String tagName, XmlSerializer serializer) throws IOException {
        if (requiredProperty != null) {
            serializer.startTag(this.NAMESPACE, tagName);
            if (requiredProperty.getKey() != null) {
                serializer.attribute(this.NAMESPACE, "key", requiredProperty.getKey());
            }
            if (requiredProperty.getDefaultValue() != null) {
                serializer.startTag(this.NAMESPACE, "defaultValue").text(requiredProperty.getDefaultValue()).endTag(this.NAMESPACE, "defaultValue");
            }
            serializer.endTag(this.NAMESPACE, tagName);
        }
    }
}

