/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.chartostring;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.tree.IElementType;
import com.siyeh.ipp.base.PsiElementPredicate;

class CharToStringPredicate
implements PsiElementPredicate {
    CharToStringPredicate() {
    }

    @Override
    public boolean satisfiedBy(PsiElement element) {
        if (!(element instanceof PsiLiteralExpression)) {
            return false;
        }
        PsiLiteralExpression expression = (PsiLiteralExpression)element;
        PsiType type = expression.getType();
        if (!PsiType.CHAR.equals(type)) {
            return false;
        }
        String charLiteral = element.getText();
        if (charLiteral.length() < 2) {
            return false;
        }
        String charText = charLiteral.substring(1, charLiteral.length() - 1);
        if (StringUtil.unescapeStringCharacters((String)charText).length() != 1) {
            return false;
        }
        return CharToStringPredicate.isInConcatenationContext((PsiElement)expression);
    }

    private static boolean isInConcatenationContext(PsiElement element) {
        PsiElement parent = element.getParent();
        if (parent instanceof PsiBinaryExpression) {
            PsiBinaryExpression parentExpression = (PsiBinaryExpression)parent;
            PsiType parentType = parentExpression.getType();
            if (parentType == null) {
                return false;
            }
            String parentTypeText = parentType.getCanonicalText();
            return "java.lang.String".equals(parentTypeText);
        }
        if (parent instanceof PsiAssignmentExpression) {
            PsiAssignmentExpression parentExpression = (PsiAssignmentExpression)parent;
            PsiJavaToken sign = parentExpression.getOperationSign();
            IElementType tokenType = sign.getTokenType();
            if (!JavaTokenType.PLUSEQ.equals(tokenType)) {
                return false;
            }
            PsiType parentType = parentExpression.getType();
            if (parentType == null) {
                return false;
            }
            String parentTypeText = parentType.getCanonicalText();
            return "java.lang.String".equals(parentTypeText);
        }
        if (parent instanceof PsiExpressionList) {
            PsiElement grandParent = parent.getParent();
            if (!(grandParent instanceof PsiMethodCallExpression)) {
                return false;
            }
            PsiMethodCallExpression methodCall = (PsiMethodCallExpression)grandParent;
            PsiReferenceExpression methodExpression = methodCall.getMethodExpression();
            PsiExpression qualifierExpression = methodExpression.getQualifierExpression();
            PsiType type = qualifierExpression == null ? methodExpression.getType() : qualifierExpression.getType();
            if (type == null) {
                return false;
            }
            String className = type.getCanonicalText();
            if ("java.lang.StringBuffer".equals(className) || "java.lang.StringBuilder".equals(className)) {
                String methodName = methodExpression.getReferenceName();
                if (!"append".equals(methodName) && !"insert".equals(methodName)) {
                    return false;
                }
                PsiElement method = methodExpression.resolve();
                return method != null;
            }
            if ("java.lang.String".equals(className)) {
                String methodName = methodExpression.getReferenceName();
                if (!("indexOf".equals(methodName) || "lastIndexOf".equals(methodName) || "replace".equals(methodName))) {
                    return false;
                }
                PsiElement method = methodExpression.resolve();
                return method != null;
            }
        }
        return false;
    }
}

