/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.forloop;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.ipp.base.Intention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.forloop.IterableForEachLoopPredicate;
import org.jetbrains.annotations.NotNull;

public class ReplaceForEachLoopWithIteratorForLoopIntention
extends Intention {
    @Override
    @NotNull
    public PsiElementPredicate getElementPredicate() {
        IterableForEachLoopPredicate iterableForEachLoopPredicate = new IterableForEachLoopPredicate();
        if (iterableForEachLoopPredicate == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ipp/forloop/ReplaceForEachLoopWithIteratorForLoopIntention.getElementPredicate must not return null");
        }
        return iterableForEachLoopPredicate;
    }

    @Override
    public void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        PsiClassType classType;
        PsiType[] parameterTypes;
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ipp/forloop/ReplaceForEachLoopWithIteratorForLoopIntention.processIntention must not be null");
        }
        PsiForeachStatement statement = (PsiForeachStatement)element.getParent();
        if (statement == null) {
            return;
        }
        Project project = statement.getProject();
        JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)project);
        PsiExpression iteratedValue = statement.getIteratedValue();
        if (iteratedValue == null) {
            return;
        }
        PsiType type = iteratedValue.getType();
        PsiType iteratedValueParameterType = type instanceof PsiClassType ? ((parameterTypes = (classType = (PsiClassType)type).getParameters()).length == 0 ? null : parameterTypes[0]) : null;
        StringBuilder newStatement = new StringBuilder();
        PsiParameter iterationParameter = statement.getIterationParameter();
        PsiType parameterType = iterationParameter.getType();
        String iterator = codeStyleManager.suggestUniqueVariableName("iterator", (PsiElement)statement, true);
        String typeText = parameterType.getCanonicalText();
        newStatement.append("for(java.util.Iterator");
        if (iteratedValueParameterType == null) {
            newStatement.append(' ');
        } else {
            newStatement.append('<');
            newStatement.append(iteratedValueParameterType.getCanonicalText());
            newStatement.append("> ");
        }
        newStatement.append(iterator);
        newStatement.append(" = ");
        if (iteratedValue instanceof PsiTypeCastExpression) {
            newStatement.append('(');
            newStatement.append(iteratedValue.getText());
            newStatement.append(')');
        } else {
            newStatement.append(iteratedValue.getText());
        }
        newStatement.append(".iterator();");
        newStatement.append(iterator);
        newStatement.append(".hasNext();) {");
        CodeStyleSettings codeStyleSettings = CodeStyleSettingsManager.getSettings((Project)project);
        if (codeStyleSettings.GENERATE_FINAL_LOCALS) {
            newStatement.append("final ");
        }
        newStatement.append(typeText);
        newStatement.append(' ');
        newStatement.append(iterationParameter.getName());
        newStatement.append(" = ");
        if (iteratedValueParameterType == null && !"java.lang.Object".equals(typeText)) {
            newStatement.append('(');
            newStatement.append(typeText);
            newStatement.append(')');
        }
        newStatement.append(iterator);
        newStatement.append(".next();");
        PsiStatement body = statement.getBody();
        if (body == null) {
            return;
        }
        if (body instanceof PsiBlockStatement) {
            PsiCodeBlock block = ((PsiBlockStatement)body).getCodeBlock();
            PsiElement[] children = block.getChildren();
            for (int i = 1; i < children.length - 1; ++i) {
                newStatement.append(children[i].getText());
            }
        } else {
            newStatement.append(body.getText());
        }
        newStatement.append('}');
        ReplaceForEachLoopWithIteratorForLoopIntention.replaceStatementAndShorten(newStatement.toString(), (PsiStatement)statement);
    }
}

