/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit2.ui.actions;

import com.intellij.execution.configurations.RuntimeConfiguration;
import com.intellij.execution.junit2.ui.model.CompletionEvent;
import com.intellij.execution.junit2.ui.model.JUnitAdapter;
import com.intellij.execution.junit2.ui.model.StateEvent;
import com.intellij.execution.testframework.LvcsHelper;
import com.intellij.execution.testframework.TestFrameworkRunningModel;
import com.intellij.history.LocalHistoryConfiguration;

public class LvcsLabeler
extends JUnitAdapter {
    private final TestFrameworkRunningModel myModel;

    public LvcsLabeler(TestFrameworkRunningModel model) {
        this.myModel = model;
    }

    @Override
    public void onRunnerStateChanged(StateEvent event) {
        CompletionEvent completion;
        if (!(event instanceof CompletionEvent)) {
            return;
        }
        boolean areTestsFailed = this.myModel.getRoot().isDefect();
        if (!LvcsLabeler.needsLabel(areTestsFailed, (completion = (CompletionEvent)event).isNormalExit())) {
            return;
        }
        RuntimeConfiguration configuration = this.myModel.getProperties().getConfiguration();
        if (configuration == null) {
            return;
        }
        if (LvcsLabeler.testsTerminatedAndNotFailed(completion, areTestsFailed)) {
            return;
        }
        if (completion.isNormalExit()) {
            LvcsHelper.addLabel((TestFrameworkRunningModel)this.myModel);
        }
    }

    private static boolean testsTerminatedAndNotFailed(CompletionEvent completion, boolean areTestsPassed) {
        return !completion.isNormalExit() && areTestsPassed;
    }

    private static boolean needsLabel(boolean areTestsFailed, boolean testsDone) {
        LocalHistoryConfiguration config = LocalHistoryConfiguration.getInstance();
        if (config == null) {
            return false;
        }
        if (!testsDone) {
            return config.ADD_LABEL_ON_UNIT_TEST_FAILED;
        }
        return areTestsFailed ? config.ADD_LABEL_ON_UNIT_TEST_FAILED : config.ADD_LABEL_ON_UNIT_TEST_PASSED;
    }
}

