/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.intelliLang.inject.config;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.xml.XmlTokenImpl;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlElementType;
import java.util.Collections;
import java.util.Set;
import javax.xml.namespace.QName;
import org.intellij.lang.xpath.context.ContextProvider;
import org.intellij.lang.xpath.context.ContextType;
import org.intellij.lang.xpath.context.NamespaceContext;
import org.intellij.lang.xpath.context.VariableContext;
import org.intellij.lang.xpath.psi.XPathExpression;
import org.intellij.lang.xpath.psi.XPathType;
import org.intellij.plugins.xpathView.support.XPathSupport;
import org.jaxen.JaxenException;
import org.jaxen.XPath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class XPathSupportProxy {
    private static final Logger LOG = Logger.getInstance((String)"org.intellij.plugins.intelliLang.inject.config.XPathSupportProxy");
    public static final Object UNSUPPORTED = "UNSUPPORTED";
    public static final Object INVALID = "INVALID";
    private static XPathSupportProxy ourInstance;
    private static boolean isInitialized;

    @NotNull
    public abstract XPath createXPath(String var1) throws JaxenException;

    public abstract void attachContext(@NotNull PsiFile var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static synchronized XPathSupportProxy getInstance() {
        if (isInitialized) {
            return ourInstance;
        }
        try {
            XPathSupportProxy xPathSupportProxy = ourInstance = (XPathSupportProxy)ServiceManager.getService(XPathSupportProxy.class);
            return xPathSupportProxy;
        }
        finally {
            if (ourInstance == null) {
                LOG.info("XPath Support is not available");
            }
            isInitialized = true;
        }
    }

    public static class Impl
    extends XPathSupportProxy {
        private final ContextProvider myProvider = new Provider();
        private final XPathSupport mySupport = XPathSupport.getInstance();

        @Override
        @NotNull
        public XPath createXPath(String expression) throws JaxenException {
            XPath xPath = this.mySupport.createXPath(null, expression, Collections.emptyList());
            if (xPath == null) {
                throw new IllegalStateException("@NotNull method org/intellij/plugins/intelliLang/inject/config/XPathSupportProxy$Impl.createXPath must not return null");
            }
            return xPath;
        }

        @Override
        public void attachContext(@NotNull PsiFile file) {
            if (file == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/intellij/plugins/intelliLang/inject/config/XPathSupportProxy$Impl.attachContext must not be null");
            }
            this.myProvider.attachTo(file);
        }

        private static class Provider
        extends ContextProvider {
            private final XmlTokenImpl myDummyContext = new XmlTokenImpl(XmlElementType.XML_CONTENT_EMPTY, ""){

                public boolean isValid() {
                    return true;
                }
            };

            private Provider() {
            }

            @NotNull
            public ContextType getContextType() {
                ContextType contextType = XPathSupport.TYPE;
                if (contextType == null) {
                    throw new IllegalStateException("@NotNull method org/intellij/plugins/intelliLang/inject/config/XPathSupportProxy$Impl$Provider.getContextType must not return null");
                }
                return contextType;
            }

            @NotNull
            public XPathType getExpectedType(XPathExpression expr) {
                XPathType xPathType = XPathType.BOOLEAN;
                if (xPathType == null) {
                    throw new IllegalStateException("@NotNull method org/intellij/plugins/intelliLang/inject/config/XPathSupportProxy$Impl$Provider.getExpectedType must not return null");
                }
                return xPathType;
            }

            public XmlElement getContextElement() {
                return this.myDummyContext;
            }

            public NamespaceContext getNamespaceContext() {
                return null;
            }

            public VariableContext getVariableContext() {
                return null;
            }

            public Set<QName> getAttributes(boolean forValidation) {
                return null;
            }

            public Set<QName> getElements(boolean forValidation) {
                return null;
            }
        }
    }
}

