/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.intelliLang.inject.xml;

import com.intellij.lang.Language;
import com.intellij.lang.injection.MultiHostInjector;
import com.intellij.lang.injection.MultiHostRegistrar;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.PairProcessor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;
import org.intellij.plugins.intelliLang.Configuration;
import org.intellij.plugins.intelliLang.inject.InjectedLanguage;
import org.intellij.plugins.intelliLang.inject.InjectorUtils;
import org.intellij.plugins.intelliLang.inject.LanguageInjectionSupport;
import org.intellij.plugins.intelliLang.inject.config.AbstractTagInjection;
import org.intellij.plugins.intelliLang.inject.config.BaseInjection;
import org.jetbrains.annotations.NotNull;

public final class XmlLanguageInjector
implements MultiHostInjector {
    private final Configuration myInjectionConfiguration;

    public XmlLanguageInjector(Configuration configuration) {
        this.myInjectionConfiguration = configuration;
    }

    @NotNull
    public List<? extends Class<? extends PsiElement>> elementsToInjectIn() {
        List<Class> list = Arrays.asList(XmlTag.class, XmlAttribute.class);
        if (list == null) {
            throw new IllegalStateException("@NotNull method org/intellij/plugins/intelliLang/inject/xml/XmlLanguageInjector.elementsToInjectIn must not return null");
        }
        return list;
    }

    public void getLanguagesToInject(final @NotNull MultiHostRegistrar registrar, @NotNull PsiElement host) {
        if (registrar == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/intellij/plugins/intelliLang/inject/xml/XmlLanguageInjector.getLanguagesToInject must not be null");
        }
        if (host == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/intellij/plugins/intelliLang/inject/xml/XmlLanguageInjector.getLanguagesToInject must not be null");
        }
        final TreeSet<TextRange> ranges = new TreeSet<TextRange>(InjectorUtils.RANGE_COMPARATOR);
        final PsiFile containingFile = host.getContainingFile();
        this.getInjectedLanguage(host, new PairProcessor<Language, List<Trinity<PsiLanguageInjectionHost, InjectedLanguage, TextRange>>>(){

            public boolean process(Language language, List<Trinity<PsiLanguageInjectionHost, InjectedLanguage, TextRange>> list) {
                for (Trinity<PsiLanguageInjectionHost, InjectedLanguage, TextRange> trinity : list) {
                    if (!ranges.contains(((TextRange)trinity.third).shiftRight(((PsiLanguageInjectionHost)trinity.first).getTextRange().getStartOffset()))) continue;
                    return true;
                }
                for (Trinity<PsiLanguageInjectionHost, InjectedLanguage, TextRange> trinity : list) {
                    PsiLanguageInjectionHost host = (PsiLanguageInjectionHost)trinity.first;
                    if (host.getContainingFile() != containingFile) continue;
                    TextRange textRange = (TextRange)trinity.third;
                    ranges.add(textRange.shiftRight(host.getTextRange().getStartOffset()));
                }
                InjectorUtils.registerInjection(language, list, containingFile, registrar);
                return true;
            }
        });
    }

    void getInjectedLanguage(PsiElement place, PairProcessor<Language, List<Trinity<PsiLanguageInjectionHost, InjectedLanguage, TextRange>>> processor) {
        block13: {
            block14: {
                if (!(place instanceof XmlTag)) break block14;
                XmlTag xmlTag = (XmlTag)place;
                for (final BaseInjection injection : this.myInjectionConfiguration.getInjections("xml")) {
                    Language language;
                    if (!injection.acceptsPsiElement((PsiElement)xmlTag) || (language = InjectedLanguage.findLanguageById(injection.getInjectedLanguageId())) == null) continue;
                    boolean separateFiles = !injection.isSingleFile() && StringUtil.isNotEmpty((String)injection.getValuePattern());
                    final Ref hasSubTags = Ref.create((Object)Boolean.FALSE);
                    final ArrayList result = new ArrayList();
                    xmlTag.acceptChildren(new PsiElementVisitor(){

                        public void visitElement(PsiElement element) {
                            if (element instanceof XmlText) {
                                if (element.getTextLength() == 0) {
                                    return;
                                }
                                List<TextRange> list = injection.getInjectedArea(element);
                                InjectedLanguage l = InjectedLanguage.create(injection.getInjectedLanguageId(), injection.getPrefix(), injection.getSuffix(), false);
                                for (TextRange textRange : list) {
                                    result.add(Trinity.create((Object)((PsiLanguageInjectionHost)element), (Object)l, (Object)textRange));
                                }
                            } else if (element instanceof XmlTag) {
                                hasSubTags.set((Object)Boolean.TRUE);
                                if (injection instanceof AbstractTagInjection && ((AbstractTagInjection)injection).isApplyToSubTagTexts()) {
                                    element.acceptChildren((PsiElementVisitor)this);
                                }
                            }
                        }
                    });
                    if (!result.isEmpty()) {
                        if (separateFiles) {
                            for (Trinity trinity : result) {
                                processor.process((Object)language, Collections.singletonList(trinity));
                            }
                        } else {
                            for (Trinity trinity : result) {
                                ((PsiLanguageInjectionHost)trinity.first).putUserData(LanguageInjectionSupport.HAS_UNPARSABLE_FRAGMENTS, hasSubTags.get());
                            }
                            processor.process((Object)language, result);
                        }
                    }
                    if (!injection.isTerminal()) continue;
                    break block13;
                }
                break block13;
            }
            if (!(place instanceof XmlAttribute)) break block13;
            XmlAttribute attribute = (XmlAttribute)place;
            XmlAttributeValue value = attribute.getValueElement();
            if (value == null) {
                return;
            }
            PsiElement[] children = value.getChildren();
            if (children.length < 3 || !(children[1] instanceof XmlToken) || ((XmlToken)children[1]).getTokenType() != XmlTokenType.XML_ATTRIBUTE_VALUE_TOKEN) {
                return;
            }
            for (BaseInjection injection : this.myInjectionConfiguration.getInjections("xml")) {
                Language language;
                if (!injection.acceptsPsiElement((PsiElement)attribute) || (language = InjectedLanguage.findLanguageById(injection.getInjectedLanguageId())) == null) continue;
                boolean separateFiles = !injection.isSingleFile() && StringUtil.isNotEmpty((String)injection.getValuePattern());
                List<TextRange> ranges = injection.getInjectedArea((PsiElement)value);
                if (ranges.isEmpty()) continue;
                ArrayList<Trinity> result = new ArrayList<Trinity>();
                InjectedLanguage l = InjectedLanguage.create(injection.getInjectedLanguageId(), injection.getPrefix(), injection.getSuffix(), false);
                for (TextRange textRange : ranges) {
                    result.add(Trinity.create((Object)((PsiLanguageInjectionHost)value), (Object)l, (Object)textRange));
                }
                if (separateFiles) {
                    for (Trinity trinity : result) {
                        processor.process((Object)language, Collections.singletonList(trinity));
                    }
                } else {
                    processor.process((Object)language, result);
                }
                if (!injection.isTerminal()) continue;
                break;
            }
        }
    }
}

