/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.junit4;

import com.intellij.junit4.JUnit4ReflectionUtil;
import org.junit.runner.Description;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;

class SMTestSender
extends RunListener {
    private String myCurrentClassName;

    SMTestSender() {
    }

    public void testRunStarted(Description description) throws Exception {
    }

    public void testRunFinished(Result result) throws Exception {
        if (this.myCurrentClassName != null) {
            System.out.println("##teamcity[testSuiteFinished name='" + this.myCurrentClassName + "']");
        }
    }

    public void testStarted(Description description) throws Exception {
        String className = JUnit4ReflectionUtil.getClassName(description);
        if (this.myCurrentClassName == null || !this.myCurrentClassName.equals(className)) {
            if (this.myCurrentClassName != null) {
                System.out.println("##teamcity[testSuiteFinished name='" + this.myCurrentClassName + "']");
            }
            this.myCurrentClassName = className;
            System.out.println("##teamcity[testSuiteStarted name='" + className + "']");
        }
        System.out.println("##teamcity[testStarted name='" + JUnit4ReflectionUtil.getMethodName(description) + "']");
    }

    public void testFinished(Description description) throws Exception {
        System.out.println("##teamcity[testFinished name='" + JUnit4ReflectionUtil.getMethodName(description) + "']");
    }

    public void testFailure(Failure failure) throws Exception {
        System.out.println("##teamcity[testFailed name='" + JUnit4ReflectionUtil.getMethodName(failure.getDescription()) + "' message='" + failure.getMessage() + "' details='" + failure.getTrace().replaceAll("\n", "n").replaceAll("\r", "r") + "']");
    }

    public void testAssumptionFailure(Failure failure) {
    }

    public void testIgnored(Description description) throws Exception {
        System.out.println("##teamcity[testIgnored name='" + JUnit4ReflectionUtil.getMethodName(description) + "']");
    }
}

