/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy;

import com.intellij.ide.IconProvider;
import com.intellij.openapi.project.DumbAware;
import com.intellij.psi.PsiElement;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyIcons;
import org.jetbrains.plugins.groovy.extensions.GroovyScriptType;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;

public class GroovyIconProvider
extends IconProvider
implements DumbAware {
    @Nullable
    public Icon getIcon(@NotNull PsiElement element, int flags) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/GroovyIconProvider.getIcon must not be null");
        }
        if (element instanceof GroovyFile) {
            GroovyFile file = (GroovyFile)element;
            if (!file.isScript()) {
                GrTypeDefinition[] typeDefinitions = file.getTypeDefinitions();
                if (typeDefinitions.length > 0) {
                    return typeDefinitions[0].getIcon(flags);
                }
                return GroovyIcons.GROOVY_ICON_16x16;
            }
            return GroovyScriptType.getScriptType(file).getScriptIcon();
        }
        return null;
    }
}

