/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.actions;

import com.intellij.CommonBundle;
import com.intellij.ide.actions.CreateFileFromTemplateDialog;
import com.intellij.ide.actions.CreateTemplateInPackageAction;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKeys;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.GroovyIcons;
import org.jetbrains.plugins.groovy.actions.GroovyTemplatesFactory;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.util.LibrariesUtil;

public class NewScriptAction
extends CreateTemplateInPackageAction<GroovyFile>
implements DumbAware {
    private static final String GROOVY_DSL_SCRIPT_TMPL = "GroovyDslScript.gdsl";

    public NewScriptAction() {
        super(GroovyBundle.message("newscript.menu.action.text", new Object[0]), GroovyBundle.message("newscript.menu.action.description", new Object[0]), GroovyIcons.GROOVY_ICON_16x16, false);
    }

    @NotNull
    protected CreateFileFromTemplateDialog.Builder buildDialog(Project project, PsiDirectory directory) {
        CreateFileFromTemplateDialog.Builder builder = CreateFileFromTemplateDialog.createDialog((Project)project, (String)GroovyBundle.message("newscript.dlg.prompt", new Object[0]));
        builder.addKind("Groovy script", GroovyIcons.GROOVY_ICON_16x16, "GroovyScript.groovy");
        builder.addKind("GroovyDSL script", GroovyIcons.GROOVY_ICON_16x16, GROOVY_DSL_SCRIPT_TMPL);
        CreateFileFromTemplateDialog.Builder builder2 = builder;
        if (builder2 == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/actions/NewScriptAction.buildDialog must not return null");
        }
        return builder2;
    }

    protected boolean isAvailable(DataContext dataContext) {
        return super.isAvailable(dataContext) && LibrariesUtil.hasGroovySdk((Module)DataKeys.MODULE.getData(dataContext));
    }

    protected String getActionName(PsiDirectory directory, String newName, String templateName) {
        return GroovyBundle.message("newscript.menu.action.text", new Object[0]);
    }

    protected String getErrorTitle() {
        return CommonBundle.getErrorTitle();
    }

    protected PsiElement getNavigationElement(@NotNull GroovyFile createdFile) {
        if (createdFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/actions/NewScriptAction.getNavigationElement must not be null");
        }
        return createdFile.getLastChild();
    }

    @NotNull
    protected GroovyFile doCreate(PsiDirectory directory, String newName, String templateName) throws IncorrectOperationException {
        PsiFile file = null;
        file = GROOVY_DSL_SCRIPT_TMPL.equals(templateName) ? GroovyTemplatesFactory.createFromTemplate(directory, newName, newName + ".gdsl", templateName, new String[0]) : GroovyTemplatesFactory.createFromTemplate(directory, newName, newName + "." + "groovy", templateName, new String[0]);
        assert (file instanceof GroovyFile);
        GroovyFile groovyFile = (GroovyFile)file;
        if (groovyFile == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/actions/NewScriptAction.doCreate must not return null");
        }
        return groovyFile;
    }
}

