/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator;

import com.intellij.codeInsight.daemon.impl.quickfix.AddMethodBodyFix;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.ASTNode;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.ResolveState;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.annotator.intentions.ChangeExtendsImplementsQuickFix;
import org.jetbrains.plugins.groovy.annotator.intentions.ChangePackageQuickFix;
import org.jetbrains.plugins.groovy.annotator.intentions.CreateClassFix;
import org.jetbrains.plugins.groovy.annotator.intentions.CreateFieldFromConstructorLabelFix;
import org.jetbrains.plugins.groovy.annotator.intentions.CreateFieldFromUsageFix;
import org.jetbrains.plugins.groovy.annotator.intentions.CreateLocalVariableFromUsageFix;
import org.jetbrains.plugins.groovy.annotator.intentions.CreateMethodFromUsageFix;
import org.jetbrains.plugins.groovy.annotator.intentions.GrModifierFix;
import org.jetbrains.plugins.groovy.annotator.intentions.GroovyAddImportAction;
import org.jetbrains.plugins.groovy.annotator.intentions.GroovyStaticImportMethodFix;
import org.jetbrains.plugins.groovy.annotator.intentions.QuickfixUtil;
import org.jetbrains.plugins.groovy.annotator.intentions.dynamic.DynamicMethodFix;
import org.jetbrains.plugins.groovy.annotator.intentions.dynamic.DynamicPropertyFix;
import org.jetbrains.plugins.groovy.codeInspection.GroovyImportsTracker;
import org.jetbrains.plugins.groovy.config.GroovyConfigUtils;
import org.jetbrains.plugins.groovy.highlighter.DefaultHighlighter;
import org.jetbrains.plugins.groovy.intentions.utils.DuplicatesUtil;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocComment;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocFieldReference;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocMemberReference;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocMethodReference;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocReferenceElement;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.lexer.TokenSets;
import org.jetbrains.plugins.groovy.lang.psi.GrReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFileBase;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.GrListOrMap;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifierList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrConstructorInvocation;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrLabeledStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrLoopStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrParametersOwner;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrTopLevelDefintion;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentLabel;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrOpenBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrBreakStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrContinueStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrFlowInterruptingStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrReturnStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.clauses.GrForInClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrNewExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrSuperReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrThisReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrEnumTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrExtendsClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrImplementsClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrMemberOwner;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinitionBody;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrAccessorMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMember;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.imports.GrImportStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.packaging.GrPackageDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.util.GrVariableDeclarationOwner;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrClosureType;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GroovyScriptClass;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;
import org.jetbrains.plugins.groovy.lang.resolve.processors.PropertyResolverProcessor;
import org.jetbrains.plugins.groovy.overrideImplement.GroovyOverrideImplementUtil;
import org.jetbrains.plugins.groovy.overrideImplement.quickFix.ImplementMethodsQuickFix;

public class GroovyAnnotator
extends GroovyElementVisitor
implements Annotator {
    private static final Logger LOG = Logger.getInstance((String)"org.jetbrains.plugins.groovy.annotator.GroovyAnnotator");
    private AnnotationHolder myHolder;

    private static boolean isDocCommentElement(PsiElement element) {
        if (element == null) {
            return false;
        }
        ASTNode node = element.getNode();
        return node != null && PsiTreeUtil.getParentOfType((PsiElement)element, GrDocComment.class) != null || element instanceof GrDocComment;
    }

    public void annotate(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/annotator/GroovyAnnotator.annotate must not be null");
        }
        if (holder == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/jetbrains/plugins/groovy/annotator/GroovyAnnotator.annotate must not be null");
        }
        if (element instanceof GroovyPsiElement) {
            this.myHolder = holder;
            ((GroovyPsiElement)element).accept(this);
            this.myHolder = null;
        }
    }

    @Override
    public void visitElement(GroovyPsiElement element) {
        if (element.getParent() instanceof GrDocReferenceElement) {
            GroovyAnnotator.checkGrDocReferenceElement(this.myHolder, element);
        } else {
            ASTNode node = element.getNode();
            if (!(element instanceof PsiWhiteSpace) && !GroovyTokenTypes.COMMENT_SET.contains(node.getElementType()) && element.getContainingFile() instanceof GroovyFile && !GroovyAnnotator.isDocCommentElement(element)) {
                GroovyImportsTracker.getInstance(element.getProject()).markFileAnnotated((GroovyFile)element.getContainingFile());
            }
        }
    }

    @Override
    public void visitCodeReferenceElement(GrCodeReferenceElement refElement) {
        PsiElement parent = refElement.getParent();
        GroovyResolveResult resolveResult = refElement.advancedResolve();
        GroovyAnnotator.highlightAnnotation(this.myHolder, refElement, resolveResult);
        GroovyAnnotator.registerUsedImport(refElement, resolveResult);
        GroovyAnnotator.highlightAnnotation(this.myHolder, refElement, resolveResult);
        if (refElement.getReferenceName() != null) {
            if (parent instanceof GrImportStatement && ((GrImportStatement)parent).isStatic() && refElement.multiResolve(false).length > 0) {
                return;
            }
            GroovyAnnotator.checkSingleResolvedElement(this.myHolder, refElement, resolveResult, true);
        }
    }

    @Override
    public void visitReferenceExpression(GrReferenceExpression referenceExpression) {
        GroovyResolveResult[] results;
        GroovyResolveResult resolveResult = referenceExpression.advancedResolve();
        for (GroovyResolveResult result : results = referenceExpression.multiResolve(false)) {
            GroovyAnnotator.registerUsedImport(referenceExpression, result);
        }
        PsiElement resolved = resolveResult.getElement();
        PsiElement parent = referenceExpression.getParent();
        if (resolved != null) {
            if (resolved instanceof PsiMember) {
                GroovyAnnotator.highlightMemberResolved(this.myHolder, referenceExpression, (PsiMember)resolved);
            }
            if (!resolveResult.isAccessible()) {
                String message = GroovyBundle.message("cannot.access", referenceExpression.getReferenceName());
                Annotation annotation = this.myHolder.createWarningAnnotation(referenceExpression.getReferenceNameElement(), message);
                if (resolved instanceof PsiMember) {
                    GroovyAnnotator.registerAccessFix(annotation, referenceExpression, (PsiMember)resolved);
                }
            }
            if (!resolveResult.isStaticsOK() && resolved instanceof PsiModifierListOwner && !((PsiModifierListOwner)resolved).hasModifierProperty("static")) {
                this.myHolder.createWarningAnnotation((PsiElement)referenceExpression, GroovyBundle.message("cannot.reference.nonstatic", referenceExpression.getReferenceName()));
            }
        } else {
            GrExpression qualifier = referenceExpression.getQualifierExpression();
            if (qualifier == null && GroovyAnnotator.isDeclarationAssignment(referenceExpression)) {
                return;
            }
            if (parent instanceof GrReferenceExpression && "class".equals(((GrReferenceExpression)parent).getReferenceName())) {
                GroovyAnnotator.checkSingleResolvedElement(this.myHolder, referenceExpression, resolveResult, false);
            }
        }
        if (parent instanceof GrCall) {
            if (resolved == null && results.length > 0) {
                resolved = results[0].getElement();
                resolveResult = results[0];
            }
            if (resolved instanceof PsiMethod && resolved.getUserData(GrMethod.BUILDER_METHOD) == null) {
                GroovyAnnotator.checkMethodApplicability(resolveResult, referenceExpression, this.myHolder);
            } else {
                GroovyAnnotator.checkClosureApplicability(resolveResult, referenceExpression.getType(), referenceExpression, this.myHolder);
            }
        }
        if (GroovyAnnotator.isDeclarationAssignment(referenceExpression) || resolved instanceof PsiPackage) {
            return;
        }
        if (resolved == null) {
            PsiElement refNameElement = referenceExpression.getReferenceNameElement();
            GrReferenceExpression elt = refNameElement == null ? referenceExpression : refNameElement;
            Annotation annotation = this.myHolder.createInfoAnnotation((PsiElement)elt, null);
            GrExpression qualifier = referenceExpression.getQualifierExpression();
            if (qualifier == null) {
                if (!(parent instanceof GrCall)) {
                    GroovyAnnotator.registerCreateClassByTypeFix(referenceExpression, annotation);
                    GroovyAnnotator.registerAddImportFixes(referenceExpression, annotation);
                } else {
                    GroovyAnnotator.registerStaticImportFix(referenceExpression, annotation);
                }
            } else if (qualifier.getType() == null) {
                return;
            }
            GroovyAnnotator.registerReferenceFixes(referenceExpression, annotation);
            annotation.setTextAttributes(DefaultHighlighter.UNRESOLVED_ACCESS);
        }
    }

    private static void registerAccessFix(Annotation annotation, GrReferenceExpression place, PsiMember refElement) {
        if (refElement instanceof PsiCompiledElement) {
            return;
        }
        PsiModifierList modifierList = refElement.getModifierList();
        if (modifierList == null) {
            return;
        }
        try {
            Project project = refElement.getProject();
            JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)project);
            PsiModifierList modifierListCopy = facade.getElementFactory().createFieldFromText("int a;", null).getModifierList();
            modifierListCopy.setModifierProperty("static", modifierList.hasModifierProperty("static"));
            String minModifier = "protected";
            if (refElement.hasModifierProperty("protected")) {
                minModifier = "public";
            }
            Object[] modifiers = new String[]{"protected", "public", "packageLocal"};
            PsiClass accessObjectClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)place, PsiClass.class, (boolean)false);
            if (accessObjectClass == null) {
                accessObjectClass = ((GroovyFile)place.getContainingFile()).getScriptClass();
            }
            for (int i = ArrayUtil.indexOf((Object[])modifiers, (Object)minModifier); i < modifiers.length; ++i) {
                Object modifier = modifiers[i];
                modifierListCopy.setModifierProperty((String)modifier, true);
                if (!facade.getResolveHelper().isAccessible(refElement, modifierListCopy, (PsiElement)place, accessObjectClass, null)) continue;
                GrModifierFix fix = new GrModifierFix(refElement, refElement.getModifierList(), (String)modifier, true, true);
                annotation.registerFix((IntentionAction)fix);
            }
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    private static void registerStaticImportFix(GrReferenceExpression referenceExpression, Annotation annotation) {
        String referenceName = referenceExpression.getReferenceName();
        if (StringUtil.isEmpty((String)referenceName)) {
            return;
        }
        annotation.registerFix((IntentionAction)new GroovyStaticImportMethodFix((GrCall)referenceExpression.getParent()));
    }

    @Override
    public void visitTypeDefinition(GrTypeDefinition typeDefinition) {
        GroovyAnnotator.checkTypeDefinition(this.myHolder, typeDefinition);
        GroovyAnnotator.checkTypeDefinitionModifiers(this.myHolder, typeDefinition);
        GrTypeDefinitionBody body = typeDefinition.getBody();
        if (body != null) {
            GroovyAnnotator.checkDuplicateMethod(body.getGroovyMethods(), this.myHolder);
        }
        GroovyAnnotator.checkImplementedMethodsOfClass(this.myHolder, typeDefinition);
    }

    @Override
    public void visitMethod(GrMethod method) {
        GroovyAnnotator.checkMethodDefinitionModifiers(this.myHolder, method);
        GroovyAnnotator.checkInnerMethod(this.myHolder, method);
    }

    @Override
    public void visitVariableDeclaration(GrVariableDeclaration variableDeclaration) {
        PsiElement parent = variableDeclaration.getParent();
        assert (parent != null);
        PsiElement typeDef = parent.getParent();
        if (typeDef != null && typeDef instanceof GrTypeDefinition) {
            Annotation annotation;
            GrModifierList modifiersList = variableDeclaration.getModifierList();
            GrMember member = variableDeclaration.getMembers()[0];
            GroovyAnnotator.checkAccessModifiers(this.myHolder, modifiersList, member);
            GroovyAnnotator.checkDuplicateModifiers(this.myHolder, variableDeclaration.getModifierList(), member);
            if (modifiersList.hasExplicitModifier("volatile") && modifiersList.hasExplicitModifier("final")) {
                annotation = this.myHolder.createErrorAnnotation((PsiElement)modifiersList, GroovyBundle.message("illegal.combination.of.modifiers.volatile.and.final", new Object[0]));
                annotation.registerFix((IntentionAction)new GrModifierFix(member, modifiersList, "volatile", true, false));
                annotation.registerFix((IntentionAction)new GrModifierFix(member, modifiersList, "final", true, false));
            }
            if (modifiersList.hasExplicitModifier("native")) {
                annotation = this.myHolder.createErrorAnnotation((PsiElement)modifiersList, GroovyBundle.message("variable.cannot.be.native", new Object[0]));
                annotation.registerFix((IntentionAction)new GrModifierFix(member, modifiersList, "native", true, false));
            }
            if (modifiersList.hasExplicitModifier("abstract")) {
                annotation = this.myHolder.createErrorAnnotation((PsiElement)modifiersList, GroovyBundle.message("variable.cannot.be.abstract", new Object[0]));
                annotation.registerFix((IntentionAction)new GrModifierFix(member, modifiersList, "abstract", true, false));
            }
        }
    }

    @Override
    public void visitVariable(GrVariable variable) {
        DuplicateVariablesProcessor processor;
        GroovyPsiElement duplicate;
        if (variable instanceof GrMember) {
            GroovyAnnotator.highlightMember(this.myHolder, (GrMember)((Object)variable));
            GroovyAnnotator.checkStaticDeclarationsInInnerClass((GrMember)((Object)variable), this.myHolder);
        }
        if ((duplicate = (GroovyPsiElement)ResolveUtil.resolveExistingElement(variable, processor = new DuplicateVariablesProcessor(variable), GrVariable.class, GrReferenceExpression.class)) instanceof GrVariable) {
            if (duplicate instanceof GrField && !(variable instanceof GrField)) {
                this.myHolder.createWarningAnnotation(variable.getNameIdentifierGroovy(), GroovyBundle.message("field.already.defined", variable.getName()));
            } else {
                String key = duplicate instanceof GrField ? "field.already.defined" : "variable.already.defined";
                this.myHolder.createErrorAnnotation(variable.getNameIdentifierGroovy(), GroovyBundle.message(key, variable.getName()));
            }
        }
    }

    @Override
    public void visitAssignmentExpression(GrAssignmentExpression expression) {
        GrExpression lValue = expression.getLValue();
        if (!PsiUtil.mightBeLVlaue(lValue)) {
            this.myHolder.createErrorAnnotation((PsiElement)lValue, GroovyBundle.message("invalid.lvalue", new Object[0]));
        }
    }

    @Override
    public void visitReturnStatement(GrReturnStatement returnStatement) {
        GrParametersOwner owner;
        PsiType type;
        GrExpression value = returnStatement.getReturnValue();
        if (value != null && (type = value.getType()) != null && (owner = (GrParametersOwner)PsiTreeUtil.getParentOfType((PsiElement)returnStatement, (Class[])new Class[]{GrMethod.class, GrClosableBlock.class})) instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)owner;
            if (method.isConstructor()) {
                this.myHolder.createErrorAnnotation((PsiElement)value, GroovyBundle.message("cannot.return.from.constructor", new Object[0]));
            } else {
                PsiType methodType = method.getReturnType();
                if (methodType != null && PsiType.VOID.equals(methodType)) {
                    this.myHolder.createErrorAnnotation((PsiElement)value, GroovyBundle.message("cannot.return.from.void.method", new Object[0]));
                }
            }
        }
    }

    @Override
    public void visitListOrMap(GrListOrMap listOrMap) {
        Map map = DuplicatesUtil.factorDuplicates((PsiElement[])listOrMap.getNamedArguments(), (TObjectHashingStrategy)new TObjectHashingStrategy<GrNamedArgument>(){

            public int computeHashCode(GrNamedArgument arg) {
                GrArgumentLabel label = arg.getLabel();
                if (label == null) {
                    return 0;
                }
                String name = label.getName();
                if (name == null) {
                    return 0;
                }
                return name.hashCode();
            }

            public boolean equals(GrNamedArgument arg1, GrNamedArgument arg2) {
                GrArgumentLabel label1 = arg1.getLabel();
                GrArgumentLabel label2 = arg2.getLabel();
                if (label1 == null || label2 == null) {
                    return label1 == null && label2 == null;
                }
                String name1 = label1.getName();
                String name2 = label2.getName();
                if (name1 == null || name2 == null) {
                    return name1 == null && name2 == null;
                }
                return name1.equals(name2);
            }
        });
        GroovyAnnotator.processDuplicates(map, this.myHolder);
    }

    @Override
    public void visitNewExpression(GrNewExpression newExpression) {
        GroovyResolveResult constructorResolveResult;
        PsiElement constructor;
        if (newExpression.getArrayCount() > 0) {
            return;
        }
        GrCodeReferenceElement refElement = newExpression.getReferenceElement();
        if (refElement == null) {
            return;
        }
        PsiElement element = refElement.resolve();
        if (element instanceof PsiClass) {
            PsiClass clazz = (PsiClass)element;
            if (clazz.hasModifierProperty("abstract")) {
                if (newExpression.getAnonymousClassDefinition() == null) {
                    String message = clazz.isInterface() ? GroovyBundle.message("cannot.instantiate.interface", clazz.getName()) : GroovyBundle.message("cannot.instantiate.abstract.class", clazz.getName());
                    this.myHolder.createErrorAnnotation((PsiElement)refElement, message);
                }
                return;
            }
            if (newExpression.getQualifier() != null) {
                if (clazz.hasModifierProperty("static")) {
                    this.myHolder.createErrorAnnotation((PsiElement)newExpression, GroovyBundle.message("qualified.new.of.static.class", new Object[0]));
                }
            } else {
                PsiClass outerClass = clazz.getContainingClass();
                if (com.intellij.psi.util.PsiUtil.isInnerClass((PsiClass)clazz) && !PsiUtil.hasEnclosingInstanceInScope(outerClass, newExpression, true)) {
                    this.myHolder.createErrorAnnotation((PsiElement)newExpression, GroovyBundle.message("cannot.reference.nonstatic", clazz.getQualifiedName()));
                }
            }
        }
        if ((constructor = (constructorResolveResult = newExpression.resolveConstructorGenerics()).getElement()) != null) {
            GrArgumentList argList = newExpression.getArgumentList();
            if (argList != null && argList.getExpressionArguments().length == 0 && ((PsiMethod)constructor).getParameterList().getParametersCount() == 0) {
                GroovyAnnotator.checkDefaultMapConstructor(this.myHolder, argList, constructor);
            } else {
                GroovyAnnotator.checkMethodApplicability(constructorResolveResult, refElement, this.myHolder);
            }
        } else {
            GrArgumentList toHighlight;
            GroovyResolveResult[] results = newExpression.multiResolveConstructor();
            GrArgumentList argList = newExpression.getArgumentList();
            GrArgumentList grArgumentList = toHighlight = argList != null ? argList : refElement.getReferenceNameElement();
            if (results.length > 0) {
                String message = GroovyBundle.message("ambiguous.constructor.call", new Object[0]);
                this.myHolder.createWarningAnnotation((PsiElement)toHighlight, message);
            } else if (element instanceof PsiClass) {
                PsiType[] argumentTypes = PsiUtil.getArgumentTypes(refElement, true);
                if (argumentTypes == null || argumentTypes.length == 0 || argumentTypes.length == 1 && PsiUtil.createMapType(newExpression.getManager(), newExpression.getResolveScope()).isAssignableFrom(argumentTypes[0])) {
                    GroovyAnnotator.checkDefaultMapConstructor(this.myHolder, argList, element);
                } else {
                    String message = GroovyBundle.message("cannot.find.default.constructor", ((PsiClass)element).getName());
                    this.myHolder.createWarningAnnotation((PsiElement)toHighlight, message);
                }
            }
        }
    }

    @Override
    public void visitDocMethodReference(GrDocMethodReference reference) {
        GroovyAnnotator.checkGrDocMemberReference(reference, this.myHolder);
    }

    @Override
    public void visitDocFieldReference(GrDocFieldReference reference) {
        GroovyAnnotator.checkGrDocMemberReference(reference, this.myHolder);
    }

    @Override
    public void visitConstructorInvocation(GrConstructorInvocation invocation) {
        GroovyResolveResult resolveResult = invocation.resolveConstructorGenerics();
        if (resolveResult != null && resolveResult.getElement() != null) {
            GroovyAnnotator.checkMethodApplicability(resolveResult, invocation, this.myHolder);
        } else {
            GroovyResolveResult[] results = invocation.multiResolveConstructor();
            GrArgumentList argList = invocation.getArgumentList();
            if (results.length > 0) {
                String message = GroovyBundle.message("ambiguous.constructor.call", new Object[0]);
                this.myHolder.createWarningAnnotation((PsiElement)argList, message);
            } else {
                PsiType[] argumentTypes;
                PsiClass clazz = invocation.getDelegatedClass();
                if (clazz != null && (argumentTypes = PsiUtil.getArgumentTypes(invocation.getThisOrSuperKeyword(), true)) != null && argumentTypes.length > 0) {
                    String message = GroovyBundle.message("cannot.find.default.constructor", clazz.getName());
                    this.myHolder.createWarningAnnotation((PsiElement)argList, message);
                }
            }
        }
    }

    @Override
    public void visitBreakStatement(GrBreakStatement breakStatement) {
        GroovyAnnotator.checkFlowInterruptStatement(breakStatement, this.myHolder);
    }

    @Override
    public void visitContinueStatement(GrContinueStatement continueStatement) {
        GroovyAnnotator.checkFlowInterruptStatement(continueStatement, this.myHolder);
    }

    @Override
    public void visitLabeledStatement(GrLabeledStatement labeledStatement) {
        String name = labeledStatement.getLabelName();
        if (ResolveUtil.resolveLabeledStatement(name, labeledStatement, true) != null) {
            this.myHolder.createWarningAnnotation((PsiElement)labeledStatement.getLabel(), GroovyBundle.message("label.already.used", name));
        }
    }

    @Override
    public void visitPackageDefinition(GrPackageDefinition packageDefinition) {
        PsiPackage aPackage;
        PsiFile file = packageDefinition.getContainingFile();
        assert (file != null);
        PsiDirectory psiDirectory = file.getContainingDirectory();
        if (psiDirectory != null && (aPackage = JavaDirectoryService.getInstance().getPackage(psiDirectory)) != null) {
            String packageName = aPackage.getQualifiedName();
            if (!packageDefinition.getPackageName().equals(packageName)) {
                Annotation annotation = this.myHolder.createWarningAnnotation((PsiElement)packageDefinition, "wrong package name");
                annotation.registerFix((IntentionAction)new ChangePackageQuickFix((GroovyFile)packageDefinition.getContainingFile(), packageName));
            }
        }
        GrModifierList modifierList = packageDefinition.getAnnotationList();
        GroovyAnnotator.checkAnnotationList(this.myHolder, modifierList, GroovyBundle.message("package.definition.cannot.have.modifiers", new Object[0]));
    }

    @Override
    public void visitSuperExpression(GrSuperReferenceExpression superExpression) {
        GroovyAnnotator.checkThisOrSuperReferenceExpression(superExpression, this.myHolder);
    }

    @Override
    public void visitThisExpression(GrThisReferenceExpression thisExpression) {
        GroovyAnnotator.checkThisOrSuperReferenceExpression(thisExpression, this.myHolder);
    }

    @Override
    public void visitLiteralExpression(GrLiteral literal) {
        String text = literal.getText();
        if (text.startsWith("'''")) {
            if (text.length() < 6 || !text.endsWith("'''")) {
                this.myHolder.createErrorAnnotation((PsiElement)literal, GroovyBundle.message("string.end.expected", new Object[0]));
            }
        } else if (text.startsWith("'") && (text.length() < 2 || !text.endsWith("'"))) {
            this.myHolder.createErrorAnnotation((PsiElement)literal, GroovyBundle.message("string.end.expected", new Object[0]));
        }
    }

    @Override
    public void visitForInClause(GrForInClause forInClause) {
        PsiElement[] modifiers;
        GrVariable[] declaredVariables = forInClause.getDeclaredVariables();
        if (declaredVariables.length < 1) {
            return;
        }
        GrVariable variable = declaredVariables[0];
        GrModifierList modifierList = (GrModifierList)variable.getModifierList();
        if (modifierList == null) {
            return;
        }
        for (PsiElement modifier : modifiers = modifierList.getModifiers()) {
            String modifierText;
            if (modifier instanceof PsiAnnotation || "final".equals(modifierText = modifier.getText()) || "def".equals(modifierText)) continue;
            this.myHolder.createErrorAnnotation(modifier, GroovyBundle.message("not.allowed.modifier.in.forin", modifierText));
        }
    }

    @Override
    public void visitFile(GroovyFileBase file) {
        if (!file.isScript()) {
            return;
        }
        ArrayList<GrMethod> methods = new ArrayList<GrMethod>();
        for (GrTopLevelDefintion topLevelDefinition : file.getTopLevelDefinitions()) {
            if (!(topLevelDefinition instanceof GrMethod)) continue;
            methods.add((GrMethod)topLevelDefinition);
        }
        GroovyAnnotator.checkDuplicateMethod(methods.toArray(new GrMethod[methods.size()]), this.myHolder);
    }

    @Override
    public void visitImportStatement(GrImportStatement importStatement) {
        GroovyAnnotator.checkAnnotationList(this.myHolder, importStatement.getAnnotationList(), GroovyBundle.message("import.statement.cannot.have.modifiers", new Object[0]));
    }

    private static void checkFlowInterruptStatement(GrFlowInterruptingStatement statement, AnnotationHolder holder) {
        GrStatement targetStatement;
        GrLabeledStatement resolved;
        PsiElement label = statement.getLabelIdentifier();
        if (label != null && (resolved = statement.resolveLabel()) == null) {
            holder.createErrorAnnotation(label, GroovyBundle.message("undefined.label", statement.getLabelName()));
        }
        if ((targetStatement = statement.findTargetStatement()) == null) {
            if (statement instanceof GrContinueStatement && label == null) {
                holder.createErrorAnnotation((PsiElement)statement, GroovyBundle.message("continue.outside.loop", new Object[0]));
            } else if (statement instanceof GrBreakStatement && label == null) {
                holder.createErrorAnnotation((PsiElement)statement, GroovyBundle.message("break.outside.loop.or.switch", new Object[0]));
            }
        }
        if (statement instanceof GrBreakStatement && label != null && GroovyAnnotator.findFirstLoop(statement) == null) {
            holder.createErrorAnnotation((PsiElement)statement, GroovyBundle.message("break.outside.loop", new Object[0]));
        }
    }

    @Nullable
    private static GrLoopStatement findFirstLoop(GrFlowInterruptingStatement statement) {
        return (GrLoopStatement)PsiTreeUtil.getParentOfType((PsiElement)statement, GrLoopStatement.class, (boolean)true, (Class[])new Class[]{GrClosableBlock.class, GrMember.class, GroovyFile.class});
    }

    private static void checkThisOrSuperReferenceExpression(GrExpression expression, AnnotationHolder holder) {
        GrReferenceExpression qualifier;
        GrReferenceExpression grReferenceExpression = qualifier = expression instanceof GrThisReferenceExpression ? ((GrThisReferenceExpression)expression).getQualifier() : ((GrSuperReferenceExpression)expression).getQualifier();
        if (qualifier == null) {
            GrMethod method = (GrMethod)PsiTreeUtil.getParentOfType((PsiElement)expression, GrMethod.class);
            if (method != null && method.hasModifierProperty("static")) {
                holder.createErrorAnnotation((PsiElement)expression, GroovyBundle.message("cannot.reference.nonstatic", expression.getText()));
            }
        } else {
            PsiElement resolved = qualifier.resolve();
            if (resolved instanceof PsiClass) {
                if (PsiTreeUtil.isAncestor((PsiElement)resolved, (PsiElement)expression, (boolean)true)) {
                    if (!PsiUtil.hasEnclosingInstanceInScope((PsiClass)resolved, expression, true)) {
                        holder.createErrorAnnotation((PsiElement)expression, GroovyBundle.message("cannot.reference.nonstatic", expression.getText()));
                    }
                } else {
                    holder.createErrorAnnotation((PsiElement)expression, GroovyBundle.message("is.not.enclosing.class", ((PsiClass)resolved).getQualifiedName()));
                }
            } else {
                holder.createErrorAnnotation((PsiElement)qualifier, GroovyBundle.message("unknown.class", qualifier.getText()));
            }
        }
    }

    private static void checkStaticDeclarationsInInnerClass(GrMember classMember, AnnotationHolder holder) {
        PsiElement modifier;
        PsiClass containingClass = classMember.getContainingClass();
        if (containingClass == null) {
            return;
        }
        if (com.intellij.psi.util.PsiUtil.isInnerClass((PsiClass)containingClass) && classMember.hasModifierProperty("static") && (modifier = GroovyAnnotator.findModifierStatic(classMember)) != null) {
            Annotation annotation = holder.createErrorAnnotation(modifier, GroovyBundle.message("cannot.have.static.declarations", new Object[0]));
            annotation.registerFix((IntentionAction)new GrModifierFix(classMember, classMember.getModifierList(), "static", true, false));
        }
    }

    @Nullable
    private static PsiElement findModifierStatic(GrMember grMember) {
        GrModifierList list = grMember.getModifierList();
        if (list == null) {
            return null;
        }
        for (PsiElement modifier : list.getModifiers()) {
            if (!"static".equals(modifier.getText())) continue;
            return modifier;
        }
        return null;
    }

    private static void checkGrDocReferenceElement(AnnotationHolder holder, PsiElement element) {
        ASTNode node = element.getNode();
        if (node != null && TokenSets.BUILT_IN_TYPE.contains(node.getElementType())) {
            Annotation annotation = holder.createInfoAnnotation(element, null);
            annotation.setTextAttributes(DefaultHighlighter.KEYWORD);
        }
    }

    private static void checkAnnotationList(AnnotationHolder holder, @Nullable GrModifierList modifierList, String message) {
        PsiElement[] modifiers;
        if (modifierList == null) {
            return;
        }
        for (PsiElement modifier : modifiers = modifierList.getModifiers()) {
            if (modifier instanceof PsiAnnotation) continue;
            holder.createErrorAnnotation(modifier, message);
        }
    }

    private static void checkImplementedMethodsOfClass(AnnotationHolder holder, GrTypeDefinition typeDefinition) {
        if (typeDefinition.hasModifierProperty("abstract")) {
            return;
        }
        if (typeDefinition.isEnum() || typeDefinition.isAnnotationType()) {
            return;
        }
        if (typeDefinition instanceof GrTypeParameter) {
            return;
        }
        Collection<CandidateInfo> collection = GroovyOverrideImplementUtil.getMethodsToImplement(typeDefinition);
        if (collection.isEmpty()) {
            return;
        }
        PsiElement element = collection.iterator().next().getElement();
        assert (element instanceof PsiNamedElement);
        String notImplementedMethodName = ((PsiNamedElement)element).getName();
        int startOffset = typeDefinition.getTextOffset();
        int endOffset = typeDefinition.getNameIdentifierGroovy().getTextRange().getEndOffset();
        Annotation annotation = holder.createErrorAnnotation(new TextRange(startOffset, endOffset), GroovyBundle.message("method.is.not.implemented", notImplementedMethodName));
        GroovyAnnotator.registerImplementsMethodsFix(typeDefinition, annotation);
    }

    private static void registerImplementsMethodsFix(GrTypeDefinition typeDefinition, Annotation annotation) {
        annotation.registerFix((IntentionAction)new ImplementMethodsQuickFix(typeDefinition));
    }

    private static void checkInnerMethod(AnnotationHolder holder, GrMethod grMethod) {
        PsiElement parent = grMethod.getParent();
        if (parent instanceof GrOpenBlock || parent instanceof GrClosableBlock) {
            holder.createErrorAnnotation(grMethod.getNameIdentifierGroovy(), GroovyBundle.message("Inner.methods.are.not.supported", new Object[0]));
        }
    }

    protected static void processDuplicates(Map<GrNamedArgument, List<GrNamedArgument>> map, AnnotationHolder holder) {
        for (List<GrNamedArgument> args : map.values()) {
            for (int i = 1; i < args.size(); ++i) {
                GrNamedArgument namedArgument = args.get(i);
                holder.createWarningAnnotation((PsiElement)namedArgument, GroovyBundle.message("duplicate.element.in.the.map", new Object[0]));
            }
        }
    }

    private static void registerAbstractMethodFix(Annotation annotation, GrMethod method, boolean makeClassAbstract) {
        if (method.getBlock() == null) {
            annotation.registerFix((IntentionAction)new AddMethodBodyFix((PsiMethod)method));
        } else {
            annotation.registerFix((IntentionAction)new GrModifierFix(method, method.getModifierList(), "abstract", false, false));
        }
        if (makeClassAbstract) {
            PsiClass containingClass = method.getContainingClass();
            LOG.assertTrue(containingClass != null);
            GrModifierList list = (GrModifierList)containingClass.getModifierList();
            LOG.assertTrue(list != null);
            annotation.registerFix((IntentionAction)new GrModifierFix((PsiMember)containingClass, list, "abstract", false, true));
        }
    }

    private static void checkMethodDefinitionModifiers(AnnotationHolder holder, GrMethod method) {
        GrModifierList modifiersList = method.getModifierList();
        GroovyAnnotator.checkAccessModifiers(holder, modifiersList, method);
        GroovyAnnotator.checkDuplicateModifiers(holder, modifiersList, method);
        boolean isMethodAbstract = modifiersList.hasExplicitModifier("abstract");
        boolean isMethodStatic = modifiersList.hasExplicitModifier("static");
        if (method.getParent() instanceof GroovyFileBase) {
            Annotation annotation;
            if (isMethodAbstract) {
                annotation = holder.createErrorAnnotation((PsiElement)modifiersList, GroovyBundle.message("script.cannot.have.modifier.abstract", new Object[0]));
                GroovyAnnotator.registerAbstractMethodFix(annotation, method, false);
            }
            if (modifiersList.hasExplicitModifier("native")) {
                annotation = holder.createErrorAnnotation((PsiElement)modifiersList, GroovyBundle.message("script.cannot.have.modifier.native", new Object[0]));
                annotation.registerFix((IntentionAction)new GrModifierFix(method, modifiersList, "native", false, false));
            }
        } else if (method.getParent() != null && method.getParent().getParent() instanceof GrTypeDefinition) {
            GrTypeDefinition containingTypeDef = (GrTypeDefinition)method.getParent().getParent();
            if (containingTypeDef.isInterface()) {
                Annotation annotation;
                if (isMethodStatic) {
                    annotation = holder.createErrorAnnotation((PsiElement)modifiersList, GroovyBundle.message("interface.must.have.no.static.method", new Object[0]));
                    annotation.registerFix((IntentionAction)new GrModifierFix(method, modifiersList, "static", true, false));
                }
                if (modifiersList.hasExplicitModifier("private")) {
                    annotation = holder.createErrorAnnotation((PsiElement)modifiersList, GroovyBundle.message("interface.must.have.no.private.method", new Object[0]));
                    annotation.registerFix((IntentionAction)new GrModifierFix(method, modifiersList, "private", true, false));
                }
            } else if (!containingTypeDef.isEnum() && !containingTypeDef.isAnnotationType()) {
                if (containingTypeDef.isAnonymous()) {
                    Annotation annotation;
                    if (isMethodStatic) {
                        annotation = holder.createErrorAnnotation((PsiElement)modifiersList, GroovyBundle.message("static.declaration.in.inner.class", new Object[0]));
                        annotation.registerFix((IntentionAction)new GrModifierFix(method, modifiersList, "static", false, false));
                    }
                    if (method.isConstructor()) {
                        holder.createErrorAnnotation(method.getNameIdentifierGroovy(), GroovyBundle.message("constructors.are.not.allowed.in.anonymous.class", new Object[0]));
                    }
                    if (isMethodAbstract) {
                        annotation = holder.createErrorAnnotation((PsiElement)modifiersList, GroovyBundle.message("anonymous.class.cannot.have.abstract.method", new Object[0]));
                        GroovyAnnotator.registerAbstractMethodFix(annotation, method, false);
                    }
                } else {
                    Annotation annotation;
                    GrModifierList typeDefModifiersList = containingTypeDef.getModifierList();
                    LOG.assertTrue(typeDefModifiersList != null, (Object)"modifiers list must be not null");
                    if (!typeDefModifiersList.hasExplicitModifier("abstract") && isMethodAbstract) {
                        annotation = holder.createErrorAnnotation((PsiElement)modifiersList, GroovyBundle.message("only.abstract.class.can.have.abstract.method", new Object[0]));
                        GroovyAnnotator.registerAbstractMethodFix(annotation, method, true);
                    }
                    if (!isMethodAbstract && method.getBlock() == null) {
                        annotation = holder.createErrorAnnotation(method.getNameIdentifierGroovy(), GroovyBundle.message("not.abstract.method.should.have.body", new Object[0]));
                        annotation.registerFix((IntentionAction)new AddMethodBodyFix((PsiMethod)method));
                    }
                    if (isMethodStatic) {
                        GroovyAnnotator.checkStaticDeclarationsInInnerClass(method, holder);
                    }
                }
            }
        }
    }

    private static void checkTypeDefinitionModifiers(AnnotationHolder holder, GrTypeDefinition typeDefinition) {
        Annotation annotation;
        PsiClassType[] extendsListTypes;
        GrModifierList modifiersList = typeDefinition.getModifierList();
        if (modifiersList == null) {
            return;
        }
        GroovyAnnotator.checkAccessModifiers(holder, modifiersList, typeDefinition);
        GroovyAnnotator.checkDuplicateModifiers(holder, modifiersList, typeDefinition);
        for (PsiClassType classType : extendsListTypes = typeDefinition.getExtendsListTypes()) {
            PsiModifierList modifierList;
            PsiClass psiClass = classType.resolve();
            if (psiClass == null || (modifierList = psiClass.getModifierList()) == null || !modifierList.hasExplicitModifier("final")) continue;
            Annotation annotation2 = holder.createErrorAnnotation(typeDefinition.getNameIdentifierGroovy(), GroovyBundle.message("final.class.cannot.be.extended", new Object[0]));
            annotation2.registerFix((IntentionAction)new GrModifierFix(typeDefinition, modifiersList, "final", false, false));
        }
        if (modifiersList.hasExplicitModifier("abstract") && modifiersList.hasExplicitModifier("final")) {
            annotation = holder.createErrorAnnotation((PsiElement)modifiersList, GroovyBundle.message("illegal.combination.of.modifiers.abstract.and.final", new Object[0]));
            annotation.registerFix((IntentionAction)new GrModifierFix(typeDefinition, modifiersList, "final", false, false));
            annotation.registerFix((IntentionAction)new GrModifierFix(typeDefinition, modifiersList, "abstract", false, false));
        }
        if (modifiersList.hasExplicitModifier("transient")) {
            annotation = holder.createErrorAnnotation((PsiElement)modifiersList, GroovyBundle.message("modifier.transient.not.allowed.here", new Object[0]));
            annotation.registerFix((IntentionAction)new GrModifierFix(typeDefinition, modifiersList, "transient", false, false));
        }
        if (modifiersList.hasExplicitModifier("volatile")) {
            annotation = holder.createErrorAnnotation((PsiElement)modifiersList, GroovyBundle.message("modifier.volatile.not.allowed.here", new Object[0]));
            annotation.registerFix((IntentionAction)new GrModifierFix(typeDefinition, modifiersList, "volatile", false, false));
        }
        if (typeDefinition.isInterface() && modifiersList.hasExplicitModifier("final")) {
            annotation = holder.createErrorAnnotation((PsiElement)modifiersList, GroovyBundle.message("intarface.cannot.have.modifier.final", new Object[0]));
            annotation.registerFix((IntentionAction)new GrModifierFix(typeDefinition, modifiersList, "final", false, false));
        }
        GroovyAnnotator.checkStaticDeclarationsInInnerClass(typeDefinition, holder);
    }

    private static void checkDuplicateModifiers(AnnotationHolder holder, @NotNull GrModifierList list, PsiMember member) {
        if (list == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/jetbrains/plugins/groovy/annotator/GroovyAnnotator.checkDuplicateModifiers must not be null");
        }
        PsiElement[] modifiers = list.getModifiers();
        THashSet set = new THashSet(modifiers.length);
        for (PsiElement modifier : modifiers) {
            String name = modifier.getText();
            if (set.contains(name)) {
                Annotation annotation = holder.createErrorAnnotation((PsiElement)list, GroovyBundle.message("duplicate.modifier", name));
                annotation.registerFix((IntentionAction)new GrModifierFix(member, list, name, false, false));
                continue;
            }
            set.add(name);
        }
    }

    private static void checkAccessModifiers(AnnotationHolder holder, @NotNull PsiModifierList modifierList, PsiMember member) {
        if (modifierList == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/jetbrains/plugins/groovy/annotator/GroovyAnnotator.checkAccessModifiers must not be null");
        }
        boolean hasPrivate = modifierList.hasExplicitModifier("private");
        boolean hasPublic = modifierList.hasExplicitModifier("public");
        boolean hasProtected = modifierList.hasExplicitModifier("protected");
        if (hasPrivate && hasPublic || hasPrivate && hasProtected || hasPublic && hasProtected) {
            Annotation annotation = holder.createErrorAnnotation((PsiElement)modifierList, GroovyBundle.message("illegal.combination.of.modifiers", new Object[0]));
            if (hasPrivate) {
                annotation.registerFix((IntentionAction)new GrModifierFix(member, modifierList, "private", false, false));
            }
            if (hasProtected) {
                annotation.registerFix((IntentionAction)new GrModifierFix(member, modifierList, "protected", false, false));
            }
            if (hasPublic) {
                annotation.registerFix((IntentionAction)new GrModifierFix(member, modifierList, "public", false, false));
            }
        }
    }

    private static void checkDuplicateMethod(GrMethod[] methods, AnnotationHolder holder) {
        Map map = DuplicatesUtil.factorDuplicates((PsiElement[])methods, (TObjectHashingStrategy)new TObjectHashingStrategy<GrMethod>(){

            public int computeHashCode(GrMethod method) {
                return method.getSignature(PsiSubstitutor.EMPTY).hashCode();
            }

            public boolean equals(GrMethod method1, GrMethod method2) {
                return method1.getSignature(PsiSubstitutor.EMPTY).equals(method2.getSignature(PsiSubstitutor.EMPTY));
            }
        });
        GroovyAnnotator.processMethodDuplicates(map, holder);
    }

    protected static void processMethodDuplicates(Map<GrMethod, List<GrMethod>> map, AnnotationHolder holder) {
        HashSet<GrMethod> duplicateMethodsWarning = new HashSet<GrMethod>();
        HashSet<GrMethod> duplicateMethodsErrors = new HashSet<GrMethod>();
        DuplicatesUtil.collectMethodDuplicates(map, duplicateMethodsWarning, duplicateMethodsErrors);
        for (GrMethod duplicateMethod : duplicateMethodsErrors) {
            holder.createErrorAnnotation(duplicateMethod.getNameIdentifierGroovy(), GroovyBundle.message("repetitive.method.name.signature.and.return.type", new Object[0]));
        }
        for (GrMethod duplicateMethod : duplicateMethodsWarning) {
            holder.createWarningAnnotation(duplicateMethod.getNameIdentifierGroovy(), GroovyBundle.message("repetitive.method.name.signature", new Object[0]));
        }
    }

    private static void checkTypeDefinition(AnnotationHolder holder, GrTypeDefinition typeDefinition) {
        GroovyConfigUtils configUtils = GroovyConfigUtils.getInstance();
        if (typeDefinition.isAnnotationType()) {
            Annotation annotation = holder.createInfoAnnotation(typeDefinition.getNameIdentifierGroovy(), null);
            annotation.setTextAttributes(DefaultHighlighter.ANNOTATION);
        } else if (typeDefinition.isAnonymous()) {
            if (!configUtils.isAtLeastGroovy1_7(typeDefinition)) {
                holder.createErrorAnnotation(typeDefinition.getNameIdentifierGroovy(), GroovyBundle.message("anonymous.classes.are.not.supported", configUtils.getSDKVersion(typeDefinition)));
            }
        } else if (typeDefinition.getContainingClass() != null && !(typeDefinition instanceof GrEnumTypeDefinition) && !configUtils.isAtLeastGroovy1_7(typeDefinition)) {
            holder.createErrorAnnotation(typeDefinition.getNameIdentifierGroovy(), GroovyBundle.message("inner.classes.are.not.supported", configUtils.getSDKVersion(typeDefinition)));
        }
        GrImplementsClause implementsClause = typeDefinition.getImplementsClause();
        GrExtendsClause extendsClause = typeDefinition.getExtendsClause();
        if (implementsClause != null) {
            GroovyAnnotator.checkForImplementingClass(holder, extendsClause, implementsClause, (GrTypeDefinition)implementsClause.getParent());
        }
        if (extendsClause != null) {
            GroovyAnnotator.checkForExtendingInterface(holder, extendsClause, implementsClause, (GrTypeDefinition)extendsClause.getParent());
        }
        GroovyAnnotator.checkDuplicateClass(typeDefinition, holder);
    }

    private static void checkDuplicateClass(GrTypeDefinition typeDefinition, AnnotationHolder holder) {
        PsiClass[] classes;
        String qName;
        String containingClassName;
        PsiClass containingClass = typeDefinition.getContainingClass();
        if (containingClass != null && (containingClassName = containingClass.getName()) != null && containingClassName.equals(typeDefinition.getName())) {
            holder.createErrorAnnotation(typeDefinition.getNameIdentifierGroovy(), GroovyBundle.message("duplicate.inner.class", typeDefinition.getName()));
        }
        if ((qName = typeDefinition.getQualifiedName()) != null && (classes = JavaPsiFacade.getInstance((Project)typeDefinition.getProject()).findClasses(qName, typeDefinition.getResolveScope())).length > 1) {
            String packageName = GroovyAnnotator.getPackageName(typeDefinition);
            if (!GroovyAnnotator.isScriptGeneratedClass(classes)) {
                holder.createErrorAnnotation(typeDefinition.getNameIdentifierGroovy(), GroovyBundle.message("duplicate.class", typeDefinition.getName(), packageName));
            } else {
                holder.createErrorAnnotation(typeDefinition.getNameIdentifierGroovy(), GroovyBundle.message("script.generated.with.same.name", qName));
            }
        }
    }

    private static String getPackageName(GrTypeDefinition typeDefinition) {
        String name;
        PsiFile file = typeDefinition.getContainingFile();
        String packageName = "<default package>";
        if (file instanceof GroovyFile && (name = ((GroovyFile)file).getPackageName()).length() > 0) {
            packageName = name;
        }
        return packageName;
    }

    private static boolean isScriptGeneratedClass(PsiClass[] allClasses) {
        return allClasses.length == 2 && (allClasses[0] instanceof GroovyScriptClass || allClasses[1] instanceof GroovyScriptClass);
    }

    private static void checkForExtendingInterface(AnnotationHolder holder, GrExtendsClause extendsClause, GrImplementsClause implementsClause, GrTypeDefinition myClass) {
        for (GrCodeReferenceElement ref : extendsClause.getReferenceElements()) {
            PsiElement clazz = ref.resolve();
            if (clazz == null || !myClass.isInterface() || !(clazz instanceof PsiClass) || ((PsiClass)clazz).isInterface()) continue;
            Annotation annotation = holder.createErrorAnnotation((PsiElement)ref, GroovyBundle.message("class.is.not.expected.here", new Object[0]));
            annotation.registerFix((IntentionAction)new ChangeExtendsImplementsQuickFix(extendsClause, implementsClause));
        }
    }

    private static void checkForImplementingClass(AnnotationHolder holder, GrExtendsClause extendsClause, GrImplementsClause implementsClause, GrTypeDefinition myClass) {
        if (myClass.isInterface()) {
            Annotation annotation = holder.createErrorAnnotation((PsiElement)implementsClause, GroovyBundle.message("interface.cannot.contain.implements.clause", new Object[0]));
            annotation.registerFix((IntentionAction)new ChangeExtendsImplementsQuickFix(extendsClause, implementsClause));
            return;
        }
        for (GrCodeReferenceElement ref : implementsClause.getReferenceElements()) {
            PsiElement clazz = ref.resolve();
            if (clazz == null || ((PsiClass)clazz).isInterface()) continue;
            Annotation annotation = holder.createErrorAnnotation((PsiElement)ref, GroovyBundle.message("interface.expected.here", new Object[0]));
            annotation.registerFix((IntentionAction)new ChangeExtendsImplementsQuickFix(extendsClause, implementsClause));
        }
    }

    private static void checkGrDocMemberReference(GrDocMemberReference reference, AnnotationHolder holder) {
        PsiElement resolved = reference.resolve();
        if (resolved == null) {
            Annotation annotation = holder.createErrorAnnotation((PsiElement)reference, GroovyBundle.message("cannot.resolve", reference.getReferenceName()));
            annotation.setHighlightType(ProblemHighlightType.LIKE_UNKNOWN_SYMBOL);
        }
    }

    private static void registerReferenceFixes(GrReferenceExpression refExpr, Annotation annotation) {
        GrVariableDeclarationOwner owner;
        PsiClass targetClass = QuickfixUtil.findTargetClass(refExpr);
        if (targetClass == null) {
            return;
        }
        GroovyAnnotator.addDynamicAnnotation(annotation, refExpr);
        if (targetClass instanceof GrMemberOwner) {
            if (!(targetClass instanceof GroovyScriptClass)) {
                annotation.registerFix((IntentionAction)new CreateFieldFromUsageFix(refExpr, (GrMemberOwner)targetClass));
            }
            if (refExpr.getParent() instanceof GrCall && refExpr.getParent() instanceof GrExpression) {
                annotation.registerFix((IntentionAction)new CreateMethodFromUsageFix(refExpr, (GrMemberOwner)targetClass));
            }
        }
        if (!(refExpr.isQualified() || (owner = (GrVariableDeclarationOwner)PsiTreeUtil.getParentOfType((PsiElement)refExpr, GrVariableDeclarationOwner.class)) instanceof GroovyFileBase && !((GroovyFileBase)owner).isScript())) {
            annotation.registerFix((IntentionAction)new CreateLocalVariableFromUsageFix(refExpr, owner));
        }
    }

    private static void addDynamicAnnotation(Annotation annotation, GrReferenceExpression referenceExpression) {
        PsiFile containingFile = referenceExpression.getContainingFile();
        if (containingFile != null) {
            VirtualFile file = containingFile.getVirtualFile();
            if (file == null) {
                return;
            }
        } else {
            return;
        }
        if (QuickfixUtil.isCall(referenceExpression)) {
            annotation.registerFix((IntentionAction)new DynamicMethodFix(referenceExpression), referenceExpression.getTextRange());
        } else {
            annotation.registerFix((IntentionAction)new DynamicPropertyFix(referenceExpression), referenceExpression.getTextRange());
        }
    }

    private static void highlightMemberResolved(AnnotationHolder holder, GrReferenceExpression refExpr, PsiMember member) {
        boolean isStatic = member.hasModifierProperty("static");
        Annotation annotation = holder.createInfoAnnotation(refExpr.getReferenceNameElement(), null);
        if (member instanceof PsiField || member instanceof GrAccessorMethod) {
            annotation.setTextAttributes(isStatic ? DefaultHighlighter.STATIC_FIELD : DefaultHighlighter.INSTANCE_FIELD);
            return;
        }
        if (member instanceof PsiMethod) {
            annotation.setTextAttributes(!isStatic ? DefaultHighlighter.METHOD_CALL : DefaultHighlighter.STATIC_METHOD_ACCESS);
        }
    }

    private static void registerUsedImport(GrReferenceElement referenceElement, GroovyResolveResult resolveResult) {
        PsiFile file;
        GroovyPsiElement context = resolveResult.getCurrentFileResolveContext();
        if (context instanceof GrImportStatement && (file = referenceElement.getContainingFile()) instanceof GroovyFile) {
            GroovyImportsTracker importsTracker = GroovyImportsTracker.getInstance(referenceElement.getProject());
            importsTracker.registerImportUsed((GrImportStatement)context);
        }
    }

    private static void checkMethodApplicability(GroovyResolveResult methodResolveResult, GroovyPsiElement place, AnnotationHolder holder) {
        PsiType type;
        GrExpression qualifierExpression;
        PsiElement element = methodResolveResult.getElement();
        if (!(element instanceof PsiMethod)) {
            return;
        }
        PsiMethod method = (PsiMethod)element;
        PsiType[] argumentTypes = PsiUtil.getArgumentTypes(place, true);
        if ("call".equals(method.getName()) && place instanceof GrReferenceExpression && (qualifierExpression = ((GrReferenceExpression)place).getQualifierExpression()) != null && (type = qualifierExpression.getType()) instanceof GrClosureType && !PsiUtil.isApplicable(argumentTypes, (GrClosureType)type, place)) {
            GroovyAnnotator.highlightInapplicableMethodUsage(methodResolveResult, place, holder, method, argumentTypes);
            return;
        }
        if (argumentTypes != null && !PsiUtil.isApplicable(argumentTypes, method, methodResolveResult.getSubstitutor(), methodResolveResult.getCurrentFileResolveContext() instanceof GrMethodCallExpression, place)) {
            GroovyAnnotator.highlightInapplicableMethodUsage(methodResolveResult, place, holder, method, argumentTypes);
        }
    }

    private static void highlightInapplicableMethodUsage(GroovyResolveResult methodResolveResult, PsiElement place, AnnotationHolder holder, PsiMethod method, PsiType[] argumentTypes) {
        String message;
        GroovyPsiElement elementToHighlight = PsiUtil.getArgumentsElement(place);
        if (elementToHighlight == null) {
            elementToHighlight = place;
        }
        String typesString = GroovyAnnotator.buildArgTypesList(argumentTypes);
        PsiClass containingClass = method.getContainingClass();
        if (containingClass != null) {
            PsiClassType containingType = JavaPsiFacade.getInstance((Project)method.getProject()).getElementFactory().createType(containingClass, methodResolveResult.getSubstitutor());
            message = GroovyBundle.message("cannot.apply.method1", method.getName(), containingType.getInternalCanonicalText(), typesString);
        } else {
            message = GroovyBundle.message("cannot.apply.method.or.closure", method.getName(), typesString);
        }
        holder.createWarningAnnotation((PsiElement)elementToHighlight, message);
    }

    public static boolean isDeclarationAssignment(GrReferenceExpression refExpr) {
        if (GroovyAnnotator.isAssignmentLhs(refExpr)) {
            return GroovyAnnotator.isExpandoQualified(refExpr);
        }
        return false;
    }

    private static boolean isAssignmentLhs(GrReferenceExpression refExpr) {
        return refExpr.getParent() instanceof GrAssignmentExpression && refExpr.equals(((GrAssignmentExpression)refExpr.getParent()).getLValue());
    }

    private static boolean isExpandoQualified(GrReferenceExpression refExpr) {
        PsiClassType classType;
        PsiClass psiClass;
        GrExpression qualifier = refExpr.getQualifierExpression();
        if (qualifier == null) {
            PsiClass clazz = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)refExpr, PsiClass.class);
            return clazz == null;
        }
        PsiType type = qualifier.getType();
        return type instanceof PsiClassType && (psiClass = (classType = (PsiClassType)type).resolve()) instanceof GroovyScriptClass;
    }

    private static void checkSingleResolvedElement(AnnotationHolder holder, GrReferenceElement refElement, GroovyResolveResult resolveResult, boolean highlightError) {
        PsiElement resolved = resolveResult.getElement();
        if (resolved == null) {
            Annotation annotation;
            PsiElement toHighlight;
            String message = GroovyBundle.message("cannot.resolve", refElement.getReferenceName());
            PsiElement nameElement = refElement.getReferenceNameElement();
            Object object = toHighlight = nameElement != null ? nameElement : refElement;
            if (highlightError) {
                annotation = holder.createErrorAnnotation(toHighlight, message);
                annotation.setHighlightType(ProblemHighlightType.LIKE_UNKNOWN_SYMBOL);
            } else {
                annotation = holder.createInfoAnnotation(toHighlight, message);
            }
            if (refElement.getQualifier() == null) {
                GroovyAnnotator.registerCreateClassByTypeFix(refElement, annotation);
                GroovyAnnotator.registerAddImportFixes(refElement, annotation);
            }
        } else if (!resolveResult.isAccessible()) {
            String message = GroovyBundle.message("cannot.access", refElement.getReferenceName());
            holder.createWarningAnnotation(refElement.getReferenceNameElement(), message);
        }
    }

    private static void checkDefaultMapConstructor(AnnotationHolder holder, GrArgumentList argList, PsiElement element) {
        if (argList != null) {
            GrNamedArgument[] args;
            for (GrNamedArgument arg : args = argList.getNamedArguments()) {
                GrArgumentLabel label = arg.getLabel();
                if (label == null) continue;
                if (label.getName() == null) {
                    PsiElement nameElement = label.getNameElement();
                    if (nameElement instanceof GrExpression) {
                        PsiType stringType = JavaPsiFacade.getElementFactory((Project)arg.getProject()).createTypeFromText("java.lang.String", (PsiElement)arg);
                        if (TypesUtil.isAssignable(stringType, ((GrExpression)nameElement).getType(), arg)) continue;
                        holder.createWarningAnnotation(nameElement, GroovyBundle.message("property.name.expected", new Object[0]));
                        continue;
                    }
                    holder.createWarningAnnotation(nameElement, GroovyBundle.message("property.name.expected", new Object[0]));
                    continue;
                }
                PsiElement resolved = label.resolve();
                if (resolved != null) continue;
                Annotation annotation = holder.createWarningAnnotation((PsiElement)label, GroovyBundle.message("no.such.property", label.getName()));
                if (element instanceof PsiMember && !(element instanceof PsiClass)) {
                    element = ((PsiMember)element).getContainingClass();
                }
                if (element instanceof GrMemberOwner) {
                    annotation.registerFix((IntentionAction)new CreateFieldFromConstructorLabelFix((GrMemberOwner)element, label.getNamedArgument()));
                }
                if (!(element instanceof PsiClass)) continue;
                annotation.registerFix((IntentionAction)new DynamicPropertyFix(label, (PsiClass)element));
            }
        }
    }

    private static void checkClosureApplicability(GroovyResolveResult resolveResult, PsiType type, GroovyPsiElement place, AnnotationHolder holder) {
        PsiElement element = resolveResult.getElement();
        if (!(element instanceof GrVariable)) {
            return;
        }
        if (!(type instanceof GrClosureType)) {
            return;
        }
        GrVariable variable = (GrVariable)element;
        PsiType[] argumentTypes = PsiUtil.getArgumentTypes(place, true);
        if (argumentTypes == null) {
            return;
        }
        if (PsiUtil.isApplicable(argumentTypes, (GrClosureType)type, place)) {
            return;
        }
        String typesString = GroovyAnnotator.buildArgTypesList(argumentTypes);
        String message = GroovyBundle.message("cannot.apply.method.or.closure", variable.getName(), typesString);
        GroovyPsiElement elementToHighlight = PsiUtil.getArgumentsElement(place);
        if (elementToHighlight == null) {
            elementToHighlight = place;
        }
        holder.createWarningAnnotation((PsiElement)elementToHighlight, message);
    }

    private static void registerAddImportFixes(GrReferenceElement refElement, Annotation annotation) {
        String referenceName = refElement.getReferenceName();
        if (StringUtil.isEmpty((String)referenceName) || Character.isLowerCase(referenceName.charAt(0))) {
            return;
        }
        annotation.registerFix((IntentionAction)new GroovyAddImportAction(refElement));
    }

    private static void registerCreateClassByTypeFix(GrReferenceElement refElement, Annotation annotation) {
        GrPackageDefinition packageDefinition = (GrPackageDefinition)PsiTreeUtil.getParentOfType((PsiElement)refElement, GrPackageDefinition.class);
        if (packageDefinition == null && refElement.getQualifier() == null) {
            PsiElement parent = refElement.getParent();
            if (parent instanceof GrNewExpression) {
                annotation.registerFix(CreateClassFix.createClassFromNewAction((GrNewExpression)parent));
            } else {
                annotation.registerFix(CreateClassFix.createClassFixAction(refElement));
            }
        }
    }

    private static void highlightMember(AnnotationHolder holder, GrMember member) {
        if (member instanceof GrField) {
            GrField field = (GrField)member;
            PsiElement identifier = field.getNameIdentifierGroovy();
            boolean isStatic = field.hasModifierProperty("static");
            holder.createInfoAnnotation(identifier, null).setTextAttributes(isStatic ? DefaultHighlighter.STATIC_FIELD : DefaultHighlighter.INSTANCE_FIELD);
        }
    }

    private static void highlightAnnotation(AnnotationHolder holder, PsiElement refElement, GroovyResolveResult result) {
        PsiElement element = result.getElement();
        PsiElement parent = refElement.getParent();
        if (element instanceof PsiClass && ((PsiClass)element).isAnnotationType() && !(parent instanceof GrImportStatement)) {
            Annotation annotation = holder.createInfoAnnotation(parent, null);
            annotation.setTextAttributes(DefaultHighlighter.ANNOTATION);
            GroovyPsiElement context = result.getCurrentFileResolveContext();
            if (context instanceof GrImportStatement) {
                annotation = holder.createInfoAnnotation((PsiElement)((GrImportStatement)context).getImportReference(), null);
                annotation.setTextAttributes(DefaultHighlighter.ANNOTATION);
            }
        }
    }

    private static String buildArgTypesList(PsiType[] argTypes) {
        StringBuilder builder = new StringBuilder();
        builder.append("(");
        for (int i = 0; i < argTypes.length; ++i) {
            PsiType argType;
            if (i > 0) {
                builder.append(", ");
            }
            builder.append((argType = argTypes[i]) != null ? argType.getInternalCanonicalText() : "?");
        }
        builder.append(")");
        return builder.toString();
    }

    private static class DuplicateVariablesProcessor
    extends PropertyResolverProcessor {
        private boolean myBorderPassed = false;
        private final boolean myHasVisibilityModifier;

        public DuplicateVariablesProcessor(GrVariable variable) {
            super(variable.getName(), variable);
            this.myHasVisibilityModifier = DuplicateVariablesProcessor.hasExplicitVisibilityModifiers(variable);
        }

        private static boolean hasExplicitVisibilityModifiers(GrVariable variable) {
            PsiModifierList modifierList = variable.getModifierList();
            if (modifierList instanceof GrModifierList) {
                return ((GrModifierList)modifierList).hasExplicitVisibilityModifiers();
            }
            if (modifierList == null) {
                return false;
            }
            return modifierList.hasExplicitModifier("public") || modifierList.hasExplicitModifier("protected") || modifierList.hasExplicitModifier("private");
        }

        @Override
        public boolean execute(PsiElement element, ResolveState state) {
            if (this.myBorderPassed) {
                return false;
            }
            if (element instanceof GrVariable && DuplicateVariablesProcessor.hasExplicitVisibilityModifiers((GrVariable)element) != this.myHasVisibilityModifier) {
                return true;
            }
            return super.execute(element, state);
        }

        @Override
        public void handleEvent(PsiScopeProcessor.Event event, Object associated) {
            if (event == ResolveUtil.DECLARATION_SCOPE_PASSED) {
                this.myBorderPassed = true;
            }
            super.handleEvent(event, associated);
        }
    }
}

