/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInsight;

import com.intellij.codeInsight.TargetElementEvaluator;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrNewExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrCallExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;

public class GroovyTargetElementEvaluator
implements TargetElementEvaluator {
    public boolean includeSelfInGotoImplementation(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/codeInsight/GroovyTargetElementEvaluator.includeSelfInGotoImplementation must not be null");
        }
        return false;
    }

    public PsiElement getElementByReference(PsiReference ref, int flags) {
        PsiElement sourceElement = ref.getElement();
        if (sourceElement == null) {
            return null;
        }
        GrCallExpression newExpr = null;
        if (sourceElement instanceof GrCodeReferenceElement) {
            if (sourceElement.getParent() instanceof GrNewExpression) {
                newExpr = (GrNewExpression)sourceElement.getParent();
            } else if (sourceElement.getParent().getParent() instanceof GrNewExpression) {
                newExpr = (GrNewExpression)sourceElement.getParent().getParent();
            }
        }
        if (newExpr != null) {
            PsiMethod constructor = newExpr.resolveConstructor();
            GrArgumentList argumentList = newExpr.getArgumentList();
            if (constructor != null && argumentList != null && argumentList.getNamedArguments().length != 0 && argumentList.getExpressionArguments().length == 0 && constructor.getParameterList().getParametersCount() == 0) {
                return constructor.getContainingClass();
            }
            return constructor;
        }
        return null;
    }
}

