/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.formatter;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.ChildAttributes;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.Wrap;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.tree.ILazyParseableElementType;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.formatter.GroovyBlockGenerator;
import org.jetbrains.plugins.groovy.formatter.processors.GroovySpacingProcessor;
import org.jetbrains.plugins.groovy.formatter.processors.GroovySpacingProcessorBasic;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocComment;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocTag;
import org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFileBase;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.GrListOrMap;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrBinaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCommandArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameterList;

public class GroovyBlock
implements Block,
GroovyElementTypes {
    protected final ASTNode myNode;
    protected final Alignment myAlignment;
    protected final Indent myIndent;
    protected final Wrap myWrap;
    protected final CodeStyleSettings mySettings;
    protected List<Block> mySubBlocks;

    public GroovyBlock(@NotNull ASTNode node, @Nullable Alignment alignment, @NotNull Indent indent, @Nullable Wrap wrap, CodeStyleSettings settings) {
        if (node == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/formatter/GroovyBlock.<init> must not be null");
        }
        if (indent == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of org/jetbrains/plugins/groovy/formatter/GroovyBlock.<init> must not be null");
        }
        this.mySubBlocks = null;
        this.myNode = node;
        this.myAlignment = alignment;
        this.myIndent = indent;
        this.myWrap = wrap;
        this.mySettings = settings;
    }

    @NotNull
    public ASTNode getNode() {
        ASTNode aSTNode = this.myNode;
        if (aSTNode == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/formatter/GroovyBlock.getNode must not return null");
        }
        return aSTNode;
    }

    @NotNull
    public CodeStyleSettings getSettings() {
        CodeStyleSettings codeStyleSettings = this.mySettings;
        if (codeStyleSettings == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/formatter/GroovyBlock.getSettings must not return null");
        }
        return codeStyleSettings;
    }

    @NotNull
    public TextRange getTextRange() {
        TextRange textRange = this.myNode.getTextRange();
        if (textRange == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/formatter/GroovyBlock.getTextRange must not return null");
        }
        return textRange;
    }

    @NotNull
    public List<Block> getSubBlocks() {
        if (this.mySubBlocks == null) {
            this.mySubBlocks = GroovyBlockGenerator.generateSubBlocks(this.myNode, this.myAlignment, this.myWrap, this.mySettings, this);
        }
        List<Block> list = this.mySubBlocks;
        if (list == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/formatter/GroovyBlock.getSubBlocks must not return null");
        }
        return list;
    }

    @Nullable
    public Wrap getWrap() {
        return this.myWrap;
    }

    @Nullable
    public Indent getIndent() {
        return this.myIndent;
    }

    @Nullable
    public Alignment getAlignment() {
        return this.myAlignment;
    }

    @Nullable
    public Spacing getSpacing(Block child1, Block child2) {
        if (child1 instanceof GroovyBlock && child2 instanceof GroovyBlock) {
            Spacing spacing = GroovySpacingProcessor.getSpacing((GroovyBlock)child1, (GroovyBlock)child2, this.mySettings);
            return spacing != null ? spacing : GroovySpacingProcessorBasic.getSpacing((GroovyBlock)child1, (GroovyBlock)child2, this.mySettings);
        }
        return null;
    }

    @NotNull
    public ChildAttributes getChildAttributes(int newChildIndex) {
        ChildAttributes childAttributes = this.getAttributesByParent();
        if (childAttributes == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/formatter/GroovyBlock.getChildAttributes must not return null");
        }
        return childAttributes;
    }

    private ChildAttributes getAttributesByParent() {
        ASTNode astNode = this.getNode();
        PsiElement psiParent = astNode.getPsi();
        if (psiParent instanceof GroovyFileBase) {
            return new ChildAttributes(Indent.getNoneIndent(), null);
        }
        if (BLOCK_SET.contains(astNode.getElementType()) || ((Object)((Object)SWITCH_STATEMENT)).equals(astNode.getElementType())) {
            return new ChildAttributes(Indent.getNormalIndent(), null);
        }
        if (((Object)((Object)CASE_SECTION)).equals(astNode.getElementType())) {
            return new ChildAttributes(Indent.getNormalIndent(), null);
        }
        if (psiParent instanceof GrBinaryExpression || psiParent instanceof GrCommandArgumentList || psiParent instanceof GrArgumentList) {
            return new ChildAttributes(Indent.getContinuationWithoutFirstIndent(), null);
        }
        if (psiParent instanceof GrParameterList) {
            return new ChildAttributes(this.getIndent(), this.getAlignment());
        }
        if (psiParent instanceof GrListOrMap) {
            return new ChildAttributes(Indent.getContinuationIndent(), null);
        }
        if (psiParent instanceof GrDocComment || psiParent instanceof GrDocTag) {
            return new ChildAttributes(Indent.getSpaceIndent((int)1), null);
        }
        return new ChildAttributes(Indent.getNoneIndent(), null);
    }

    public boolean isIncomplete() {
        return this.isIncomplete(this.myNode);
    }

    public boolean isIncomplete(@NotNull ASTNode node) {
        ASTNode lastChild;
        if (node == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/formatter/GroovyBlock.isIncomplete must not be null");
        }
        if (node.getElementType() instanceof ILazyParseableElementType) {
            return false;
        }
        for (lastChild = node.getLastChildNode(); lastChild != null && !(lastChild.getElementType() instanceof ILazyParseableElementType) && (lastChild.getPsi() instanceof PsiWhiteSpace || lastChild.getPsi() instanceof PsiComment); lastChild = lastChild.getTreePrev()) {
        }
        return lastChild != null && (lastChild.getPsi() instanceof PsiErrorElement || this.isIncomplete(lastChild));
    }

    public boolean isLeaf() {
        return this.myNode.getFirstChildNode() == null;
    }
}

