/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.highlighter;

import com.intellij.lexer.Lexer;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.fileTypes.SyntaxHighlighterBase;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.highlighter.DefaultHighlighter;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyLexer;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;

public class GroovySyntaxHighlighter
extends SyntaxHighlighterBase
implements GroovyTokenTypes {
    private static final Map<IElementType, TextAttributesKey> ATTRIBUTES = new HashMap<IElementType, TextAttributesKey>();
    static final TokenSet tBLOCK_COMMENTS = TokenSet.create((IElementType[])new IElementType[]{mML_COMMENT});
    static final TokenSet tNUMBERS = TokenSet.create((IElementType[])new IElementType[]{mNUM_INT, mNUM_BIG_DECIMAL, mNUM_BIG_INT, mNUM_DOUBLE, mNUM_FLOAT, mNUM_LONG});
    static final TokenSet tLINE_COMMENTS = TokenSet.create((IElementType[])new IElementType[]{mSL_COMMENT, mSH_COMMENT});
    static final TokenSet tBAD_CHARACTERS = TokenSet.create((IElementType[])new IElementType[]{mWRONG});
    static final TokenSet tWRONG_REGEX = TokenSet.create((IElementType[])new IElementType[]{mWRONG_REGEX_LITERAL});
    static final TokenSet tGSTRINGS = TokenSet.create((IElementType[])new IElementType[]{mGSTRING_BEGIN, mGSTRING_CONTENT, mGSTRING_END, mGSTRING_LITERAL});
    static final TokenSet tSTRINGS = TokenSet.create((IElementType[])new IElementType[]{mSTRING_LITERAL});
    static final TokenSet tREGEXP = TokenSet.create((IElementType[])new IElementType[]{mREGEX_LITERAL, mREGEX_BEGIN, mREGEX_CONTENT, mREGEX_END});
    static final TokenSet tBRACES = TokenSet.create((IElementType[])new IElementType[]{mLPAREN, mRPAREN, mLBRACK, mRBRACK, mLCURLY, mRCURLY});
    public static final TokenSet tOPERATORS = TokenSet.create((IElementType[])new IElementType[]{mQUESTION, mCOMPARE_TO, mEQUAL, mBNOT, mNOT_EQUAL, mPLUS, mPLUS_ASSIGN, mINC, mMINUS, mMINUS_ASSIGN, mDEC, mSTAR, mSTAR_ASSIGN, mMOD, mMOD_ASSIGN, mSR_ASSIGN, mBSR_ASSIGN, mGE, mGT, mSL_ASSIGN, mLE, mLT, mBXOR, mBXOR_ASSIGN, mBOR, mBOR_ASSIGN, mLOR, mBAND, mBAND_ASSIGN, mLAND, mDOLLAR, mRANGE_INCLUSIVE, mRANGE_EXCLUSIVE, mTRIPLE_DOT, mSPREAD_DOT, mOPTIONAL_DOT, mMEMBER_POINTER, mREGEX_FIND, mREGEX_MATCH, mSTAR_STAR, mSTAR_STAR_ASSIGN, mCLOSABLE_BLOCK_OP, mAT});
    public static final TokenSet tKEYWORDS = TokenSet.create((IElementType[])new IElementType[]{kPACKAGE, kIMPORT, kSTATIC, kSTRICTFP, kDEF, kCLASS, kINTERFACE, kENUM, kEXTENDS, kSUPER, kVOID, kBOOLEAN, kBYTE, kCHAR, kSHORT, kINT, kFLOAT, kLONG, kDOUBLE, kAS, kPRIVATE, kPUBLIC, kPROTECTED, kABSTRACT, kTRANSIENT, kNATIVE, kSYNCHRONIZED, kVOLATILE, kDEFAULT, kTHROWS, kIMPLEMENTS, kTHIS, kIF, kELSE, kWHILE, kSWITCH, kFOR, kIN, kRETURN, kBREAK, kCONTINUE, kTHROW, kASSERT, kCASE, kTRY, kFINALLY, kFINAL, kCATCH, kINSTANCEOF, kNEW, kTRUE, kFALSE, kNULL});

    @NotNull
    public Lexer getHighlightingLexer() {
        GroovyLexer groovyLexer = new GroovyLexer();
        if (groovyLexer == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/highlighter/GroovySyntaxHighlighter.getHighlightingLexer must not return null");
        }
        return groovyLexer;
    }

    @NotNull
    public TextAttributesKey[] getTokenHighlights(IElementType tokenType) {
        TextAttributesKey[] textAttributesKeyArray = GroovySyntaxHighlighter.pack((TextAttributesKey)ATTRIBUTES.get(tokenType));
        if (textAttributesKeyArray == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/highlighter/GroovySyntaxHighlighter.getTokenHighlights must not return null");
        }
        return textAttributesKeyArray;
    }

    static {
        GroovySyntaxHighlighter.fillMap(ATTRIBUTES, (TokenSet)tLINE_COMMENTS, (TextAttributesKey)DefaultHighlighter.LINE_COMMENT);
        GroovySyntaxHighlighter.fillMap(ATTRIBUTES, (TokenSet)tBLOCK_COMMENTS, (TextAttributesKey)DefaultHighlighter.BLOCK_COMMENT);
        GroovySyntaxHighlighter.fillMap(ATTRIBUTES, (TokenSet)tBAD_CHARACTERS, (TextAttributesKey)DefaultHighlighter.BAD_CHARACTER);
        GroovySyntaxHighlighter.fillMap(ATTRIBUTES, (TokenSet)tKEYWORDS, (TextAttributesKey)DefaultHighlighter.KEYWORD);
        GroovySyntaxHighlighter.fillMap(ATTRIBUTES, (TokenSet)tNUMBERS, (TextAttributesKey)DefaultHighlighter.NUMBER);
        GroovySyntaxHighlighter.fillMap(ATTRIBUTES, (TokenSet)tGSTRINGS, (TextAttributesKey)DefaultHighlighter.GSTRING);
        GroovySyntaxHighlighter.fillMap(ATTRIBUTES, (TokenSet)tSTRINGS, (TextAttributesKey)DefaultHighlighter.STRING);
        GroovySyntaxHighlighter.fillMap(ATTRIBUTES, (TokenSet)tREGEXP, (TextAttributesKey)DefaultHighlighter.REGEXP);
        GroovySyntaxHighlighter.fillMap(ATTRIBUTES, (TokenSet)tWRONG_REGEX, (TextAttributesKey)DefaultHighlighter.REGEXP);
        GroovySyntaxHighlighter.fillMap(ATTRIBUTES, (TokenSet)tBRACES, (TextAttributesKey)DefaultHighlighter.BRACES);
    }
}

