/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.intentions.conversions;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.InheritanceUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.intentions.base.ErrorUtil;
import org.jetbrains.plugins.groovy.intentions.base.PsiElementPredicate;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;

class IndexingMethodConversionPredicate
implements PsiElementPredicate {
    IndexingMethodConversionPredicate() {
    }

    @Override
    public boolean satisfiedBy(PsiElement element) {
        if (!(element instanceof GrMethodCallExpression)) {
            return false;
        }
        if (ErrorUtil.containsError(element)) {
            return false;
        }
        GrMethodCallExpression callExpression = (GrMethodCallExpression)element;
        GrArgumentList argList = callExpression.getArgumentList();
        if (argList == null) {
            return false;
        }
        GrExpression[] arguments = argList.getExpressionArguments();
        GrExpression invokedExpression = callExpression.getInvokedExpression();
        if (!(invokedExpression instanceof GrReferenceExpression)) {
            return false;
        }
        GrReferenceExpression referenceExpression = (GrReferenceExpression)invokedExpression;
        GrExpression qualifier = referenceExpression.getQualifierExpression();
        if (qualifier == null) {
            return false;
        }
        IElementType referenceType = referenceExpression.getDotTokenType();
        if (!GroovyTokenTypes.mDOT.equals(referenceType)) {
            return false;
        }
        String methodName = referenceExpression.getName();
        if ("getAt".equals(methodName)) {
            return arguments.length == 1;
        }
        if ("get".equals(methodName)) {
            PsiType qualifierType = qualifier.getType();
            if (!IndexingMethodConversionPredicate.isMap(qualifierType)) {
                return false;
            }
            return arguments.length == 1;
        }
        if ("setAt".equals(methodName)) {
            return arguments.length == 2;
        }
        if ("put".equals(methodName)) {
            PsiType qualifierType = qualifier.getType();
            if (!IndexingMethodConversionPredicate.isMap(qualifierType)) {
                return false;
            }
            return arguments.length == 2;
        }
        return false;
    }

    private static boolean isMap(PsiType type) {
        if (type == null) {
            return false;
        }
        if (!(type instanceof PsiClassType)) {
            return false;
        }
        PsiClass referentClass = ((PsiClassType)type).resolve();
        return IndexingMethodConversionPredicate.isSubclass(referentClass, "java.util.Map");
    }

    public static boolean isSubclass(@Nullable PsiClass aClass, @NonNls String ancestorName) {
        if (aClass == null) {
            return false;
        }
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)aClass.getProject());
        Project project = facade.getProject();
        GlobalSearchScope scope = GlobalSearchScope.allScope((Project)project);
        PsiClass ancestorClass = facade.findClass(ancestorName, scope);
        return InheritanceUtil.isCorrectDescendant((PsiClass)aClass, (PsiClass)ancestorClass, (boolean)true);
    }
}

