/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.parser;

import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.codeStyle.ReferenceAdjuster;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public class GroovyReferenceAdjuster
extends ReferenceAdjuster {
    public static final ReferenceAdjuster INSTANCE = new GroovyReferenceAdjuster(true, false);

    public GroovyReferenceAdjuster(boolean useFqInJavadoc, boolean useFqInCode) {
        super(useFqInJavadoc, useFqInCode);
    }

    public void shortenReferences(PsiElement element, int startInElement, int endInElement) {
        ArrayList<GrCodeReferenceElement> refs = new ArrayList<GrCodeReferenceElement>();
        GroovyReferenceAdjuster.collectReferences(element, 0, startInElement, endInElement, refs);
        for (GrCodeReferenceElement referenceElement : refs) {
            PsiUtil.shortenReference(referenceElement);
        }
    }

    private static int collectReferences(PsiElement element, int currOffset, int startInElement, int endInElement, List<GrCodeReferenceElement> result) {
        PsiElement first;
        if (element instanceof GrCodeReferenceElement && startInElement <= currOffset && currOffset <= endInElement) {
            result.add((GrCodeReferenceElement)element);
        }
        if ((first = element.getFirstChild()) != null) {
            for (PsiElement run = first; run != null && (currOffset = GroovyReferenceAdjuster.collectReferences(run, currOffset, startInElement, endInElement, result)) <= endInElement; run = run.getNextSibling()) {
            }
            return currOffset;
        }
        return currOffset += element.getTextLength();
    }
}

