/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl;

import com.intellij.extapi.psi.StubBasedPsiElementBase;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.impl.CheckUtil;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.tree.ChangeUtil;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.IncorrectOperationException;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.lexer.TokenSets;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;

public class GroovyBaseElementImpl<T extends StubElement>
extends StubBasedPsiElementBase<T>
implements GroovyPsiElement {
    protected GroovyBaseElementImpl(T stub, IStubElementType nodeType) {
        super(stub, nodeType);
    }

    public GroovyBaseElementImpl(ASTNode node) {
        super(node);
    }

    public void removeElements(PsiElement[] elements) throws IncorrectOperationException {
        ASTNode parentNode = this.getNode();
        for (PsiElement element : elements) {
            if (!element.isValid()) continue;
            ASTNode node = element.getNode();
            if (node == null || node.getTreeParent() != parentNode) {
                throw new IncorrectOperationException();
            }
            parentNode.removeChild(node);
        }
    }

    public void removeStatement() throws IncorrectOperationException {
        if (this.getParent() == null || this.getParent().getNode() == null) {
            throw new IncorrectOperationException();
        }
        ASTNode parentNode = this.getParent().getNode();
        ASTNode prevNode = this.getNode().getTreePrev();
        parentNode.removeChild(this.getNode());
        if (prevNode != null && TokenSets.SEPARATORS.contains(prevNode.getElementType())) {
            parentNode.removeChild(prevNode);
        }
    }

    public PsiElement getParent() {
        return this.getParentByStub();
    }

    public <T extends GrStatement> T replaceWithStatement(@NotNull T newStmt) {
        if (newStmt == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/psi/impl/GroovyBaseElementImpl.replaceWithStatement must not be null");
        }
        PsiElement parent = this.getParent();
        if (parent == null) {
            throw new PsiInvalidElementAccessException((PsiElement)this);
        }
        ASTNode parentNode = parent.getNode();
        ASTNode newNode = newStmt.getNode();
        parentNode.replaceChild(this.getNode(), newNode);
        return (T)((GrStatement)newNode.getPsi());
    }

    public <T extends GroovyPsiElement> Iterable<T> childrenOfType(final TokenSet tokSet) {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return new Iterator<T>(){
                    PsiElement first;
                    ASTNode n;
                    {
                        this.first = GroovyBaseElementImpl.this.getFirstChild();
                        this.n = this.first == null ? null : this.findChild(this.first.getNode());
                    }

                    private ASTNode findChild(ASTNode child) {
                        if (child == null) {
                            return null;
                        }
                        if (tokSet.contains(child.getElementType())) {
                            return child;
                        }
                        return this.findChild(child.getTreeNext());
                    }

                    @Override
                    public boolean hasNext() {
                        return this.n != null;
                    }

                    @Override
                    public T next() {
                        if (this.n == null) {
                            return null;
                        }
                        ASTNode res = this.n;
                        this.n = this.findChild(this.n.getTreeNext());
                        return (GroovyPsiElement)res.getPsi();
                    }

                    @Override
                    public void remove() {
                    }
                };
            }
        };
    }

    @Override
    public void accept(GroovyElementVisitor visitor) {
        visitor.visitElement(this);
    }

    @Override
    public void acceptChildren(GroovyElementVisitor visitor) {
        for (PsiElement child = this.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!(child instanceof GroovyPsiElement)) continue;
            ((GroovyPsiElement)child).accept(visitor);
        }
    }

    public PsiElement replace(@NotNull PsiElement newElement) throws IncorrectOperationException {
        if (newElement == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/psi/impl/GroovyBaseElementImpl.replace must not be null");
        }
        CompositeElement treeElement = this.calcTreeElement();
        assert (treeElement.getTreeParent() != null);
        CheckUtil.checkWritable((PsiElement)this);
        TreeElement elementCopy = ChangeUtil.copyToElement((PsiElement)newElement);
        treeElement.getTreeParent().replaceChildInternal((ASTNode)treeElement, elementCopy);
        elementCopy = ChangeUtil.decodeInformation((TreeElement)elementCopy);
        return SourceTreeToPsiMap.treeElementToPsi((ASTNode)elementCopy);
    }

    protected CompositeElement calcTreeElement() {
        return (CompositeElement)this.getNode();
    }
}

