/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyFileType;
import org.jetbrains.plugins.groovy.annotator.intentions.QuickfixUtil;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocComment;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocMemberReference;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocTag;
import org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.GrReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFileBase;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.GrLabel;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotation;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrBlockStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrLabeledStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrTopLevelDefintion;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrWhileStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrCodeBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrApplicationStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrParenthesizedExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrTypeCastExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrClassDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrEnumTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinitionBody;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrEnumConstant;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.GrTopStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.imports.GrImportStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.packaging.GrPackageDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrClassTypeElement;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeElement;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyFileImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.typedef.members.GrConstructorImpl;
import org.jetbrains.plugins.groovy.refactoring.GroovyNamesUtil;
import org.jetbrains.plugins.groovy.refactoring.GroovyRefactoringUtil;

public class GroovyPsiElementFactoryImpl
extends GroovyPsiElementFactory {
    Project myProject;
    private static final String DUMMY = "dummy.";

    public GroovyPsiElementFactoryImpl(Project project) {
        this.myProject = project;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public PsiElement createReferenceNameFromText(String refName) {
        PsiElement psiElement;
        PsiFile file = this.createGroovyFile("a." + refName);
        GrTopStatement statement = ((GroovyFileBase)file).getTopStatements()[0];
        if (!(statement instanceof GrReferenceExpression)) {
            psiElement = null;
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl.createReferenceNameFromText must not return null");
        } else {
            PsiElement element = ((GrReferenceExpression)statement).getReferenceNameElement();
            if (element == null) {
                throw new IncorrectOperationException("Incorrect reference name: " + refName);
            }
            psiElement = element;
            if (psiElement == null) throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl.createReferenceNameFromText must not return null");
            return psiElement;
        }
    }

    @Override
    public PsiElement createDocMemberReferenceNameFromText(String idText) {
        PsiFile file = this.createGroovyFile("/** @see A#" + idText + " */");
        PsiElement element = file.getFirstChild();
        assert (element instanceof GrDocComment);
        GrDocTag tag = (GrDocTag)PsiTreeUtil.getChildOfType((PsiElement)element, GrDocTag.class);
        assert (tag != null) : "Doc tag points to null";
        GrDocMemberReference reference = (GrDocMemberReference)PsiTreeUtil.getChildOfType((PsiElement)tag, GrDocMemberReference.class);
        assert (reference != null) : "DocMemberReference ponts to null";
        return reference.getReferenceNameElement();
    }

    @Override
    public GrCodeReferenceElement createReferenceElementFromText(String refName) {
        PsiFile file = this.createGroovyFile("(" + refName + " " + ")foo");
        GrTypeElement typeElement = ((GrTypeCastExpression)((GroovyFileBase)file).getTopStatements()[0]).getCastTypeElement();
        return ((GrClassTypeElement)typeElement).getReferenceElement();
    }

    @Override
    public GrReferenceExpression createReferenceExpressionFromText(String idText) {
        PsiFile file = this.createGroovyFile(idText);
        return (GrReferenceExpression)((GroovyFileBase)file).getTopStatements()[0];
    }

    @Override
    public GrExpression createExpressionFromText(String text) {
        GroovyFileImpl file = (GroovyFileImpl)this.createGroovyFile(text);
        assert (file.getTopStatements()[0] instanceof GrExpression);
        return (GrExpression)file.getTopStatements()[0];
    }

    @Override
    public GrVariableDeclaration createVariableDeclaration(String[] modifiers, GrExpression initializer, PsiType type, String ... identifiers) {
        PsiFile file;
        GrTopStatement[] topStatements;
        StringBuffer text = this.writeModifiers(modifiers);
        if (type != null) {
            int idx;
            String typeText = this.getTypeText(type = TypesUtil.unboxPrimitiveTypeWrapper(type));
            int lastDot = typeText.lastIndexOf(46);
            int n = idx = 0 < lastDot && lastDot < typeText.length() - 1 ? lastDot + 1 : 0;
            if (typeText.length() == 0) {
                text.append("def ");
            } else {
                char c = typeText.charAt(idx);
                if (!Character.isLetter(c) || Character.isLowerCase(c) && !GroovyNamesUtil.isKeyword(typeText)) {
                    text.append("def ");
                } else {
                    text.append(typeText).append(" ");
                }
            }
        } else {
            text.append("def ");
        }
        for (int i = 0; i < identifiers.length; ++i) {
            if (i > 0) {
                text.append(", ");
            }
            String identifier = identifiers[i];
            text.append(identifier);
        }
        if (initializer != null) {
            GrExpression expr = initializer instanceof GrApplicationStatement ? this.createMethodCallByAppCall((GrApplicationStatement)((Object)initializer)) : initializer;
            text.append(" = ").append(expr.getText());
        }
        if ((topStatements = ((GroovyFileBase)(file = this.createGroovyFile(text.toString()))).getTopStatements()).length == 0 || !(topStatements[0] instanceof GrVariableDeclaration)) {
            throw new RuntimeException("Invalid arguments, text = " + text.toString());
        }
        return (GrVariableDeclaration)topStatements[0];
    }

    @Override
    public GrEnumConstant createEnumConstantFromText(String text) {
        GroovyFile file = (GroovyFile)this.createGroovyFile("enum E{" + text + "}");
        GrEnumTypeDefinition enumClass = (GrEnumTypeDefinition)file.getClasses()[0];
        return enumClass.getEnumConstants()[0];
    }

    @Override
    public GrVariableDeclaration createFieldDeclaration(String[] modifiers, String identifier, GrExpression initializer, PsiType type) {
        String varDeclaration = this.createVariableDeclaration(modifiers, initializer, type, identifier).getText();
        GroovyFileBase file = (GroovyFileBase)this.createGroovyFile("class A { " + varDeclaration + "}");
        GrTypeDefinitionBody body = file.getTypeDefinitions()[0].getBody();
        return (GrVariableDeclaration)body.getMemberDeclarations()[0];
    }

    @Override
    public GrVariableDeclaration createFieldDeclarationFromText(String text) {
        GroovyFile file = (GroovyFile)this.createGroovyFile("class X{\n" + text + "\n}");
        PsiClass psiClass = file.getClasses()[0];
        return (GrVariableDeclaration)psiClass.getFields()[0].getParent();
    }

    private StringBuffer writeModifiers(String[] modifiers) {
        StringBuffer text = new StringBuffer();
        if (modifiers != null && modifiers.length != 0) {
            for (String modifier : modifiers) {
                text.append(modifier);
                text.append(" ");
            }
        }
        return text;
    }

    private String getTypeText(PsiType type) {
        if (!(type instanceof PsiArrayType)) {
            String canonical = type.getCanonicalText();
            return canonical != null ? canonical : type.getPresentableText();
        }
        return this.getTypeText(((PsiArrayType)type).getComponentType()) + "[]";
    }

    @Override
    @Nullable
    public GrTopStatement createTopElementFromText(String text) {
        PsiFile dummyFile = PsiFileFactory.getInstance((Project)this.myProject).createFileFromText(DUMMY + GroovyFileType.GROOVY_FILE_TYPE.getDefaultExtension(), text);
        PsiElement firstChild = dummyFile.getFirstChild();
        if (!(firstChild instanceof GrTopStatement)) {
            return null;
        }
        return (GrTopStatement)firstChild;
    }

    @Override
    public GrClosableBlock createClosureFromText(String closureText) throws IncorrectOperationException {
        GroovyFileImpl psiFile = this.createDummyFile(closureText);
        ASTNode node = psiFile.getFirstChild().getNode();
        if (node.getElementType() != GroovyElementTypes.CLOSABLE_BLOCK) {
            throw new IncorrectOperationException("Invalid all text");
        }
        return (GrClosableBlock)node.getPsi();
    }

    private GroovyFileImpl createDummyFile(String s, boolean isPhisical) {
        return (GroovyFileImpl)PsiFileFactory.getInstance((Project)this.myProject).createFileFromText("DUMMY__." + GroovyFileType.GROOVY_FILE_TYPE.getDefaultExtension(), (FileType)GroovyFileType.GROOVY_FILE_TYPE, (CharSequence)s, System.currentTimeMillis(), isPhisical);
    }

    private GroovyFileImpl createDummyFile(String s) {
        return this.createDummyFile(s, false);
    }

    @Override
    public GrParameter createParameter(String name, @Nullable String typeText, GroovyPsiElement context) throws IncorrectOperationException {
        String fileText = typeText != null ? "def foo(" + typeText + " " + name + ") {}" : "def foo(" + name + ") {}";
        GroovyFileImpl groovyFile = this.createDummyFile(fileText);
        groovyFile.setContext(context);
        ASTNode node = groovyFile.getFirstChild().getNode();
        if (node.getElementType() != GroovyElementTypes.METHOD_DEFINITION) {
            throw new IncorrectOperationException("Invalid all text");
        }
        return ((GrMethod)node.getPsi()).getParameters()[0];
    }

    @Override
    public GrCodeReferenceElement createTypeOrPackageReference(String qName) {
        GroovyFileImpl file = this.createDummyFile("def " + qName + " i");
        GrVariableDeclaration varDecl = (GrVariableDeclaration)file.getTopStatements()[0];
        GrClassTypeElement typeElement = (GrClassTypeElement)varDecl.getTypeElementGroovy();
        assert (typeElement != null);
        return typeElement.getReferenceElement();
    }

    @Override
    public GrTypeDefinition createTypeDefinition(String text) throws IncorrectOperationException {
        GroovyFileImpl file = this.createDummyFile(text);
        GrTypeDefinition[] classes = file.getTypeDefinitions();
        if (classes.length != 1) {
            throw new IncorrectOperationException("Incorrect type definition text");
        }
        return classes[0];
    }

    @Override
    @NotNull
    public GrTypeElement createTypeElement(String typeText) throws IncorrectOperationException {
        GroovyFileImpl file = this.createDummyFile("def " + typeText + " someVar");
        GrTopStatement[] topStatements = file.getTopStatements();
        if (topStatements == null || topStatements.length == 0) {
            throw new IncorrectOperationException("");
        }
        GrTopStatement statement = topStatements[0];
        if (!(statement instanceof GrVariableDeclaration)) {
            throw new IncorrectOperationException("");
        }
        GrVariableDeclaration decl = (GrVariableDeclaration)statement;
        GrTypeElement element = decl.getTypeElementGroovy();
        if (element == null) {
            throw new IncorrectOperationException("");
        }
        GrTypeElement grTypeElement = element;
        if (grTypeElement == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl.createTypeElement must not return null");
        }
        return grTypeElement;
    }

    @Override
    public GrTypeElement createTypeElement(PsiType type) throws IncorrectOperationException {
        String typeText = this.getTypeText(type);
        if (typeText == null) {
            throw new IncorrectOperationException("Cannot create type element: cannot obtain text for type");
        }
        return this.createTypeElement(typeText);
    }

    @Override
    public GrParenthesizedExpression createParenthesizedExpr(GrExpression newExpr) {
        return (GrParenthesizedExpression)GroovyPsiElementFactoryImpl.getInstance(this.myProject).createExpressionFromText("(" + newExpr.getText() + ")");
    }

    @Override
    public PsiElement createStringLiteral(String text) {
        return ((GrReferenceExpression)this.createDummyFile("a.'" + text + "'").getTopStatements()[0]).getReferenceNameElement();
    }

    @Override
    public PsiElement createModifierFromText(String name) {
        GroovyFileImpl file = this.createDummyFile(name + "\"foo\"() {}");
        return file.getTopLevelDefinitions()[0].getFirstChild().getFirstChild();
    }

    @Override
    public GrCodeBlock createMethodBodyFromText(String text) {
        GroovyFileImpl file = this.createDummyFile("def foo () {" + text + "}");
        GrMethod method = (GrMethod)file.getTopLevelDefinitions()[0];
        return method.getBlock();
    }

    @Override
    public GrVariableDeclaration createSimpleVariableDeclaration(String name, String typeText) {
        String classText = "";
        classText = Character.isLowerCase(typeText.charAt(0)) ? "class A { def " + typeText + " " + name + "}" : "class A { " + typeText + " " + name + "}";
        GroovyFileBase file = (GroovyFileBase)this.createGroovyFile(classText);
        GrTypeDefinitionBody body = file.getTypeDefinitions()[0].getBody();
        return (GrVariableDeclaration)body.getMemberDeclarations()[0];
    }

    @Override
    public GrReferenceElement createPackageReferenceElementFromText(String newPackageName) {
        return ((GrPackageDefinition)this.createDummyFile("package " + newPackageName).getTopStatements()[0]).getPackageReference();
    }

    @Override
    public PsiElement createDotToken(String newDot) {
        return this.createReferenceExpressionFromText("a" + newDot + "b").getDotToken();
    }

    @Override
    public GrConstructorImpl createConstructorFromText(@NotNull String constructorName, @Nullable String[] paramTypes, String[] paramNames, String body) {
        if (constructorName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl.createConstructorFromText must not be null");
        }
        GrMethod method = this.createMethodFromText(null, constructorName, null, paramTypes, paramNames, body);
        GroovyFileImpl file = this.createDummyFile("class " + constructorName + "{" + method.getText() + "}");
        GrTopLevelDefintion defintion = file.getTopLevelDefinitions()[0];
        assert (defintion != null && defintion instanceof GrClassDefinition);
        PsiMethod constructor = ((GrClassDefinition)defintion).getMethods()[0];
        assert (constructor instanceof GrConstructorImpl);
        return (GrConstructorImpl)constructor;
    }

    @Override
    public GrLabel createLabel(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl.createLabel must not be null");
        }
        GroovyFileImpl file = this.createDummyFile(name + ": println()");
        GrTopStatement definition = file.getTopStatements()[0];
        assert (definition instanceof GrLabeledStatement);
        return ((GrLabeledStatement)definition).getLabel();
    }

    @Override
    public GrMethod createMethodFromText(@NotNull String methodText) {
        if (methodText == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl.createMethodFromText must not be null");
        }
        GroovyFileImpl file = this.createDummyFile(methodText);
        GrTopLevelDefintion defintion = file.getTopLevelDefinitions()[0];
        assert (defintion != null && defintion instanceof GrMethod);
        return (GrMethod)defintion;
    }

    @Override
    public GrAnnotation createAnnotationFromText(String annoText) {
        return this.createMethodFromText(annoText + " void foo() {}").getModifierList().getAnnotations()[0];
    }

    public PsiFile createGroovyFile(String idText) {
        return this.createGroovyFile(idText, false, null);
    }

    @Override
    public GroovyFile createGroovyFile(String idText, boolean isPhisical, PsiElement context) {
        GroovyFileImpl file = this.createDummyFile(idText, isPhisical);
        file.setContext(context);
        return file;
    }

    @Override
    public PsiElement createWhiteSpace() {
        PsiFile dummyFile = PsiFileFactory.getInstance((Project)this.myProject).createFileFromText(DUMMY + GroovyFileType.GROOVY_FILE_TYPE.getDefaultExtension(), " ");
        return dummyFile.getFirstChild();
    }

    @Override
    @NotNull
    public PsiElement createLineTerminator(int length) {
        String text;
        String string = text = length <= 1 ? "\n" : "";
        if (length > 1) {
            StringBuffer buffer = new StringBuffer();
            while (length > 0) {
                buffer.append("\n");
                --length;
            }
            text = buffer.toString();
        }
        PsiFile dummyFile = PsiFileFactory.getInstance((Project)this.myProject).createFileFromText(DUMMY + GroovyFileType.GROOVY_FILE_TYPE.getDefaultExtension(), text);
        PsiElement child = dummyFile.getFirstChild();
        assert (child != null);
        PsiElement psiElement = child;
        if (psiElement == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl.createLineTerminator must not return null");
        }
        return psiElement;
    }

    @Override
    public GrArgumentList createExpressionArgumentList(GrExpression ... expressions) {
        StringBuffer text = new StringBuffer();
        text.append("ven (");
        for (GrExpression expression : expressions) {
            text.append(expression.getText()).append(", ");
        }
        if (expressions.length > 0) {
            text.delete(text.length() - 2, text.length());
        }
        text.append(")");
        PsiFile file = this.createGroovyFile(text.toString());
        assert (file.getChildren()[0] != null && file.getChildren()[0] instanceof GrMethodCallExpression);
        return ((GrMethodCallExpression)file.getChildren()[0]).getArgumentList();
    }

    @Override
    public GrNamedArgument createNamedArgument(@NotNull String name, GrExpression expression) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl.createNamedArgument must not be null");
        }
        StringBuffer text = new StringBuffer();
        text.append("foo (").append(name).append(":").append(expression.getText()).append(")");
        PsiFile file = this.createGroovyFile(text.toString());
        assert (file.getChildren()[0] != null);
        GrCall call = (GrCall)file.getChildren()[0];
        return call.getArgumentList().getNamedArguments()[0];
    }

    @Override
    public GrStatement createStatementFromText(String text) {
        PsiFile file = this.createGroovyFile(text);
        assert (((GroovyFileBase)file).getTopStatements()[0] instanceof GrStatement);
        return (GrStatement)((GroovyFileBase)file).getTopStatements()[0];
    }

    @Override
    public GrBlockStatement createBlockStatement(GrStatement ... statements) {
        StringBuffer text = new StringBuffer();
        text.append("while (true) { \n");
        for (GrStatement statement : statements) {
            text.append(statement.getText()).append("\n");
        }
        text.append("}");
        PsiFile file = this.createGroovyFile(text.toString());
        assert (file.getChildren()[0] != null && file.getChildren()[0] instanceof GrWhileStatement);
        return (GrBlockStatement)((GrWhileStatement)file.getChildren()[0]).getBody();
    }

    @Override
    public GrMethodCallExpression createMethodCallByAppCall(GrApplicationStatement callExpr) {
        StringBuffer text = new StringBuffer();
        text.append(callExpr.getFunExpression().getText());
        text.append("(");
        for (GrExpression expr : callExpr.getArguments()) {
            text.append(GroovyRefactoringUtil.getUnparenthesizedExpr(expr).getText()).append(", ");
        }
        if (callExpr.getArguments().length > 0) {
            text.delete(text.length() - 2, text.length());
        }
        text.append(")");
        PsiFile file = this.createGroovyFile(text.toString());
        assert (file.getChildren()[0] != null && file.getChildren()[0] instanceof GrMethodCallExpression);
        return (GrMethodCallExpression)file.getChildren()[0];
    }

    @Override
    public GrImportStatement createImportStatementFromText(String qName, boolean isStatic, boolean isOnDemand, String alias) {
        String text = "import " + (isStatic ? "static " : "") + qName + (isOnDemand ? ".*" : "") + (alias != null && alias.length() > 0 ? " as " + alias : "");
        PsiFile dummyFile = PsiFileFactory.getInstance((Project)this.myProject).createFileFromText(DUMMY + GroovyFileType.GROOVY_FILE_TYPE.getDefaultExtension(), text);
        return (GrImportStatement)dummyFile.getFirstChild();
    }

    @Override
    public GrImportStatement createImportStatementFromText(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl.createImportStatementFromText must not be null");
        }
        PsiFile dummyFile = PsiFileFactory.getInstance((Project)this.myProject).createFileFromText(DUMMY + GroovyFileType.GROOVY_FILE_TYPE.getDefaultExtension(), text);
        return (GrImportStatement)dummyFile.getFirstChild();
    }

    private GrMethod createMethodFromText(String modifier, String name, String type, @Nullable String[] paramTypes, @NotNull String[] paramNames, String body) {
        if (paramNames == null) {
            throw new IllegalArgumentException("Argument 4 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiElementFactoryImpl.createMethodFromText must not be null");
        }
        StringBuilder builder = new StringBuilder();
        if (modifier != null) {
            builder.append(modifier);
            builder.append(" ");
        }
        builder.append("def ");
        if (type != null) {
            builder.append(type);
            builder.append(" ");
        }
        builder.append(name);
        builder.append("(");
        for (int i = 0; i < paramNames.length; ++i) {
            String paramType;
            String string = paramType = paramTypes == null ? "" : paramTypes[i];
            if (i > 0) {
                builder.append(", ");
            }
            builder.append(paramType);
            builder.append(" ");
            builder.append(paramNames[i]);
        }
        builder.append(")");
        if (body != null) {
            builder.append(body);
        } else {
            builder.append("{");
            builder.append("}");
        }
        return this.createMethodFromText(builder.toString());
    }

    @Override
    public GrMethod createMethodFromText(String modifier, String name, @Nullable String type, String[] paramTypes) {
        ArrayList<PsiType> res = new ArrayList<PsiType>();
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(this.myProject);
        for (int i = 0; i < paramTypes.length; ++i) {
            PsiType psiType;
            String paramType = paramTypes[i];
            try {
                psiType = factory.createTypeElement(paramType).getType();
            }
            catch (IncorrectOperationException e) {
                psiType = PsiType.getJavaLangObject((PsiManager)PsiManager.getInstance((Project)this.myProject), (GlobalSearchScope)ProjectScope.getAllScope((Project)this.myProject));
            }
            res.add(psiType);
        }
        return this.createMethodFromText(modifier, name, type, paramTypes, QuickfixUtil.getMethodArgumentsNames(this.myProject, res.toArray(PsiType.EMPTY_ARRAY)), null);
    }

    @Override
    public GrDocComment createDocCommentFromText(String text) {
        StringBuilder builder = new StringBuilder();
        builder.append(text);
        builder.append(" def foo(){}");
        return (GrDocComment)this.createGroovyFile(text + "def foo(){}").getFirstChild();
    }
}

