/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.auxiliary.annotation;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnnotationOwner;
import com.intellij.psi.PsiAnnotationParameterList;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.meta.PsiMetaData;
import com.intellij.util.PairFunction;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotation;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyPsiElementImpl;

public class GrAnnotationImpl
extends GroovyPsiElementImpl
implements GrAnnotation {
    private static final PairFunction<Project, String, PsiAnnotation> ANNOTATION_CREATOR = new PairFunction<Project, String, PsiAnnotation>(){

        public PsiAnnotation fun(Project project, String text) {
            return GroovyPsiElementFactory.getInstance(project).createAnnotationFromText(text);
        }
    };

    public GrAnnotationImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/psi/impl/auxiliary/annotation/GrAnnotationImpl.<init> must not be null");
        }
        super(node);
    }

    @Override
    public void accept(GroovyElementVisitor visitor) {
        visitor.visitAnnotation(this);
    }

    public String toString() {
        return "Annotation";
    }

    @NotNull
    public PsiAnnotationParameterList getParameterList() {
        PsiAnnotationParameterList psiAnnotationParameterList = (PsiAnnotationParameterList)this.findNotNullChildByClass(PsiAnnotationParameterList.class);
        if (psiAnnotationParameterList == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/auxiliary/annotation/GrAnnotationImpl.getParameterList must not return null");
        }
        return psiAnnotationParameterList;
    }

    @Nullable
    @NonNls
    public String getQualifiedName() {
        PsiElement resolved;
        GrCodeReferenceElement nameRef = this.getClassReference();
        if (nameRef != null && (resolved = nameRef.resolve()) instanceof PsiClass) {
            return ((PsiClass)resolved).getQualifiedName();
        }
        return null;
    }

    @Nullable
    public PsiJavaCodeReferenceElement getNameReferenceElement() {
        return null;
    }

    public PsiAnnotationMemberValue findAttributeValue(String attributeName) {
        return PsiImplUtil.findAttributeValue((PsiAnnotation)this, (String)attributeName);
    }

    @Nullable
    public PsiAnnotationMemberValue findDeclaredAttributeValue(@NonNls String attributeName) {
        return PsiImplUtil.findDeclaredAttributeValue((PsiAnnotation)this, (String)attributeName);
    }

    public <T extends PsiAnnotationMemberValue> T setDeclaredAttributeValue(@NonNls String attributeName, T value) {
        return (T)PsiImplUtil.setDeclaredAttributeValue((PsiAnnotation)this, (String)attributeName, value, ANNOTATION_CREATOR);
    }

    @Nullable
    public PsiMetaData getMetaData() {
        return null;
    }

    @Override
    public GrCodeReferenceElement getClassReference() {
        return (GrCodeReferenceElement)this.findChildByClass(GrCodeReferenceElement.class);
    }

    @Override
    @NotNull
    public String getShortName() {
        String string = this.getClassReference().getText();
        if (string == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/auxiliary/annotation/GrAnnotationImpl.getShortName must not return null");
        }
        return string;
    }

    public PsiAnnotationOwner getOwner() {
        return (PsiAnnotationOwner)this.getParent();
    }
}

