/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.lexer.TokenSets;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrBinaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.GrExpressionImpl;

public abstract class GrBinaryExpressionImpl
extends GrExpressionImpl
implements GrBinaryExpression {
    public GrBinaryExpressionImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrBinaryExpressionImpl.<init> must not be null");
        }
        super(node);
    }

    @Override
    @NotNull
    public GrExpression getLeftOperand() {
        GrExpression result = (GrExpression)this.findChildByClass(GrExpression.class);
        assert (result != null);
        GrExpression grExpression = result;
        if (grExpression == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrBinaryExpressionImpl.getLeftOperand must not return null");
        }
        return grExpression;
    }

    @Override
    public GrExpression getRightOperand() {
        GrExpression left = this.getLeftOperand();
        for (PsiElement run = left.getNextSibling(); run != null; run = run.getNextSibling()) {
            if (!(run instanceof GrExpression)) continue;
            return (GrExpression)run;
        }
        return null;
    }

    @Override
    @Nullable
    public IElementType getOperationTokenType() {
        PsiElement child = this.findChildByType(TokenSets.BINARY_OP_SET);
        if (child == null) {
            return null;
        }
        ASTNode node = child.getNode();
        assert (node != null);
        return node.getElementType();
    }

    @Override
    public void accept(GroovyElementVisitor visitor) {
        visitor.visitBinaryExpression(this);
    }
}

