/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFileBase;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrSuperReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrAnonymousClassDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.GrExpressionImpl;

public class GrSuperReferenceExpressionImpl
extends GrExpressionImpl
implements GrSuperReferenceExpression {
    public GrSuperReferenceExpressionImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrSuperReferenceExpressionImpl.<init> must not be null");
        }
        super(node);
    }

    @Override
    public void accept(GroovyElementVisitor visitor) {
        visitor.visitSuperExpression(this);
    }

    public String toString() {
        return "'super' reference expression";
    }

    @Override
    public PsiType getType() {
        GrReferenceExpression qualifier = this.getQualifier();
        if (qualifier == null) {
            GroovyPsiElement context = (GroovyPsiElement)PsiTreeUtil.getParentOfType((PsiElement)this, (Class[])new Class[]{GrTypeDefinition.class, GroovyFile.class});
            if (context instanceof GrTypeDefinition) {
                PsiClass superClass = ((GrTypeDefinition)context).getSuperClass();
                if (superClass != null) {
                    return JavaPsiFacade.getInstance((Project)this.getProject()).getElementFactory().createType(superClass);
                }
            } else if (context instanceof GroovyFileBase) {
                return JavaPsiFacade.getInstance((Project)this.getProject()).getElementFactory().createTypeByFQClassName("groovy.lang.GroovyObject", this.getResolveScope());
            }
        } else {
            PsiElement resolved = qualifier.resolve();
            if (resolved instanceof PsiClass) {
                return this.getSuperType((PsiClass)resolved);
            }
        }
        return null;
    }

    @Override
    @Nullable
    public GrReferenceExpression getQualifier() {
        return (GrReferenceExpression)this.findChildByType(GroovyElementTypes.REFERENCE_EXPRESSION);
    }

    @Nullable
    private PsiType getSuperType(PsiClass aClass) {
        if (aClass.isInterface()) {
            return PsiType.getJavaLangObject((PsiManager)this.getManager(), (GlobalSearchScope)this.getResolveScope());
        }
        if (aClass instanceof GrAnonymousClassDefinition) {
            PsiClassType baseClassType = ((GrAnonymousClassDefinition)aClass).getBaseClassType();
            PsiClass psiClass = baseClassType.resolve();
            if (psiClass != null && !psiClass.isInterface()) {
                return baseClassType;
            }
            return PsiType.getJavaLangObject((PsiManager)this.getManager(), (GlobalSearchScope)this.getResolveScope());
        }
        if ("java.lang.Object".equals(aClass.getQualifiedName())) {
            return null;
        }
        PsiClassType[] superTypes = aClass.getExtendsListTypes();
        if (superTypes.length == 0) {
            return PsiType.getJavaLangObject((PsiManager)this.getManager(), (GlobalSearchScope)this.getResolveScope());
        }
        return superTypes[0];
    }
}

