/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.statements.typedef;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.reference.SoftReference;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrNewExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrAnonymousClassDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrExtendsClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrImplementsClause;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrClassReferenceType;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.typedef.GrTypeDefinitionImpl;
import org.jetbrains.plugins.groovy.lang.psi.stubs.GrTypeDefinitionStub;
import org.jetbrains.plugins.groovy.lang.psi.util.GrClassImplUtil;

public class GrAnonymousClassDefinitionImpl
extends GrTypeDefinitionImpl
implements GrAnonymousClassDefinition {
    private SoftReference<PsiClassType> myCachedBaseType;

    public GrAnonymousClassDefinitionImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/GrAnonymousClassDefinitionImpl.<init> must not be null");
        }
        super(node);
        this.myCachedBaseType = null;
    }

    public GrAnonymousClassDefinitionImpl(GrTypeDefinitionStub stub) {
        super(stub, (IStubElementType)GroovyElementTypes.ANONYMOUS_CLASS_DEFINITION);
        this.myCachedBaseType = null;
    }

    @Override
    @NotNull
    public GrCodeReferenceElement getBaseClassReferenceGroovy() {
        GrCodeReferenceElement grCodeReferenceElement = (GrCodeReferenceElement)this.findChildByClass(GrCodeReferenceElement.class);
        if (grCodeReferenceElement == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/GrAnonymousClassDefinitionImpl.getBaseClassReferenceGroovy must not return null");
        }
        return grCodeReferenceElement;
    }

    @Override
    public boolean hasModifierProperty(@NonNls @NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/GrAnonymousClassDefinitionImpl.hasModifierProperty must not be null");
        }
        return "final".equals(name);
    }

    @Override
    @NotNull
    public GrArgumentList getArgumentListGroovy() {
        GrArgumentList grArgumentList = (GrArgumentList)this.findChildByClass(GrArgumentList.class);
        if (grArgumentList == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/GrAnonymousClassDefinitionImpl.getArgumentListGroovy must not return null");
        }
        return grArgumentList;
    }

    public boolean isInQualifiedNew() {
        GrTypeDefinitionStub stub = (GrTypeDefinitionStub)this.getStub();
        if (stub != null) {
            return stub.isAnonymousInQualifiedNew();
        }
        PsiElement parent = this.getParent();
        return parent instanceof GrNewExpression && ((GrNewExpression)parent).getQualifier() != null;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public PsiJavaCodeReferenceElement getBaseClassReference() {
        PsiJavaCodeReferenceElement psiJavaCodeReferenceElement;
        GrCodeReferenceElement ref = this.getBaseClassReferenceGroovy();
        PsiElement element = ref.resolve();
        Project project = this.getProject();
        if (element instanceof PsiClass) {
            GrClassReferenceType type = new GrClassReferenceType(ref);
            psiJavaCodeReferenceElement = JavaPsiFacade.getElementFactory((Project)project).createReferenceElementByType((PsiClassType)type);
            if (psiJavaCodeReferenceElement == null) throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/GrAnonymousClassDefinitionImpl.getBaseClassReference must not return null");
            return psiJavaCodeReferenceElement;
        }
        String qName = ref.getReferenceName();
        psiJavaCodeReferenceElement = JavaPsiFacade.getElementFactory((Project)project).createReferenceElementByFQClassName(qName, GlobalSearchScope.allScope((Project)project));
        if (psiJavaCodeReferenceElement != null) return psiJavaCodeReferenceElement;
        throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/GrAnonymousClassDefinitionImpl.getBaseClassReference must not return null");
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public PsiClassType getBaseClassType() {
        PsiClassType psiClassType;
        if (this.isInQualifiedNew()) {
            psiClassType = this.createClassType();
            if (psiClassType == null) throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/GrAnonymousClassDefinitionImpl.getBaseClassType must not return null");
            return psiClassType;
        }
        PsiClassType type = null;
        if (this.myCachedBaseType != null) {
            type = (PsiClassType)this.myCachedBaseType.get();
        }
        if (type != null && type.isValid()) {
            psiClassType = type;
            if (psiClassType == null) throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/GrAnonymousClassDefinitionImpl.getBaseClassType must not return null");
            return psiClassType;
        }
        type = this.createClassType();
        this.myCachedBaseType = new SoftReference((Object)type);
        psiClassType = type;
        if (psiClassType != null) return psiClassType;
        throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/GrAnonymousClassDefinitionImpl.getBaseClassType must not return null");
    }

    @Nullable
    public PsiExpressionList getArgumentList() {
        return null;
    }

    @NotNull
    private PsiClassType createClassType() {
        PsiClassType psiClassType = JavaPsiFacade.getInstance((Project)this.getProject()).getElementFactory().createType(this.getBaseClassReference());
        if (psiClassType == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/GrAnonymousClassDefinitionImpl.createClassType must not return null");
        }
        return psiClassType;
    }

    @Nullable
    private PsiClass getBaseClass() {
        PsiElement element = this.getBaseClassReferenceGroovy().resolve();
        if (element instanceof PsiClass) {
            return (PsiClass)element;
        }
        return null;
    }

    @Override
    @NotNull
    public PsiElement getNameIdentifierGroovy() {
        PsiElement psiElement = this.getBaseClassReferenceGroovy().getReferenceNameElement();
        if (psiElement == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/GrAnonymousClassDefinitionImpl.getNameIdentifierGroovy must not return null");
        }
        return psiElement;
    }

    @Override
    public boolean isAnonymous() {
        return true;
    }

    @Override
    public PsiClass getSuperClass() {
        PsiClass psiClass = this.getBaseClass();
        if (psiClass != null && !psiClass.isInterface()) {
            return psiClass;
        }
        return GrClassImplUtil.getBaseClass(this);
    }

    @Override
    @NotNull
    public PsiClassType[] getSuperTypes() {
        PsiClassType[] psiClassTypeArray = new PsiClassType[]{this.getBaseClassType(), this.getGroovyObjectType()};
        if (psiClassTypeArray == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/GrAnonymousClassDefinitionImpl.getSuperTypes must not return null");
        }
        return psiClassTypeArray;
    }

    private PsiClassType getGroovyObjectType() {
        return JavaPsiFacade.getInstance((Project)this.getProject()).getElementFactory().createTypeByFQClassName("groovy.lang.GroovyObject", this.getResolveScope());
    }

    @Override
    public String[] getSuperClassNames() {
        return new String[]{this.getBaseClassReferenceGroovy().getReferenceName()};
    }

    @Override
    public PsiClass getContainingClass() {
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public PsiClassType[] getExtendsListTypes() {
        PsiClassType[] psiClassTypeArray;
        PsiClass baseClass = this.getBaseClass();
        if (baseClass != null && !baseClass.isInterface()) {
            psiClassTypeArray = new PsiClassType[]{this.getBaseClassType()};
            if (psiClassTypeArray == null) throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/GrAnonymousClassDefinitionImpl.getExtendsListTypes must not return null");
            return psiClassTypeArray;
        }
        psiClassTypeArray = super.getExtendsListTypes();
        if (psiClassTypeArray != null) return psiClassTypeArray;
        throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/GrAnonymousClassDefinitionImpl.getExtendsListTypes must not return null");
    }

    @Override
    public GrExtendsClause getExtendsClause() {
        return null;
    }

    @Override
    public GrImplementsClause getImplementsClause() {
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public PsiClassType[] getImplementsListTypes() {
        PsiClassType[] psiClassTypeArray;
        PsiClass baseClass = this.getBaseClass();
        if (baseClass != null && baseClass.isInterface()) {
            psiClassTypeArray = new PsiClassType[]{this.getBaseClassType(), this.getGroovyObjectType()};
            if (psiClassTypeArray == null) throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/GrAnonymousClassDefinitionImpl.getImplementsListTypes must not return null");
            return psiClassTypeArray;
        }
        psiClassTypeArray = new PsiClassType[]{this.getGroovyObjectType()};
        if (psiClassTypeArray != null) return psiClassTypeArray;
        throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/GrAnonymousClassDefinitionImpl.getImplementsListTypes must not return null");
    }

    public String toString() {
        return "Anonymous class";
    }

    @Override
    public void subtreeChanged() {
        super.subtreeChanged();
        this.myCachedBaseType = null;
    }

    protected Object clone() {
        Object o = super.clone();
        ((GrAnonymousClassDefinitionImpl)o).myCachedBaseType = null;
        return o;
    }

    @Override
    public String getQualifiedName() {
        return null;
    }

    @Override
    public String getName() {
        return null;
    }

    @Override
    public PsiIdentifier getNameIdentifier() {
        return null;
    }
}

