/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.resolve.processors;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveState;
import java.util.EnumSet;
import org.jetbrains.plugins.groovy.lang.psi.util.GroovyPropertyUtils;
import org.jetbrains.plugins.groovy.lang.resolve.processors.ClassHint;
import org.jetbrains.plugins.groovy.lang.resolve.processors.ResolverProcessor;

public class AccessorResolverProcessor
extends ResolverProcessor {
    private boolean mySearchForGetter;

    public AccessorResolverProcessor(String name, PsiElement place, boolean searchForGetter) {
        super(name, EnumSet.of(ClassHint.ResolveKind.METHOD), place, PsiType.EMPTY_ARRAY);
        this.mySearchForGetter = searchForGetter;
    }

    @Override
    public boolean execute(PsiElement element, ResolveState state) {
        if (this.mySearchForGetter ? element instanceof PsiMethod && GroovyPropertyUtils.isSimplePropertyGetter((PsiMethod)element) : element instanceof PsiMethod && GroovyPropertyUtils.isSimplePropertySetter((PsiMethod)element)) {
            return super.execute(element, state);
        }
        return true;
    }
}

