/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring;

import com.intellij.codeInsight.PsiEquivalenceUtil;
import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPackageStatement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.ReflectionCache;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyFileType;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.lexer.TokenSets;
import org.jetbrains.plugins.groovy.lang.psi.GrNamedElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFileBase;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrBlockStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrConstructorInvocation;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrForStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrIfStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrLoopStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrSwitchStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrWhileStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrCodeBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrOpenBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrBreakStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrContinueStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrReturnStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.clauses.GrCaseSection;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrNewExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrParenthesizedExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrSuperReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrThisReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrUnaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrStringInjection;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrEnumConstant;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.util.GrDeclarationHolder;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.refactoring.GroovyNameSuggestionUtil;
import org.jetbrains.plugins.groovy.refactoring.NameValidator;

public abstract class GroovyRefactoringUtil {
    public static final Collection<String> KEYWORDS = ContainerUtil.map((Object[])GroovyTokenTypes.KEYWORDS.getTypes(), (Function)new Function<IElementType, String>(){

        public String fun(IElementType type) {
            return type.toString();
        }
    });
    private static final String[] finalModifiers = new String[]{"final"};

    @Nullable
    public static PsiElement getEnclosingContainer(PsiElement place) {
        PsiElement parent = place.getParent();
        while (parent != null) {
            if (!(!(parent instanceof GrDeclarationHolder) || parent instanceof GrClosableBlock && parent.getParent() instanceof GrStringInjection)) {
                return parent;
            }
            if (parent instanceof GrLoopStatement) {
                return parent;
            }
            parent = parent.getParent();
        }
        return null;
    }

    @Nullable
    public static <T extends PsiElement> T findElementInRange(GroovyFileBase file, int startOffset, int endOffset, Class<T> klass) {
        PsiElement element;
        PsiElement element1 = file.getViewProvider().findElementAt(startOffset, file.getLanguage());
        PsiElement element2 = file.getViewProvider().findElementAt(endOffset - 1, file.getLanguage());
        if (element1 instanceof PsiWhiteSpace) {
            startOffset = element1.getTextRange().getEndOffset();
            element1 = file.getViewProvider().findElementAt(startOffset, file.getLanguage());
        }
        if (element2 instanceof PsiWhiteSpace) {
            endOffset = element2.getTextRange().getStartOffset();
            element2 = file.getViewProvider().findElementAt(endOffset - 1, file.getLanguage());
        }
        if (element2 == null || element1 == null) {
            return null;
        }
        PsiElement commonParent = PsiTreeUtil.findCommonParent((PsiElement)element1, (PsiElement)element2);
        assert (commonParent != null);
        PsiElement psiElement = element = ReflectionCache.isAssignable(klass, commonParent.getClass()) ? commonParent : PsiTreeUtil.getParentOfType((PsiElement)commonParent, klass);
        if (element == null || element.getTextRange().getStartOffset() != startOffset) {
            return null;
        }
        return (T)element;
    }

    public static PsiElement[] getExpressionOccurrences(@NotNull PsiElement expr, @NotNull PsiElement scope) {
        if (expr == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/refactoring/GroovyRefactoringUtil.getExpressionOccurrences must not be null");
        }
        if (scope == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/jetbrains/plugins/groovy/refactoring/GroovyRefactoringUtil.getExpressionOccurrences must not be null");
        }
        ArrayList<PsiElement> occurrences = new ArrayList<PsiElement>();
        Comparator<PsiElement> comparator = new Comparator<PsiElement>(){

            @Override
            public int compare(PsiElement element1, PsiElement element2) {
                if (element1.equals(element2)) {
                    return 0;
                }
                if (element1 instanceof GrParameter && element2 instanceof GrParameter) {
                    String name1 = ((GrParameter)element1).getName();
                    String name2 = ((GrParameter)element2).getName();
                    if (name1 != null && name2 != null) {
                        return name1.compareTo(name2);
                    }
                }
                return 1;
            }
        };
        if (scope instanceof GrLoopStatement) {
            PsiElement son = expr;
            while (son.getParent() != null && !(son.getParent() instanceof GrLoopStatement)) {
                son = son.getParent();
            }
            assert (scope.equals(son.getParent()));
            GroovyRefactoringUtil.collectOccurrences(expr, son, occurrences, comparator);
        } else {
            GroovyRefactoringUtil.collectOccurrences(expr, scope, occurrences, comparator);
        }
        return occurrences.toArray(new PsiElement[occurrences.size()]);
    }

    private static void collectOccurrences(@NotNull PsiElement expr, @NotNull PsiElement scope, @NotNull ArrayList<PsiElement> acc, Comparator<PsiElement> comparator) {
        if (expr == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/refactoring/GroovyRefactoringUtil.collectOccurrences must not be null");
        }
        if (scope == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/jetbrains/plugins/groovy/refactoring/GroovyRefactoringUtil.collectOccurrences must not be null");
        }
        if (acc == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of org/jetbrains/plugins/groovy/refactoring/GroovyRefactoringUtil.collectOccurrences must not be null");
        }
        if (scope.equals(expr)) {
            acc.add(expr);
            return;
        }
        for (PsiElement child : scope.getChildren()) {
            if (child instanceof GrTypeDefinition || child instanceof GrMethod && scope instanceof GroovyFileBase) continue;
            if (PsiEquivalenceUtil.areElementsEquivalent((PsiElement)child, (PsiElement)expr, comparator, (boolean)false)) {
                acc.add(child);
                continue;
            }
            GroovyRefactoringUtil.collectOccurrences(expr, child, acc, comparator);
        }
    }

    public static HashMap<String, PsiType> getCompatibleTypeNames(@NotNull PsiType type) {
        if (type == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/refactoring/GroovyRefactoringUtil.getCompatibleTypeNames must not be null");
        }
        HashMap<String, PsiType> map = new HashMap<String, PsiType>();
        PsiPrimitiveType unboxed = PsiPrimitiveType.getUnboxedType((PsiType)type);
        if (unboxed != null) {
            type = unboxed;
        }
        map.put(type.getPresentableText(), type);
        return map;
    }

    public static GrExpression getUnparenthesizedExpr(GrExpression expr) {
        GrExpression operand = expr;
        while (operand instanceof GrParenthesizedExpression) {
            operand = ((GrParenthesizedExpression)operand).getOperand();
        }
        return operand;
    }

    public static boolean isAppropriateContainerForIntroduceVariable(PsiElement tempContainer) {
        return tempContainer instanceof GrOpenBlock || tempContainer instanceof GrClosableBlock || tempContainer instanceof GroovyFileBase || tempContainer instanceof GrCaseSection || tempContainer instanceof GrLoopStatement;
    }

    @Nullable
    public static PsiElement calculatePositionToInsertBefore(@NotNull PsiElement container, PsiElement expr, PsiElement[] occurences, boolean replaceAllOccurences) {
        PsiElement candidate;
        if (container == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/refactoring/GroovyRefactoringUtil.calculatePositionToInsertBefore must not be null");
        }
        if (occurences.length == 0) {
            return null;
        }
        if (occurences.length == 1 || !replaceAllOccurences) {
            candidate = expr;
        } else {
            GroovyRefactoringUtil.sortOccurrences(occurences);
            candidate = occurences[0];
        }
        while (candidate != null && !container.equals(candidate.getParent())) {
            candidate = candidate.getParent();
        }
        if (candidate == null) {
            return null;
        }
        if (container instanceof GrWhileStatement && candidate.equals(((GrWhileStatement)container).getCondition())) {
            return container;
        }
        if (container instanceof GrIfStatement && candidate.equals(((GrIfStatement)container).getCondition())) {
            return container;
        }
        if (container instanceof GrForStatement && candidate.equals(((GrForStatement)container).getClause())) {
            return container;
        }
        return candidate;
    }

    public static void sortOccurrences(PsiElement[] occurences) {
        Arrays.sort(occurences, new Comparator<PsiElement>(){

            @Override
            public int compare(PsiElement elem1, PsiElement elem2) {
                int offset1 = elem1.getTextRange().getStartOffset();
                int offset2 = elem2.getTextRange().getStartOffset();
                return offset1 - offset2;
            }
        });
    }

    public static boolean isLocalVariable(GrVariable variable) {
        return !(variable instanceof GrField) && !(variable instanceof GrParameter);
    }

    public static void highlightOccurrences(Project project, Editor editor, PsiElement[] elements) {
        if (editor == null) {
            return;
        }
        ArrayList highlighters = new ArrayList();
        HighlightManager highlightManager = HighlightManager.getInstance((Project)project);
        EditorColorsManager colorsManager = EditorColorsManager.getInstance();
        TextAttributes attributes = colorsManager.getGlobalScheme().getAttributes(EditorColors.SEARCH_RESULT_ATTRIBUTES);
        if (elements.length > 0) {
            highlightManager.addOccurrenceHighlights(editor, elements, attributes, false, highlighters);
        }
    }

    public static void highlightOccurrencesByRanges(Project project, Editor editor, TextRange[] ranges) {
        if (editor == null) {
            return;
        }
        ArrayList highlighters = new ArrayList();
        HighlightManager highlightManager = HighlightManager.getInstance((Project)project);
        EditorColorsManager colorsManager = EditorColorsManager.getInstance();
        TextAttributes attributes = colorsManager.getGlobalScheme().getAttributes(EditorColors.SEARCH_RESULT_ATTRIBUTES);
        for (TextRange range : ranges) {
            highlightManager.addRangeHighlight(editor, range.getStartOffset(), range.getEndOffset(), attributes, false, highlighters);
        }
    }

    public static void trimSpacesAndComments(Editor editor, PsiFile file, boolean trimComments) {
        int start = editor.getSelectionModel().getSelectionStart();
        int end = editor.getSelectionModel().getSelectionEnd();
        while (file.findElementAt(start) instanceof PsiWhiteSpace || file.findElementAt(start) instanceof PsiComment && trimComments || file.findElementAt(start) != null && GroovyTokenTypes.mNLS.equals(file.findElementAt(start).getNode().getElementType())) {
            ++start;
        }
        while (file.findElementAt(end - 1) instanceof PsiWhiteSpace || file.findElementAt(end - 1) instanceof PsiComment && trimComments || file.findElementAt(end - 1) != null && (GroovyTokenTypes.mNLS.equals(file.findElementAt(end - 1).getNode().getElementType()) || GroovyTokenTypes.mSEMI.equals(file.findElementAt(end - 1).getNode().getElementType()))) {
            --end;
        }
        editor.getSelectionModel().setSelection(start, end);
    }

    public static PsiElement[] findStatementsInRange(PsiFile file, int startOffset, int endOffset, boolean strict) {
        if (!(file instanceof GroovyFileBase)) {
            return PsiElement.EMPTY_ARRAY;
        }
        Language language = GroovyFileType.GROOVY_FILE_TYPE.getLanguage();
        PsiElement element1 = file.getViewProvider().findElementAt(startOffset, language);
        PsiElement element2 = file.getViewProvider().findElementAt(endOffset - 1, language);
        if (element1 instanceof PsiWhiteSpace || PsiUtil.isNewLine(element1)) {
            startOffset = element1.getTextRange().getEndOffset();
            element1 = file.findElementAt(startOffset);
        }
        if (element2 instanceof PsiWhiteSpace || PsiUtil.isNewLine(element2)) {
            endOffset = element2.getTextRange().getStartOffset();
            element2 = file.findElementAt(endOffset - 1);
        }
        if (element1 == null || element2 == null) {
            return PsiElement.EMPTY_ARRAY;
        }
        PsiElement parent = PsiTreeUtil.findCommonParent((PsiElement)element1, (PsiElement)element2);
        if (parent == null) {
            return PsiElement.EMPTY_ARRAY;
        }
        while (!(parent instanceof GrCodeBlock || parent instanceof GroovyFileBase || parent instanceof GrCaseSection)) {
            if (parent instanceof GrStatement) {
                parent = parent.getParent();
                break;
            }
            if (parent == null) {
                return PsiElement.EMPTY_ARRAY;
            }
            PsiElement prev = parent;
            if (!((parent = parent.getParent()) instanceof GrCodeBlock) || !(prev instanceof LeafPsiElement)) continue;
            parent = parent.getParent();
        }
        if (!parent.equals(element1)) {
            while (!parent.equals(element1.getParent())) {
                element1 = element1.getParent();
            }
        }
        if (startOffset != element1.getTextRange().getStartOffset() && strict) {
            return PsiElement.EMPTY_ARRAY;
        }
        if (!parent.equals(element2)) {
            while (!parent.equals(element2.getParent())) {
                element2 = element2.getParent();
            }
        }
        if (endOffset != element2.getTextRange().getEndOffset() && strict) {
            return PsiElement.EMPTY_ARRAY;
        }
        if (parent instanceof GrCodeBlock && parent.getParent() instanceof GrBlockStatement && element1 == ((GrCodeBlock)parent).getLBrace() && element2 == ((GrCodeBlock)parent).getRBrace()) {
            return new PsiElement[]{parent.getParent()};
        }
        PsiElement[] children = PsiElement.EMPTY_ARRAY;
        PsiElement psiChild = parent.getFirstChild();
        if (psiChild != null) {
            ArrayList<PsiElement> result = new ArrayList<PsiElement>();
            while (psiChild != null) {
                result.add(psiChild);
                psiChild = psiChild.getNextSibling();
            }
            children = result.toArray(new PsiElement[result.size()]);
        }
        ArrayList<PsiElement> possibleStatements = new ArrayList<PsiElement>();
        boolean flag = false;
        for (PsiElement child : children) {
            if (child == element1) {
                flag = true;
            }
            if (flag) {
                possibleStatements.add(child);
            }
            if (child == element2) break;
        }
        for (PsiElement element : possibleStatements) {
            if (element instanceof GrStatement || element instanceof PsiWhiteSpace || element instanceof PsiComment || TokenSets.SEPARATORS.contains(element.getNode().getElementType())) continue;
            return PsiElement.EMPTY_ARRAY;
        }
        return possibleStatements.toArray(new PsiElement[possibleStatements.size()]);
    }

    public static boolean isSuperOrThisCall(GrStatement statement, boolean testForSuper, boolean testForThis) {
        if (!(statement instanceof GrConstructorInvocation)) {
            return false;
        }
        GrConstructorInvocation expr = (GrConstructorInvocation)statement;
        return testForSuper && expr.isSuperCall() || testForThis && expr.isThisCall();
    }

    public static Collection<GrReturnStatement> findReturnStatements(PsiElement element) {
        ArrayList<GrReturnStatement> vector = new ArrayList<GrReturnStatement>();
        if (element instanceof GrMethod) {
            GrOpenBlock block = ((GrMethod)element).getBlock();
            if (block != null) {
                GroovyRefactoringUtil.addReturnStatements(vector, block);
            }
        } else {
            GroovyRefactoringUtil.addReturnStatements(vector, element);
        }
        return vector;
    }

    private static void addReturnStatements(ArrayList<GrReturnStatement> vector, PsiElement element) {
        if (element instanceof GrReturnStatement) {
            vector.add((GrReturnStatement)element);
        } else if (!(element instanceof PsiClass) && !(element instanceof GrClosableBlock)) {
            PsiElement[] children;
            for (PsiElement child : children = element.getChildren()) {
                GroovyRefactoringUtil.addReturnStatements(vector, child);
            }
        }
    }

    public static boolean hasWrongBreakStatements(PsiElement element) {
        ArrayList<GrBreakStatement> vector = new ArrayList<GrBreakStatement>();
        GroovyRefactoringUtil.addBreakStatements(element, vector);
        return !vector.isEmpty();
    }

    private static void addBreakStatements(PsiElement element, ArrayList<GrBreakStatement> vector) {
        if (element instanceof GrBreakStatement) {
            vector.add((GrBreakStatement)element);
        } else if (!(element instanceof GrLoopStatement || element instanceof GrSwitchStatement || element instanceof GrClosableBlock)) {
            for (PsiElement psiElement : element.getChildren()) {
                GroovyRefactoringUtil.addBreakStatements(psiElement, vector);
            }
        }
    }

    public static boolean haswrongContinueStatements(PsiElement element) {
        ArrayList<GrContinueStatement> vector = new ArrayList<GrContinueStatement>();
        GroovyRefactoringUtil.addContinueStatements(element, vector);
        return !vector.isEmpty();
    }

    private static void addContinueStatements(PsiElement element, ArrayList<GrContinueStatement> vector) {
        if (element instanceof GrContinueStatement) {
            vector.add((GrContinueStatement)element);
        } else if (!(element instanceof GrLoopStatement) && !(element instanceof GrClosableBlock)) {
            for (PsiElement psiElement : element.getChildren()) {
                GroovyRefactoringUtil.addContinueStatements(psiElement, vector);
            }
        }
    }

    public static boolean hasTailReturnExpression(GrMethod method) {
        if (method.getReturnType() == PsiType.VOID) {
            return false;
        }
        GrOpenBlock body = method.getBlock();
        if (body == null) {
            return false;
        }
        GrStatement[] statements = body.getStatements();
        if (statements.length == 0) {
            return false;
        }
        GrStatement last = statements[statements.length - 1];
        return last instanceof GrExpression && PsiType.VOID != ((GrExpression)last).getType();
    }

    public static String getMethodSignature(PsiMethod method) {
        PsiType[] types;
        MethodSignature signature = method.getSignature(PsiSubstitutor.EMPTY);
        String s = signature.getName() + "(";
        int i = 0;
        for (PsiType type : types = signature.getParameterTypes()) {
            s = s + type.getPresentableText();
            if (i < types.length - 1) {
                s = s + ", ";
            }
            ++i;
        }
        s = s + ")";
        return s;
    }

    @Nullable
    public static GrCall getCallExpressionByMethodReference(PsiElement ref) {
        if (ref instanceof GrEnumConstant) {
            return (GrEnumConstant)ref;
        }
        if (ref instanceof GrConstructorInvocation) {
            return (GrCall)ref;
        }
        PsiElement parent = ref.getParent();
        if (parent instanceof GrMethodCallExpression) {
            return (GrMethodCallExpression)parent;
        }
        if (parent instanceof GrNewExpression) {
            return (GrNewExpression)parent;
        }
        return null;
    }

    public static boolean isMethodUsage(PsiElement ref) {
        return ref instanceof GrEnumConstant || ref.getParent() instanceof GrCall || ref instanceof GrConstructorInvocation;
    }

    public static String createTempVar(GrExpression expr, final GroovyPsiElement context, boolean declareFinal) {
        GrStatement anchorStatement = (GrStatement)GroovyRefactoringUtil.getParentStatement(context, true);
        assert (anchorStatement != null && anchorStatement.getParent() != null);
        Project project = expr.getProject();
        String[] suggestedNames = GroovyNameSuggestionUtil.suggestVariableNames(expr, new NameValidator(){

            @Override
            public String validateName(String name, boolean increaseNumber) {
                return name;
            }

            @Override
            public Project getProject() {
                return context.getProject();
            }
        });
        String prefix = suggestedNames[0];
        String id = JavaCodeStyleManager.getInstance((Project)project).suggestUniqueVariableName(prefix, (PsiElement)context, true);
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(expr.getProject());
        while (expr instanceof GrParenthesizedExpression) {
            expr = ((GrParenthesizedExpression)expr).getOperand();
        }
        String[] modifiers = declareFinal ? finalModifiers : ArrayUtil.EMPTY_STRING_ARRAY;
        GrVariableDeclaration decl = factory.createVariableDeclaration(modifiers, expr, expr.getType(), id);
        ((GrCodeBlock)anchorStatement.getParent()).addStatementBefore(decl, anchorStatement);
        return id;
    }

    @Nullable
    public static PsiElement getParentStatement(GroovyPsiElement place, boolean skipScopingStatements) {
        GroovyPsiElement parent = place;
        while (!(parent instanceof GrStatement)) {
            if ((parent = parent.getParent()) != null) continue;
            return null;
        }
        GroovyPsiElement parentStatement = parent;
        parent = parentStatement.getParent();
        while (parent instanceof GrStatement) {
            if (!skipScopingStatements && (parent instanceof GrForStatement && parentStatement == ((GrForStatement)parent).getBody() || parent instanceof GrWhileStatement && parentStatement == ((GrWhileStatement)parent).getBody() || parent instanceof GrIfStatement && (parentStatement == ((GrIfStatement)parent).getThenBranch() || parentStatement == ((GrIfStatement)parent).getElseBranch()))) {
                return parentStatement;
            }
            parentStatement = parent;
            parent = parent.getParent();
        }
        return parentStatement;
    }

    public static GrExpression convertJavaExpr2GroovyExpr(PsiElement expr) {
        PsiImportList importList;
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(expr.getProject());
        final ArrayList localVariables = new ArrayList();
        final ArrayList fields = new ArrayList();
        final ArrayList parameters = new ArrayList();
        expr.accept((PsiElementVisitor)new JavaRecursiveElementVisitor(){

            public void visitReferenceExpression(PsiReferenceExpression expression) {
                PsiExpression qualifierExpression = expression.getQualifierExpression();
                if (qualifierExpression != null && !(qualifierExpression instanceof PsiThisExpression)) {
                    return;
                }
                PsiElement el = expression.resolve();
                if (el instanceof PsiField) {
                    fields.add((PsiField)el);
                } else if (el instanceof PsiParameter) {
                    parameters.add((PsiParameter)el);
                } else if (el instanceof PsiLocalVariable) {
                    localVariables.add((PsiLocalVariable)el);
                }
                super.visitReferenceExpression(expression);
            }
        });
        PsiJavaFile file = (PsiJavaFile)expr.getContainingFile();
        StringBuilder cf = new StringBuilder();
        PsiPackageStatement packageStatement = file.getPackageStatement();
        if (packageStatement != null) {
            cf.append(packageStatement.getText());
        }
        if ((importList = file.getImportList()) != null) {
            cf.append(importList.getText());
        }
        cf.append("class A{");
        for (PsiField field : fields) {
            cf.append(field.getText());
        }
        cf.append("void foo(");
        int parametersSize = parameters.size() - 1;
        for (int i = 0; i < parametersSize; ++i) {
            PsiParameter parameter = (PsiParameter)parameters.get(i);
            cf.append(parameter.getText()).append(',');
        }
        if (parameters.size() > 0) {
            cf.append(((PsiParameter)parameters.get(parameters.size() - 1)).getText());
        }
        cf.append("){");
        for (PsiLocalVariable localVariable : localVariables) {
            cf.append(localVariable.getText());
        }
        cf.append("Object _________________ooooooo_______________=");
        cf.append(expr.getText());
        cf.append(";}}");
        GroovyFile grFile = factory.createGroovyFile(cf.toString(), false, expr);
        GrMethod method = (GrMethod)grFile.getClasses()[0].getMethods()[0];
        GrVariableDeclaration variableDeclaration = (GrVariableDeclaration)method.getBlock().getStatements()[0];
        return variableDeclaration.getVariables()[0].getInitializerGroovy();
    }

    public static int verifySafeCopyExpression(GrExpression expression) {
        return GroovyRefactoringUtil.verifySafeCopyExpressionSubElement(expression);
    }

    private static int verifySafeCopyExpressionSubElement(PsiElement element) {
        PsiElement[] children;
        int result = 0;
        if (element == null) {
            return result;
        }
        if (element instanceof GrThisReferenceExpression || element instanceof GrSuperReferenceExpression || element instanceof GrNamedElement) {
            return 0;
        }
        if (element instanceof GrMethodCallExpression) {
            result = 1;
        }
        if (element instanceof GrNewExpression) {
            return 2;
        }
        if (element instanceof GrAssignmentExpression) {
            return 2;
        }
        if (element instanceof GrClosableBlock) {
            return 2;
        }
        if (GroovyRefactoringUtil.isPlusPlusOrMinusMinus(element)) {
            return 2;
        }
        for (PsiElement child : children = element.getChildren()) {
            int childResult = GroovyRefactoringUtil.verifySafeCopyExpressionSubElement(child);
            result = Math.max(result, childResult);
        }
        return result;
    }

    public static boolean isPlusPlusOrMinusMinus(PsiElement element) {
        if (element instanceof GrUnaryExpression) {
            IElementType operandSign = ((GrUnaryExpression)element).getOperationTokenType();
            return operandSign == GroovyTokenTypes.mDEC || operandSign == GroovyTokenTypes.mINC;
        }
        return false;
    }
}

