/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.structure.itemsPresentations.impl;

import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.structure.itemsPresentations.GroovyItemPresentation;

public class GroovyMethodItemPresentation
extends GroovyItemPresentation {
    private final boolean isInherit;
    private final NotNullLazyValue<String> myPresentableText = new NotNullLazyValue<String>(){

        @NotNull
        protected String compute() {
            PsiType returnType;
            PsiMethod method = (PsiMethod)GroovyMethodItemPresentation.this.myElement;
            StringBuilder presentableText = new StringBuilder();
            presentableText.append(method.getName());
            presentableText.append(" ");
            PsiParameterList paramList = method.getParameterList();
            PsiParameter[] parameters = paramList.getParameters();
            presentableText.append("(");
            for (int i = 0; i < parameters.length; ++i) {
                if (i > 0) {
                    presentableText.append(", ");
                }
                presentableText.append(parameters[i].getType().getPresentableText());
            }
            presentableText.append(")");
            PsiType psiType = returnType = method instanceof GrMethod ? ((GrMethod)method).getDeclaredReturnType() : method.getReturnType();
            if (returnType != null) {
                presentableText.append(":");
                presentableText.append(returnType.getPresentableText());
            }
            String string = presentableText.toString();
            if (string == null) {
                throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/structure/itemsPresentations/impl/GroovyMethodItemPresentation$1.compute must not return null");
            }
            return string;
        }
    };

    public GroovyMethodItemPresentation(PsiMethod myElement, boolean isInherit) {
        super((PsiElement)myElement);
        this.isInherit = isInherit;
    }

    public String getPresentableText() {
        return (String)this.myPresentableText.getValue();
    }

    @Override
    @Nullable
    public TextAttributesKey getTextAttributesKey() {
        return this.isInherit ? CodeInsightColors.NOT_USED_ELEMENT_ATTRIBUTES : null;
    }
}

