/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn;

import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import org.jetbrains.idea.svn.NestedCopyType;
import org.jetbrains.idea.svn.RootUrlPair;
import org.jetbrains.idea.svn.WorkingCopyFormat;
import org.tmatesoft.svn.core.SVNURL;

public class RootUrlInfo
implements RootUrlPair {
    private final SVNURL myRepositoryUrlUrl;
    private final String myRepositoryUrl;
    private final SVNURL myAbsoluteUrlAsUrl;
    private final WorkingCopyFormat myFormat;
    private final File myIoFile;
    private final VirtualFile myVfile;
    private final VirtualFile myRoot;
    private NestedCopyType myType;

    public RootUrlInfo(SVNURL repositoryUrl, SVNURL absoluteUrlAsUrl, WorkingCopyFormat format, VirtualFile vfile, VirtualFile root) {
        this.myRepositoryUrlUrl = repositoryUrl;
        this.myFormat = format;
        this.myVfile = vfile;
        this.myRoot = root;
        this.myIoFile = new File(this.myVfile.getPath());
        String asString = repositoryUrl.toString();
        this.myRepositoryUrl = asString.endsWith("/") ? asString.substring(0, asString.length() - 1) : asString;
        this.myAbsoluteUrlAsUrl = absoluteUrlAsUrl;
    }

    public String getRepositoryUrl() {
        return this.myRepositoryUrl;
    }

    public SVNURL getRepositoryUrlUrl() {
        return this.myRepositoryUrlUrl;
    }

    public String getAbsoluteUrl() {
        return this.myAbsoluteUrlAsUrl.toString();
    }

    public SVNURL getAbsoluteUrlAsUrl() {
        return this.myAbsoluteUrlAsUrl;
    }

    public WorkingCopyFormat getFormat() {
        return this.myFormat;
    }

    public File getIoFile() {
        return this.myIoFile;
    }

    public VirtualFile getRoot() {
        return this.myRoot;
    }

    @Override
    public VirtualFile getVirtualFile() {
        return this.myVfile;
    }

    @Override
    public String getUrl() {
        return this.myAbsoluteUrlAsUrl.toString();
    }

    public NestedCopyType getType() {
        return this.myType;
    }

    public void setType(NestedCopyType type) {
        this.myType = type;
    }
}

